/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class XMLUserType
implements UserType {
    private static final java.lang.String XML_TYPE_PACKAGE_NSURI = "http://www.eclipse.org/emf/2003/XMLType";
    private EDataType eDataType = null;
    private int[] sqlTypes = null;

    public Object assemble(Serializable arg0, Object arg1) throws HibernateException {
        return arg1;
    }

    public Object deepCopy(Object arg0) throws HibernateException {
        return arg0;
    }

    public Serializable disassemble(Object arg0) throws HibernateException {
        return (Serializable)arg0;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null && y == null) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.getClass() != y.getClass()) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object arg0) throws HibernateException {
        return arg0.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    protected java.lang.String convertToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (java.lang.String)value;
        }
        if (this.getEDataType() == null) {
            return value.toString();
        }
        EDataType eDataType = this.getEDataType();
        return eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, value);
    }

    protected Object convertToObject(java.lang.String value) {
        if (this.getEDataType() == null || value == null) {
            return value;
        }
        EDataType eDataType = this.getEDataType();
        return eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, value);
    }

    private EDataType getEDataType() {
        if (this.eDataType != null) {
            return this.eDataType;
        }
        CDOPackageRegistry packageRegistry = HibernateUtil.getInstance().getPackageRegistry();
        EPackage ePackage = packageRegistry.getEPackage(XML_TYPE_PACKAGE_NSURI);
        if (ePackage == null) {
            throw new IllegalStateException("EPackage with nsuri http://www.eclipse.org/emf/2003/XMLType not found");
        }
        EClassifier eClassifier = ePackage.getEClassifier(this.getEDataTypeName());
        if (eClassifier == null || !(eClassifier instanceof EDataType)) {
            throw new IllegalStateException("EPackage " + ePackage.getName() + " does not have an EEnum with name " + this.getEDataTypeName());
        }
        this.eDataType = (EDataType)eClassifier;
        return this.eDataType;
    }

    protected java.lang.String getEDataTypeName() {
        if (this.getClass() != XMLUserType.class) {
            return this.getClass().getSimpleName();
        }
        return "String";
    }

    public Object nullSafeGet(ResultSet arg0, java.lang.String[] arg1, Object arg2) throws HibernateException, SQLException {
        Object value = arg0.getObject(arg1[0]);
        if (arg0.wasNull()) {
            return null;
        }
        return this.convertToString(value);
    }

    public void nullSafeSet(PreparedStatement arg0, Object arg1, int arg2) throws HibernateException, SQLException {
        if (arg1 == null) {
            arg0.setNull(arg2, this.sqlTypes()[0]);
        } else if (arg1 instanceof java.lang.String) {
            arg0.setObject(arg2, this.convertToObject((java.lang.String)arg1), this.getSqlType());
        } else {
            arg0.setObject(arg2, arg1, this.getSqlType());
        }
    }

    public Object replace(Object arg0, Object arg1, Object arg2) throws HibernateException {
        return arg0;
    }

    public Class returnedClass() {
        if (this.getEDataType() == null || this.getEDataType().getInstanceClass() == null) {
            return String.class;
        }
        return this.getEDataType().getInstanceClass();
    }

    public int[] sqlTypes() {
        if (this.sqlTypes == null) {
            this.sqlTypes = new int[]{this.getSqlType()};
        }
        return this.sqlTypes;
    }

    protected int getSqlType() {
        return 12;
    }

    public static class AnySimpleType
    extends XMLUserType {
    }

    public static class AnyURI
    extends XMLUserType {
    }

    public static class Base64Binary
    extends XMLUserType {
        protected int getSqlType() {
            return 2004;
        }
    }

    public static class Boolean
    extends XMLUserType {
        protected int getSqlType() {
            return -7;
        }
    }

    public static class BooleanObject
    extends XMLUserType {
        protected int getSqlType() {
            return 16;
        }
    }

    public static class Byte
    extends XMLUserType {
        protected int getSqlType() {
            return -6;
        }
    }

    public static class ByteObject
    extends XMLUserType {
        protected int getSqlType() {
            return -6;
        }
    }

    public static class Date
    extends XMLUserType {
        protected java.lang.String convertToString(Object value) {
            if (value == null) {
                return super.convertToString(value);
            }
            return super.convertToString(HibernateUtil.getInstance().getXMLGregorianCalendarDate((java.util.Date)value, false));
        }

        protected Object convertToObject(java.lang.String value) {
            return new java.sql.Date(((XMLGregorianCalendar)super.convertToObject(value)).toGregorianCalendar().getTime().getTime());
        }

        protected int getSqlType() {
            return 91;
        }
    }

    public static class DateTime
    extends XMLUserType {
        protected java.lang.String convertToString(Object value) {
            if (value == null) {
                return super.convertToString(value);
            }
            return super.convertToString(HibernateUtil.getInstance().getXMLGregorianCalendarDate((java.util.Date)value, true));
        }

        protected Object convertToObject(java.lang.String value) {
            return new Timestamp(((XMLGregorianCalendar)super.convertToObject(value)).toGregorianCalendar().getTime().getTime());
        }

        protected int getSqlType() {
            return 93;
        }
    }

    public static class Decimal
    extends XMLUserType {
        protected int getSqlType() {
            return 2;
        }
    }

    public static class Double
    extends XMLUserType {
        protected int getSqlType() {
            return 8;
        }
    }

    public static class DoubleObject
    extends XMLUserType {
        protected int getSqlType() {
            return 8;
        }
    }

    public static class Duration
    extends XMLUserType {
    }

    public static class ENTITIES
    extends XMLUserType {
    }

    public static class ENTITIESBase
    extends XMLUserType {
    }

    public static class ENTITY
    extends XMLUserType {
    }

    public static class Float
    extends XMLUserType {
        protected int getSqlType() {
            return 6;
        }
    }

    public static class FloatObject
    extends XMLUserType {
        protected int getSqlType() {
            return 6;
        }
    }

    public static class GDay
    extends XMLUserType {
    }

    public static class GMonth
    extends XMLUserType {
    }

    public static class GMonthDay
    extends XMLUserType {
    }

    public static class GYear
    extends XMLUserType {
    }

    public static class GYearMonth
    extends XMLUserType {
    }

    public static class HexBinary
    extends XMLUserType {
    }

    public static class ID
    extends XMLUserType {
    }

    public static class IDREF
    extends XMLUserType {
    }

    public static class IDREFS
    extends XMLUserType {
    }

    public static class IDREFSBase
    extends XMLUserType {
    }

    public static class Int
    extends XMLUserType {
        protected int getSqlType() {
            return 4;
        }
    }

    public static class IntObject
    extends XMLUserType {
        protected int getSqlType() {
            return -5;
        }
    }

    public static class Integer
    extends XMLUserType {
        protected int getSqlType() {
            return -5;
        }
    }

    public static class Language
    extends XMLUserType {
    }

    public static class Long
    extends XMLUserType {
        protected int getSqlType() {
            return -5;
        }
    }

    public static class LongObject
    extends XMLUserType {
        protected int getSqlType() {
            return -5;
        }
    }

    public static class NCName
    extends XMLUserType {
    }

    public static class NMTOKEN
    extends XMLUserType {
    }

    public static class NMTOKENS
    extends XMLUserType {
    }

    public static class NMTOKENSBase
    extends XMLUserType {
    }

    public static class NOTATION
    extends XMLUserType {
    }

    public static class Name
    extends XMLUserType {
    }

    public static class NegativeInteger
    extends XMLUserType {
        protected int getSqlType() {
            return -5;
        }
    }

    public static class NonNegativeInteger
    extends XMLUserType {
        protected int getSqlType() {
            return -5;
        }
    }

    public static class NonPositiveInteger
    extends XMLUserType {
        protected int getSqlType() {
            return -5;
        }
    }

    public static class NormalizedString
    extends XMLUserType {
    }

    public static class PositiveInteger
    extends XMLUserType {
        protected int getSqlType() {
            return -5;
        }
    }

    public static class QName
    extends XMLUserType {
    }

    public static class Short
    extends XMLUserType {
        protected int getSqlType() {
            return 4;
        }
    }

    public static class ShortObject
    extends XMLUserType {
        protected int getSqlType() {
            return 4;
        }
    }

    public static class String
    extends XMLUserType {
    }

    public static class Time
    extends XMLUserType {
        protected int getSqlType() {
            return 92;
        }
    }

    public static class Token
    extends XMLUserType {
    }

    public static class UnsignedByte
    extends XMLUserType {
        protected int getSqlType() {
            return -6;
        }
    }

    public static class UnsignedByteObject
    extends XMLUserType {
        protected int getSqlType() {
            return -6;
        }
    }

    public static class UnsignedInt
    extends XMLUserType {
        protected int getSqlType() {
            return 4;
        }
    }

    public static class UnsignedIntObject
    extends XMLUserType {
        protected int getSqlType() {
            return 4;
        }
    }

    public static class UnsignedLong
    extends XMLUserType {
        protected int getSqlType() {
            return -5;
        }
    }

    public static class UnsignedShort
    extends XMLUserType {
        protected int getSqlType() {
            return 4;
        }
    }

    public static class UnsignedShortObject
    extends XMLUserType {
        protected int getSqlType() {
            return 4;
        }
    }
}

