/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.hibernate.collection.PersistentCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistableListHolder {
    private static PersistableListHolder instance = new PersistableListHolder();
    private static ThreadLocal<Map<Key, PersistentCollection>> listMapping = new ThreadLocal();

    public void putListMapping(Object target, EStructuralFeature feature, PersistentCollection collection) {
        Key key = new Key(target, feature);
        PersistentCollection currentCachedValue = this.getListMapping(target, feature);
        if (currentCachedValue == collection) {
            return;
        }
        if (currentCachedValue != null) {
            throw new IllegalStateException("There is already a list mapping present");
        }
        this.getListMapping().put(key, collection);
    }

    public PersistentCollection getListMapping(Object target, EStructuralFeature feature) {
        Key key = new Key(target, feature);
        return this.getListMapping().get(key);
    }

    private Map<Key, PersistentCollection> getListMapping() {
        if (listMapping.get() == null) {
            listMapping.set(new HashMap());
        }
        return listMapping.get();
    }

    public void clearListMapping() {
        listMapping.set(null);
    }

    public static PersistableListHolder getInstance() {
        return instance;
    }

    public static void setInstance(PersistableListHolder instance) {
        PersistableListHolder.instance = instance;
    }

    private static final class Key {
        private Object owner;
        private EStructuralFeature feature;

        public Key(Object owner, EStructuralFeature feature) {
            this.owner = owner;
            this.feature = feature;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)obj;
            return this.owner == otherKey.owner && this.feature == otherKey.feature;
        }

        public int hashCode() {
            return this.owner.hashCode() + this.feature.hashCode();
        }
    }
}

