/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.net4j.util.collection.MoveableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateMoveableListWrapper
implements MoveableList<Object> {
    private List<Object> delegate;

    public Object move(int targetIndex, int sourceIndex) {
        int size = this.size();
        if (sourceIndex >= size) {
            throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=" + size);
        }
        if (targetIndex >= size) {
            throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + size);
        }
        Object object = this.get(sourceIndex);
        if (targetIndex == sourceIndex) {
            return object;
        }
        if (targetIndex < sourceIndex) {
            this.moveUp1(targetIndex, sourceIndex - targetIndex);
        } else {
            this.moveDown1(targetIndex, targetIndex - sourceIndex);
        }
        this.set(targetIndex, object);
        return object;
    }

    private void moveUp1(int index, int count) {
        int i = count;
        while (i > 0) {
            this.set(index + i, this.get(index + i - 1));
            --i;
        }
    }

    private void moveDown1(int index, int count) {
        int i = count;
        while (i > 0) {
            this.set(index - i, this.get(index - i + 1));
            --i;
        }
    }

    public List<Object> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(List<Object> delegate) {
        this.delegate = delegate;
    }

    protected Object getObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CDOID && CDOIDUtil.isNull((CDOID)((CDOID)o))) {
            return null;
        }
        if (o instanceof CDOIDExternal) {
            return o;
        }
        if (!(o instanceof CDOID)) {
            return o;
        }
        return HibernateUtil.getInstance().getCDORevision((CDOID)o);
    }

    protected List<Object> getObjects(List<?> ids) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object o : ids) {
            result.add(this.getObject(o));
        }
        return result;
    }

    protected Object getValue(Object o) {
        if (o instanceof CDOIDExternal) {
            return o;
        }
        if (!(o instanceof CDORevision)) {
            return o;
        }
        return HibernateUtil.getInstance().getCDOID(o);
    }

    protected List<Object> getValues(Collection<?> c) {
        ArrayList<Object> newC = new ArrayList<Object>();
        for (Object o : c) {
            newC.add(this.getValue(o));
        }
        return newC;
    }

    public void add(int index, Object element) {
        this.getDelegate().add(index, this.getValue(element));
    }

    public boolean add(Object o) {
        return this.getDelegate().add(this.getValue(o));
    }

    public boolean addAll(Collection<? extends Object> c) {
        return this.getDelegate().addAll(this.getValues(c));
    }

    public boolean addAll(int index, Collection<? extends Object> c) {
        return this.getDelegate().addAll(index, this.getValues(c));
    }

    public void clear() {
        this.getDelegate().clear();
    }

    public boolean contains(Object o) {
        return this.getDelegate().contains(this.getValue(o));
    }

    public boolean containsAll(Collection<?> c) {
        return this.getDelegate().containsAll(this.getValues(c));
    }

    public Object get(int index) {
        return this.getObject(this.getDelegate().get(index));
    }

    public int indexOf(Object o) {
        return this.getDelegate().indexOf(this.getValue(o));
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public Iterator<Object> iterator() {
        return new CDOHibernateIterator(this.getDelegate().iterator());
    }

    public int lastIndexOf(Object o) {
        return this.getDelegate().lastIndexOf(this.getValue(o));
    }

    public ListIterator<Object> listIterator() {
        return new CDOHibernateListIterator(this.getDelegate().listIterator());
    }

    public ListIterator<Object> listIterator(int index) {
        return new CDOHibernateListIterator(this.getDelegate().listIterator(index));
    }

    public Object remove(int index) {
        return this.getDelegate().remove(index);
    }

    public boolean remove(Object o) {
        return this.getDelegate().remove(this.getValue(o));
    }

    public boolean removeAll(Collection<?> c) {
        return this.getDelegate().removeAll(this.getValues(c));
    }

    public boolean retainAll(Collection<?> c) {
        return this.getDelegate().retainAll(this.getValues(c));
    }

    public Object set(int index, Object element) {
        return this.getDelegate().set(index, this.getValue(element));
    }

    public int size() {
        return this.getDelegate().size();
    }

    public List<Object> subList(int fromIndex, int toIndex) {
        return this.getObjects(this.getDelegate().subList(fromIndex, toIndex));
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        Iterator<Object> iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            result[i++] = o;
        }
        return result;
    }

    public <T> T[] toArray(T[] a) {
        int i = 0;
        Iterator<Object> iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            a[i++] = o;
        }
        return a;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CDOHibernateIterator
    implements Iterator<Object> {
        private final Iterator<?> delegate;

        public CDOHibernateIterator(Iterator<?> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object next() {
            Object o = this.delegate.next();
            if (o instanceof CDOIDExternal) {
                return o;
            }
            if (o instanceof CDOID) {
                return HibernateUtil.getInstance().getCDORevision((CDOID)o);
            }
            return o;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CDOHibernateListIterator
    implements ListIterator<Object> {
        private final ListIterator<Object> delegate;

        public CDOHibernateListIterator(ListIterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void add(Object o) {
            this.delegate.add(HibernateUtil.getInstance().getCDOID(o));
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public Object next() {
            Object o = this.delegate.next();
            if (o instanceof CDOID) {
                return HibernateUtil.getInstance().getCDORevision((CDOID)this.delegate.next());
            }
            return o;
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public Object previous() {
            Object o = this.delegate.previous();
            if (o instanceof CDOID) {
                return HibernateUtil.getInstance().getCDORevision((CDOID)this.delegate.next());
            }
            return o;
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void set(Object o) {
            this.delegate.set(HibernateUtil.getInstance().getCDOID(o));
        }
    }
}

