/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCommitContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.spi.common.revision.CDOFeatureMapEntry;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.hibernate.HibernateException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;

public class FeatureMapEntryFeatureURIPropertyHandler
implements PropertyAccessor,
Getter,
Setter {
    private static final String EFEATURE_SEPARATOR = "#";
    private static final long serialVersionUID = 1L;

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Member getMember() {
        return null;
    }

    public Object get(Object owner) throws HibernateException {
        CDOFeatureMapEntry cdoFeatureMapEntry = (CDOFeatureMapEntry)owner;
        return this.getEStructuralFeatureAsString(cdoFeatureMapEntry);
    }

    public Object getForInsert(Object owner, Map mergeMap, SessionImplementor session) throws HibernateException {
        return this.get(owner);
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return null;
    }

    public Class getReturnType() {
        return String.class;
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        CDOFeatureMapEntry cdoFeatureMapEntry = (CDOFeatureMapEntry)target;
        this.setEStructuralFeatureFromString(cdoFeatureMapEntry, (String)value);
    }

    private void setEStructuralFeatureFromString(CDOFeatureMapEntry fmEntry, String eFeatureURI) {
        int firstSeparator = eFeatureURI.indexOf(EFEATURE_SEPARATOR);
        int lastSeparator = eFeatureURI.lastIndexOf(EFEATURE_SEPARATOR);
        if (firstSeparator == -1 || lastSeparator == -1 || firstSeparator == lastSeparator) {
            throw new IllegalArgumentException("EFeature URI " + eFeatureURI + " has an illegal format");
        }
        String ePackageURI = eFeatureURI.substring(0, firstSeparator);
        String eClassName = eFeatureURI.substring(1 + firstSeparator, lastSeparator);
        String eFeatureName = eFeatureURI.substring(1 + lastSeparator);
        HibernateCommitContext hbCommitContext = HibernateThreadContext.getCommitContext();
        EPackage ePackage = hbCommitContext.getCommitContext().getPackageRegistry().getEPackage(ePackageURI);
        if (ePackage == null) {
            throw new IllegalArgumentException("EPackage not found using " + eFeatureURI + " and EPackageURI: " + ePackageURI);
        }
        EClass eClass = (EClass)ePackage.getEClassifier(eClassName);
        if (eClass == null) {
            throw new IllegalArgumentException("EClass not found using " + eFeatureURI + " and EClass name " + eClassName);
        }
        EStructuralFeature eFeature = eClass.getEStructuralFeature(eFeatureName);
        if (eFeature == null) {
            throw new IllegalArgumentException("EClass not found using " + eFeatureURI + ", EClass name " + eClassName + " and EFeature name " + eFeatureName);
        }
        fmEntry.setEStructuralFeature(eFeature);
    }

    private String getEStructuralFeatureAsString(CDOFeatureMapEntry fmEntry) {
        EStructuralFeature eFeature = fmEntry.getEStructuralFeature();
        EClass eClass = eFeature.getEContainingClass();
        return String.valueOf(eClass.getEPackage().getNsURI()) + EFEATURE_SEPARATOR + eClass.getName() + EFEATURE_SEPARATOR + eFeature.getName();
    }
}

