/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCommitContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClassifier;
import org.hibernate.HibernateException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;

public class CDOSyntheticIdPropertyHandler
implements Getter,
Setter,
PropertyAccessor {
    private static final long serialVersionUID = 1L;

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Member getMember() {
        return null;
    }

    public Object get(Object owner) throws HibernateException {
        InternalCDORevision revision = HibernateUtil.getInstance().getCDORevision(owner);
        if (revision == null) {
            return null;
        }
        if (!HibernateUtil.getInstance().isStoreCreatedID(HibernateUtil.getInstance().getCDOID(revision))) {
            return null;
        }
        return HibernateUtil.getInstance().getIdValue(HibernateUtil.getInstance().getCDOID(revision));
    }

    public Object getForInsert(Object arg0, Map arg1, SessionImplementor arg2) throws HibernateException {
        return this.get(arg0);
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return null;
    }

    public Class getReturnType() {
        return null;
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (value == null) {
            return;
        }
        InternalCDORevision revision = HibernateUtil.getInstance().getCDORevision(target);
        CDOID id = HibernateUtil.getInstance().getCDOID(revision);
        if (id == null || id instanceof CDOIDTemp) {
            CDOID newCDOID = HibernateUtil.getInstance().createCDOID(new CDOClassifierRef((EClassifier)revision.getEClass()), value);
            revision.setID(newCDOID);
            if (HibernateThreadContext.isCommitContextSet()) {
                HibernateCommitContext commitContext = HibernateThreadContext.getCommitContext();
                commitContext.setNewID(id, newCDOID);
                if (id instanceof CDOIDTemp) {
                    commitContext.getCommitContext().addIDMapping(id, newCDOID);
                }
            }
        } else {
            Serializable idValue = HibernateUtil.getInstance().getIdValue(id);
            if (!idValue.equals(value)) {
                throw new IllegalStateException("Current id and new id are different " + value + "/" + idValue);
            }
        }
    }
}

