/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOContainerGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOContainerSetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOIDPropertyGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOIDPropertySetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOManyAttributeGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOManyAttributeSetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOManyReferenceGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOManyReferenceSetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOPropertyGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOPropertySetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOReferenceGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOReferenceSetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOResourceIDGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOResourceIDSetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionInstantiator;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionProxyFactory;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOVersionPropertyGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOVersionPropertySetter;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;

public class CDORevisionTuplizer
extends AbstractEntityTuplizer {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDORevisionTuplizer.class);
    private static final String EPACKAGE_META = "epackage";
    private static final String ECLASSNAME_META = "eclassName";
    private EClass eClass;

    public CDORevisionTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappingInfo) {
        super(entityMetamodel, mappingInfo);
        if (TRACER.isEnabled()) {
            TRACER.trace("Created CDORevisionTuplizer for entity " + mappingInfo.getEntityName());
        }
        this.initEClass(mappingInfo);
    }

    private void initEClass(PersistentClass mappingInfo) {
        if (this.eClass != null) {
            return;
        }
        HibernateStore hbStore = HibernateStore.getCurrentHibernateStore();
        String entityName = mappingInfo.getEntityName();
        String ePackageURI = mappingInfo.getMetaAttribute(EPACKAGE_META).getValue();
        String eClassName = mappingInfo.getMetaAttribute(ECLASSNAME_META).getValue();
        if (ePackageURI == null || eClassName == null) {
            throw new IllegalArgumentException("The mapping for the persistentclass " + mappingInfo.getEntityName() + " is incorrect, there should be meta data tags for both epackage and " + "eclassname, one or both are missing.");
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("EntityName/eclassname/packageURI " + entityName + "/" + eClassName + "/" + ePackageURI);
        }
        block0: for (EPackage ePackage : hbStore.getPackageHandler().getEPackages()) {
            if (ePackage.getNsURI().compareTo(ePackageURI) != 0) continue;
            EClass[] eClassArray = EMFUtil.getPersistentClasses((EPackage)ePackage);
            int n = eClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                EClass localCdoClass = eClassArray[n2];
                if (localCdoClass.getName().compareTo(eClassName) == 0) {
                    this.eClass = localCdoClass;
                    continue block0;
                }
                ++n2;
            }
        }
        if (this.eClass == null && ePackageURI.compareTo(EresourcePackage.eINSTANCE.getNsURI()) == 0) {
            EClass[] eClassArray = EMFUtil.getPersistentClasses((EPackage)EresourcePackage.eINSTANCE);
            int n = eClassArray.length;
            int n3 = 0;
            while (n3 < n) {
                EClass localCdoClass = eClassArray[n3];
                if (localCdoClass.getName().compareTo(eClassName) == 0) {
                    this.eClass = localCdoClass;
                    if (!TRACER.isEnabled()) break;
                    TRACER.trace("Class is CDOResource class");
                    break;
                }
                ++n3;
            }
        }
        HibernateStore.getCurrentHibernateStore().addEntityNameEClassMapping(entityName, this.eClass);
        if (this.eClass == null) {
            throw new IllegalArgumentException("The mapped class " + mappingInfo.getEntityName() + " does not have a eClass equivalent");
        }
    }

    public String determineConcreteSubclassEntityName(Object entityInstance, SessionFactoryImplementor factory) {
        Class<?> concreteEntityClass = entityInstance.getClass();
        if (concreteEntityClass == this.getMappedClass()) {
            return this.getEntityName();
        }
        String entityName = this.getEntityMetamodel().findEntityNameByEntityClass(concreteEntityClass);
        if (entityName == null) {
            throw new HibernateException("Unable to resolve entity name from Class [" + concreteEntityClass.getName() + "]" + " expected instance/subclass of [" + this.getEntityName() + "]");
        }
        return entityName;
    }

    public EntityMode getEntityMode() {
        return EntityMode.MAP;
    }

    public EntityNameResolver[] getEntityNameResolvers() {
        return new EntityNameResolver[]{new CDOEntityNameResolver()};
    }

    public EClass getEClass() {
        return this.eClass;
    }

    protected Getter buildPropertyGetter(Property mappedProperty, PersistentClass mappedEntity) {
        this.initEClass(mappedEntity);
        if (TRACER.isEnabled()) {
            TRACER.trace("Building property getter for " + this.eClass.getName() + "." + mappedProperty.getName());
        }
        if (mappedProperty.isBackRef()) {
            return mappedProperty.getGetter(mappedEntity.getMappedClass());
        }
        if (mappedProperty == mappedEntity.getIdentifierProperty()) {
            return new CDOIDPropertyGetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getMetaAttribute("version") != null) {
            return new CDOVersionPropertyGetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getName().compareTo("resourceID") == 0) {
            return new CDOResourceIDGetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getName().compareTo("containerID") == 0) {
            return new CDOContainerGetter(this, mappedProperty.getName());
        }
        EStructuralFeature feature = this.getEClass().getEStructuralFeature(mappedProperty.getName());
        if (feature instanceof EReference && feature.isMany()) {
            return new CDOManyReferenceGetter(this, mappedProperty.getName());
        }
        if (feature instanceof EReference) {
            return new CDOReferenceGetter(this, mappedProperty.getName());
        }
        if (feature instanceof EAttribute && feature.isMany()) {
            return new CDOManyAttributeGetter(this, mappedProperty.getName());
        }
        return new CDOPropertyGetter(this, mappedProperty.getName());
    }

    protected Setter buildPropertySetter(Property mappedProperty, PersistentClass mappedEntity) {
        this.initEClass(mappedEntity);
        if (TRACER.isEnabled()) {
            TRACER.trace("Building property setter for " + this.eClass.getName() + "." + mappedProperty.getName());
        }
        if (mappedProperty.isBackRef()) {
            return mappedProperty.getSetter(mappedEntity.getMappedClass());
        }
        if (mappedProperty == mappedEntity.getIdentifierProperty()) {
            this.setIdentifierTypeAsAnnotation(mappedProperty);
            return new CDOIDPropertySetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getMetaAttribute("version") != null) {
            return new CDOVersionPropertySetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getName().compareTo("resourceID") == 0) {
            return new CDOResourceIDSetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getName().compareTo("containerID") == 0) {
            return new CDOContainerSetter(this, mappedProperty.getName());
        }
        EStructuralFeature feature = this.getEClass().getEStructuralFeature(mappedProperty.getName());
        if (feature instanceof EReference && feature.isMany()) {
            return new CDOManyReferenceSetter(this, mappedProperty.getName());
        }
        if (feature instanceof EAttribute && feature.isMany()) {
            return new CDOManyAttributeSetter(this, mappedProperty.getName());
        }
        if (feature instanceof EReference) {
            return new CDOReferenceSetter(this, mappedProperty.getName());
        }
        return new CDOPropertySetter(this, mappedProperty.getName());
    }

    protected Instantiator buildInstantiator(PersistentClass mappingInfo) {
        return new CDORevisionInstantiator(this, mappingInfo);
    }

    protected ProxyFactory buildProxyFactory(PersistentClass mappingInfo, Getter idGetter, Setter idSetter) {
        CDORevisionProxyFactory pf = new CDORevisionProxyFactory();
        pf.setEntityName(this.getEntityName());
        try {
            pf.postInstantiate(this.getEntityName(), null, null, null, null, null);
        }
        catch (HibernateException ex) {
            OM.LOG.error("Could not create proxy factory for " + this.getEntityName(), (Throwable)ex);
            pf = null;
        }
        return pf;
    }

    public Class getMappedClass() {
        return InternalCDORevision.class;
    }

    public Class getConcreteProxyClass() {
        return InternalCDORevision.class;
    }

    public boolean isInstrumented() {
        return false;
    }

    private void setIdentifierTypeAsAnnotation(Property prop) {
        EAnnotation eAnnotation = this.getEClass().getEAnnotation("teneo.cdo");
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("teneo.cdo");
            eAnnotation.getDetails().put((Object)"id_type", (Object)prop.getType().getName());
            this.getEClass().getEAnnotations().add((Object)eAnnotation);
        } else if (!eAnnotation.getDetails().containsKey((Object)"id_type")) {
            eAnnotation.getDetails().put((Object)"id_type", (Object)prop.getType().getName());
        }
    }

    private class CDOEntityNameResolver
    implements EntityNameResolver {
        private CDOEntityNameResolver() {
        }

        public String resolveEntityName(Object object) {
            return CDORevisionTuplizer.this.getEntityName();
        }
    }
}

