/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.io.Serializable;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreAccessor;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionTuplizer;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.Instantiator;

public class CDORevisionInstantiator
implements Instantiator {
    private static final long serialVersionUID = 1L;
    private final EClass eClass;
    private final CDOClassifierRef classifierRef;

    public CDORevisionInstantiator(CDORevisionTuplizer tuplizer, PersistentClass mappingInfo) {
        this.eClass = tuplizer.getEClass();
        this.classifierRef = new CDOClassifierRef((EClassifier)this.eClass);
    }

    public Object instantiate() {
        return this.instantiate(null);
    }

    public Object instantiate(Serializable key) {
        HibernateStoreAccessor storeAccessor = HibernateThreadContext.getCurrentStoreAccessor();
        HibernateStore store = storeAccessor.getStore();
        CDOID id = HibernateUtil.getInstance().createCDOID(this.classifierRef, key);
        InternalCDORevision revision = store.createRevision(this.eClass, id);
        revision.setBranchPoint(storeAccessor.getStore().getMainBranchHead());
        return revision;
    }

    public boolean isInstance(Object object) {
        return object instanceof InternalCDORevision;
    }
}

