/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.lang.reflect.Method;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOPropertyHandler;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionTuplizer;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.property.Setter;

public class CDOPropertySetter
extends CDOPropertyHandler
implements Setter {
    private static final long serialVersionUID = 1L;
    private final boolean convertByteArray;

    public CDOPropertySetter(CDORevisionTuplizer tuplizer, String propertyName) {
        super(tuplizer, propertyName);
        EAttribute eAttribute;
        EStructuralFeature eFeature = this.getEStructuralFeature();
        this.convertByteArray = eFeature instanceof EAttribute ? (eAttribute = (EAttribute)eFeature).getEAttributeType().getInstanceClass() != null && byte[].class.isAssignableFrom(eAttribute.getEAttributeType().getInstanceClass()) : false;
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return null;
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        boolean hasChanged;
        Object newValue;
        InternalCDORevision revision = (InternalCDORevision)target;
        if (value instanceof Byte[] && this.convertByteArray) {
            Byte[] objectArray = (Byte[])value;
            byte[] newByteValue = new byte[objectArray.length];
            int i = 0;
            Byte[] byteArray = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byteArray[n2];
                newByteValue[i++] = b;
                ++n2;
            }
            newValue = newByteValue;
        } else {
            Object defaultValue;
            newValue = value instanceof Enumerator ? Integer.valueOf(((Enumerator)value).getValue()) : (value instanceof EEnumLiteral ? Integer.valueOf(((EEnumLiteral)value).getValue()) : (value == null ? ((defaultValue = this.getEStructuralFeature().getDefaultValue()) == null ? null : (this.getEStructuralFeature().isUnsettable() ? null : CDORevisionData.NIL)) : value));
        }
        Object currentValue = revision.getValue(this.getEStructuralFeature());
        boolean notChanged = currentValue == newValue || currentValue == null && newValue == CDORevisionData.NIL || this.isEenumDefaultValue(value) || currentValue != null && newValue != null && currentValue.equals(newValue);
        boolean bl = hasChanged = !notChanged;
        if (hasChanged) {
            revision.setValue(this.getEStructuralFeature(), newValue);
        }
    }

    private boolean isEenumDefaultValue(Object value) {
        if (this.getEStructuralFeature().getEType() instanceof EEnum) {
            Object defaultValue = this.getEStructuralFeature().getDefaultValue();
            return defaultValue == value;
        }
        return false;
    }
}

