/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOPropertyHandler;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionTuplizer;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;

public class CDOPropertyGetter
extends CDOPropertyHandler
implements Getter {
    private static final long serialVersionUID = 1L;
    private final boolean isEEnum;
    private final EEnum eEnum;

    public CDOPropertyGetter(CDORevisionTuplizer tuplizer, String propertyName) {
        super(tuplizer, propertyName);
        if (this.getEStructuralFeature() != null) {
            this.isEEnum = this.getEStructuralFeature().getEType() instanceof EEnum;
            this.eEnum = this.isEEnum ? (EEnum)this.getEStructuralFeature().getEType() : null;
        } else {
            this.isEEnum = false;
            this.eEnum = null;
        }
    }

    public Object get(Object target) throws HibernateException {
        InternalCDORevision revision = (InternalCDORevision)target;
        Object value = revision.getValue(this.getEStructuralFeature());
        if (value == CDORevisionData.NIL) {
            return null;
        }
        if (value == null) {
            if (this.getEStructuralFeature().getDefaultValue() == null) {
                return null;
            }
            if (this.getEStructuralFeature().isUnsettable()) {
                return null;
            }
            if (this.isEEnum) {
                value = this.getEStructuralFeature().getDefaultValue();
            } else {
                return null;
            }
        }
        if (this.isEEnum && value != null) {
            if (value instanceof Enumerator) {
                return value;
            }
            return this.eEnum.getEEnumLiteral(((Integer)value).intValue());
        }
        return value;
    }

    public Object getForInsert(Object target, Map mergeMap, SessionImplementor session) throws HibernateException {
        return this.get(target);
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return null;
    }

    public Member getMember() {
        return null;
    }

    public Class getReturnType() {
        return Object.class;
    }
}

