/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.net4j.util.HexUtil;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOLobUserType
implements UserType,
ParameterizedType {
    private static final String SEPARATOR = " - ";
    private static final int[] SQL_TYPES = new int[]{2005};

    public void setParameterValues(Properties arg0) {
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public boolean isMutable() {
        return false;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws SQLException {
        String value;
        block3: {
            try {
                value = (String)StandardBasicTypes.STRING.nullSafeGet(rs, names[0]);
                if (!rs.wasNull()) break block3;
                return null;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this.convertStringToLob(value);
    }

    public void nullSafeSet(PreparedStatement statement, Object value, int index) throws SQLException {
        try {
            CDOLob cdoLob = (CDOLob)value;
            if (value == null || cdoLob.getSize() == 0L) {
                statement.setNull(index, 12);
                return;
            }
            statement.setString(index, this.convertLobToString(cdoLob));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    public Object assemble(Serializable cachedValue, Object owner) {
        return cachedValue;
    }

    private String convertLobToString(CDOLob<?> lob) {
        return String.valueOf(HexUtil.bytesToHex((byte[])lob.getID())) + SEPARATOR + lob.getSize();
    }

    private Object convertStringToLob(String lobId) {
        int pos = lobId.indexOf(SEPARATOR);
        byte[] id = HexUtil.hexToBytes((String)lobId.substring(0, pos));
        long size = Long.parseLong(lobId.substring(pos + 1));
        return this.createLob(id, size);
    }

    protected abstract Object createLob(byte[] var1, long var2);

    public Object replace(Object original, Object target, Object owner) {
        return original;
    }

    public int hashCode(Object x) {
        return x.hashCode();
    }
}

