/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.usertype.UserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOIDUserType
implements UserType {
    private static final int[] SQL_TYPES = new int[]{12};

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Class<?> returnedClass() {
        return CDOID.class;
    }

    public boolean isMutable() {
        return false;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws SQLException {
        String value = (String)StandardBasicTypes.STRING.nullSafeGet(rs, names[0]);
        if (rs.wasNull()) {
            return null;
        }
        return HibernateUtil.getInstance().convertStringToCDOID(value);
    }

    public void nullSafeSet(PreparedStatement statement, Object value, int index) throws SQLException {
        String strValue;
        if (value == null || value instanceof CDOID && ((CDOID)value).isNull()) {
            statement.setNull(index, 12);
            return;
        }
        if (value instanceof CDOIDTemp) {
            InternalCDORevision revision = HibernateUtil.getInstance().getCDORevisionNullable((CDOID)value);
            if (revision != null) {
                value = HibernateUtil.getInstance().getCDOID(revision);
            }
        } else if (value instanceof CDORevision) {
            value = HibernateUtil.getInstance().getCDOIDHibernate((CDORevision)value);
        }
        if ((strValue = HibernateUtil.getInstance().convertCDOIDToString((CDOID)value)) == null) {
            statement.setNull(index, 12);
            return;
        }
        statement.setString(index, strValue);
    }

    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    public Object assemble(Serializable cachedValue, Object owner) {
        return cachedValue;
    }

    public Object replace(Object original, Object target, Object owner) {
        return original;
    }

    public int hashCode(Object x) {
        return x.hashCode();
    }
}

