/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.io.Serializable;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCommitContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOPropertySetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionTuplizer;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClassifier;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;

public class CDOIDPropertySetter
extends CDOPropertySetter {
    private static final long serialVersionUID = 1L;

    public CDOIDPropertySetter(CDORevisionTuplizer tuplizer, String propertyName) {
        super(tuplizer, propertyName);
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        InternalCDORevision revision = (InternalCDORevision)target;
        if (value == null) {
            if (this.getEStructuralFeature().isUnsettable()) {
                revision.unset(this.getEStructuralFeature());
            }
            return;
        }
        CDOID revisionID = HibernateUtil.getInstance().getCDOID(revision);
        if (revisionID == null || revisionID instanceof CDOIDTemp) {
            CDOID newCDOID = HibernateUtil.getInstance().createCDOID(new CDOClassifierRef((EClassifier)revision.getEClass()), value);
            revision.setID(newCDOID);
            if (HibernateThreadContext.isCommitContextSet()) {
                HibernateCommitContext commitContext = HibernateThreadContext.getCommitContext();
                commitContext.setNewID(revisionID, newCDOID);
                if (revisionID instanceof CDOIDTemp) {
                    commitContext.getCommitContext().addIDMapping(revisionID, newCDOID);
                }
            }
        } else {
            Serializable idValue = HibernateUtil.getInstance().getIdValue(revisionID);
            if (idValue == null) {
                throw new IllegalStateException("ID value is null for revision " + revision);
            }
            if (!idValue.equals(value)) {
                throw new IllegalStateException("Current id and new id are different " + value + "/" + idValue);
            }
        }
        if (!this.isVirtualProperty()) {
            super.set(target, value, factory);
        }
    }

    protected boolean isVirtualPropertyAllowed() {
        return true;
    }
}

