/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCommitContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOPropertyGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionTuplizer;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClassifier;
import org.hibernate.HibernateException;

public class CDOIDPropertyGetter
extends CDOPropertyGetter {
    private static final long serialVersionUID = 1L;

    public CDOIDPropertyGetter(CDORevisionTuplizer tuplizer, String propertyName) {
        super(tuplizer, propertyName);
    }

    public Object get(Object target) throws HibernateException {
        InternalCDORevision revision = (InternalCDORevision)target;
        if (!(HibernateUtil.getInstance().getCDOID(revision) instanceof CDOIDObject)) {
            if (!this.isVirtualProperty()) {
                Object value = super.get(target);
                if (value != null) {
                    this.setCDOID((CDORevision)revision, value);
                }
                return value;
            }
            return null;
        }
        if (this.isVirtualProperty()) {
            return HibernateUtil.getInstance().getIdValue(revision.getID());
        }
        Object id = super.get(target);
        this.setCDOID((CDORevision)revision, id);
        return id;
    }

    private void setCDOID(CDORevision target, Object value) {
        InternalCDORevision revision = (InternalCDORevision)target;
        CDOID id = HibernateUtil.getInstance().getCDOID(revision);
        if (id == null || id instanceof CDOIDTemp) {
            CDOID newCDOID = HibernateUtil.getInstance().createCDOID(new CDOClassifierRef((EClassifier)revision.getEClass()), value);
            revision.setID(newCDOID);
            if (HibernateThreadContext.isCommitContextSet()) {
                HibernateCommitContext commitContext = HibernateThreadContext.getCommitContext();
                commitContext.setNewID(id, newCDOID);
                if (id instanceof CDOIDTemp) {
                    commitContext.getCommitContext().addIDMapping(id, newCDOID);
                }
            }
        }
    }

    protected boolean isVirtualPropertyAllowed() {
        return true;
    }
}

