/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.hibernate.HibernateException;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOENumStringType
implements UserType,
ParameterizedType {
    private static final String EPACKAGE_META = "epackage";
    private static final String ECLASSIFIER_META = "eclassifier";
    private static final int[] SQL_TYPES = new int[]{12};
    protected EEnum eEnum;
    private String ePackageNsUri;
    private String eClassifierName;
    private final HashMap<String, Enumerator> localCache = new HashMap();

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null && y == null) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.getClass() != y.getClass()) {
            return false;
        }
        if (x instanceof Integer && y instanceof Integer) {
            return ((Integer)x).intValue() == ((Integer)y).intValue();
        }
        if (x instanceof String && y instanceof String) {
            return ((String)x).equals(y);
        }
        return ((Enumerator)x).getValue() == ((Enumerator)y).getValue();
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String literal = rs.getString(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        Enumerator enumValue = this.localCache.get(literal);
        if (enumValue != null) {
            return enumValue;
        }
        enumValue = this.getEEnum().getEEnumLiteralByLiteral(literal.trim());
        if (enumValue == null) {
            throw new IllegalStateException("The enum value " + literal + " is invalid for enumerator: " + this.getEEnum().getName());
        }
        this.localCache.put(literal, enumValue);
        return enumValue;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
        } else if (value instanceof Integer) {
            EEnumLiteral literal = this.getEEnum().getEEnumLiteral(((Integer)value).intValue());
            st.setString(index, literal.getLiteral());
        } else if (value instanceof String) {
            EEnumLiteral literal = this.getEEnum().getEEnumLiteral((String)value);
            st.setString(index, literal.getLiteral());
        } else {
            st.setString(index, ((Enumerator)value).getLiteral());
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class<?> returnedClass() {
        return this.getEEnum().getClass();
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    protected EEnum getEEnum() {
        if (this.eEnum == null) {
            CDOPackageRegistry packageRegistry = HibernateUtil.getInstance().getPackageRegistry();
            EPackage ePackage = packageRegistry.getEPackage(this.ePackageNsUri);
            if (ePackage == null) {
                throw new IllegalStateException("EPackage with nsuri " + this.ePackageNsUri + " not found");
            }
            EClassifier eClassifier = ePackage.getEClassifier(this.eClassifierName);
            if (eClassifier == null || !(eClassifier instanceof EEnum)) {
                throw new IllegalStateException("EPackage " + ePackage.getName() + " does not have an EEnum with name " + this.eClassifierName);
            }
            this.eEnum = (EEnum)eClassifier;
        }
        return this.eEnum;
    }

    public void setParameterValues(Properties parameters) {
        this.ePackageNsUri = parameters.getProperty(EPACKAGE_META);
        this.eClassifierName = parameters.getProperty(ECLASSIFIER_META);
    }
}

