/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.hibernate.IHibernateMappingProvider;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.FileHibernateMappingProvider;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCommitContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreAccessor;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOIDLong;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOIDString;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.hibernate.Session;
import org.hibernate.proxy.HibernateProxy;

public class HibernateUtil {
    private static final String EXT_POINT = "mappingProviderFactories";
    private static HibernateUtil instance = new HibernateUtil();
    private static final String SEPARATOR = "_;_";
    private static final String MAPPING_PROVIDER_FACTORY_TAG = "mappingProviderFactory";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String CLASS = "class";
    private DatatypeFactory dataTypeFactory;

    public static HibernateUtil getInstance() {
        return instance;
    }

    public static void setInstance(HibernateUtil instance) {
        HibernateUtil.instance = instance;
    }

    public HibernateUtil() {
        try {
            this.dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new IllegalStateException("Exception ", ex);
        }
    }

    public DatatypeFactory getDataTypeFactory() {
        return this.dataTypeFactory;
    }

    public void setDataTypeFactory(DatatypeFactory dataTypeFactory) {
        this.dataTypeFactory = dataTypeFactory;
    }

    public EClass getEClass(CDOClassifierRef classifierRef) {
        CDOPackageRegistry registry = this.getPackageRegistry();
        EPackage ePackage = registry.getEPackage(classifierRef.getPackageURI());
        if (ePackage == null) {
            throw new IllegalArgumentException("No EPackage found with nsuri " + classifierRef.getPackageURI());
        }
        EClass eClass = (EClass)ePackage.getEClassifier(classifierRef.getClassifierName());
        if (eClass == null) {
            throw new IllegalArgumentException("No EClass " + classifierRef.getClassifierName() + " in EPackage " + ePackage.getNsURI());
        }
        return eClass;
    }

    public CDOPackageRegistry getPackageRegistry() {
        HibernateStoreAccessor accessor = HibernateThreadContext.getCurrentStoreAccessor();
        return accessor.getStore().getRepository().getPackageRegistry();
    }

    public IHibernateStore createStore(IHibernateMappingProvider mappingProvider, Properties properties) {
        HibernateStore store = new HibernateStore(mappingProvider, properties);
        mappingProvider.setHibernateStore(store);
        return store;
    }

    public IHibernateMappingProvider.Factory createMappingProviderFactory(String type) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server.hibernate", EXT_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String typeAttr;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (MAPPING_PROVIDER_FACTORY_TAG.equals(element.getName()) && ObjectUtil.equals((Object)(typeAttr = element.getAttribute(TYPE_ATTRIBUTE)), (Object)type)) {
                try {
                    return (IHibernateMappingProvider.Factory)element.createExecutableExtension(CLASS);
                }
                catch (CoreException ex) {
                    throw WrappedException.wrap((Exception)((Object)ex));
                }
            }
            ++n2;
        }
        return null;
    }

    public IHibernateMappingProvider createFileMappingProvider(String location) {
        return new FileHibernateMappingProvider(location);
    }

    public Session getHibernateSession() {
        HibernateStoreAccessor accessor = HibernateThreadContext.getCurrentStoreAccessor();
        return accessor.getHibernateSession();
    }

    public Properties getPropertiesFromStore(IHibernateStore store) {
        Properties props = new Properties();
        Map storeProps = store.getRepository().getProperties();
        for (String key : storeProps.keySet()) {
            props.setProperty(key, (String)storeProps.get(key));
        }
        return props;
    }

    public CDOID getCDOID(Object o) {
        if (o instanceof HibernateProxy) {
            Serializable idValue = ((HibernateProxy)o).getHibernateLazyInitializer().getIdentifier();
            String entityName = ((HibernateProxy)o).getHibernateLazyInitializer().getEntityName();
            HibernateStoreAccessor accessor = HibernateThreadContext.getCurrentStoreAccessor();
            EClass eClass = accessor.getStore().getEClass(entityName);
            return HibernateUtil.getInstance().createCDOID(new CDOClassifierRef((EClassifier)eClass), idValue);
        }
        return ((CDORevision)o).getID();
    }

    public String getEntityName(Object o) {
        if (o instanceof HibernateProxy) {
            return ((HibernateProxy)o).getHibernateLazyInitializer().getEntityName();
        }
        EClass eClass = ((CDORevision)o).getEClass();
        HibernateStoreAccessor accessor = HibernateThreadContext.getCurrentStoreAccessor();
        return accessor.getStore().getEntityName(eClass);
    }

    @Deprecated
    public String getEntityName(CDORevision revision) {
        return HibernateThreadContext.getCurrentStoreAccessor().getStore().getEntityName(revision.getEClass());
    }

    public String convertCDOIDToString(CDOID id) {
        if (id == null || id.isNull() || id.isTemporary()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        CDOIDUtil.write((StringBuilder)sb, (CDOID)id);
        return sb.toString();
    }

    public CDOID convertStringToCDOID(String strID) {
        if (strID == null) {
            return null;
        }
        return CDOIDUtil.read((String)strID);
    }

    public CDOID getCDOIDHibernate(CDOID id) {
        if (this.isStoreCreatedID(id)) {
            return id;
        }
        InternalCDORevision revision = this.getCDORevision(id);
        if (this.isStoreCreatedID(revision.getID())) {
            return revision.getID();
        }
        return this.getCDOIDHibernate((CDORevision)revision);
    }

    public CDOID getCDOIDHibernate(CDORevision revision) {
        Session session = this.getHibernateSession();
        if (!this.isStoreCreatedID(revision.getID())) {
            session.saveOrUpdate((Object)revision);
        }
        this.checkIsSupportedID(revision.getID());
        return revision.getID();
    }

    public InternalCDORevision getCDORevision(Object target) {
        if (target instanceof CDOObject) {
            return (InternalCDORevision)CDOUtil.getCDOObject((EObject)((EObject)target)).cdoRevision();
        }
        return (InternalCDORevision)target;
    }

    public InternalCDORevision getCDORevision(CDOID id) {
        if (CDOIDUtil.isNull((CDOID)id)) {
            return null;
        }
        if (HibernateThreadContext.isCommitContextSet()) {
            CDOID newID;
            HibernateCommitContext commitContext = HibernateThreadContext.getCommitContext();
            InternalCDORevision revision = commitContext.getNewObject(id);
            if (revision != null) {
                return revision;
            }
            if (id instanceof CDOIDTemp && (newID = (CDOID)commitContext.getCommitContext().getIDMappings().get(id)) != null) {
                return this.getCDORevision(newID);
            }
        }
        this.checkIsSupportedID(id);
        String entityName = this.getEntityName(id);
        Serializable idValue = this.getIdValue(id);
        return (InternalCDORevision)this.getHibernateSession().get(entityName, idValue);
    }

    public InternalCDORevision getCDORevisionNullable(CDOID id) {
        if (CDOIDUtil.isNull((CDOID)id)) {
            return null;
        }
        if (HibernateThreadContext.isCommitContextSet()) {
            CDOID newID;
            HibernateCommitContext commitContext = HibernateThreadContext.getCommitContext();
            InternalCDORevision revision = commitContext.getDirtyObject(id);
            if (revision != null) {
                return revision;
            }
            revision = commitContext.getNewObject(id);
            if (revision != null) {
                return revision;
            }
            if (id instanceof CDOIDTemp && (newID = (CDOID)commitContext.getCommitContext().getIDMappings().get(id)) != null) {
                return this.getCDORevision(newID);
            }
        }
        if (!this.isStoreCreatedID(id)) {
            return null;
        }
        String entityName = this.getEntityName(id);
        Serializable idValue = this.getIdValue(id);
        return (InternalCDORevision)this.getHibernateSession().get(entityName, idValue);
    }

    public int convertStringToFeatureID(EObject contained, String value) {
        String[] values = value.split(SEPARATOR);
        String nsuri = values[0];
        EPackage eContainerPackage = this.getPackageRegistry().getEPackage(nsuri);
        String eContainerEClassName = values[1];
        EClass eContainingClass = (EClass)eContainerPackage.getEClassifier(eContainerEClassName);
        EPackage eFeaturePackage = this.getPackageRegistry().getEPackage(values[2]);
        String eClassifierName = values[3];
        EClassifier eClassifier = eFeaturePackage.getEClassifier(eClassifierName);
        EClass eFeatureClass = (EClass)eClassifier;
        String eFeatureName = values[4];
        EStructuralFeature eFeature = eFeatureClass.getEStructuralFeature(eFeatureName);
        return this.getContainerFeatureId(eContainingClass, contained, eFeature);
    }

    public int getContainerFeatureId(EClass containingEClass, EObject contained, EStructuralFeature eFeature) {
        if (eFeature instanceof EAttribute) {
            return -1 - containingEClass.getFeatureID(eFeature);
        }
        EReference eReference = (EReference)eFeature;
        if (eReference.getEOpposite() != null) {
            EReference containerEReference = eReference.getEOpposite();
            return contained.eClass().getFeatureID((EStructuralFeature)containerEReference);
        }
        return -1 - containingEClass.getFeatureID((EStructuralFeature)eReference);
    }

    public CDOID createCDOID(CDOClassifierRef classifierRef, Object idValue) {
        if (idValue instanceof String) {
            return CDOIDUtil.createStringWithClassifier((CDOClassifierRef)classifierRef, (String)((String)idValue));
        }
        if (idValue instanceof Long) {
            return CDOIDUtil.createLongWithClassifier((CDOClassifierRef)classifierRef, (long)((Long)idValue));
        }
        throw new IllegalArgumentException("The ID value type " + idValue.getClass() + " is not supported by this store. Method called with " + classifierRef);
    }

    public boolean isStoreCreatedID(CDOID id) {
        return id instanceof CDOClassifierRef.Provider || id instanceof CDOIDExternal;
    }

    public void checkIsSupportedID(CDOID id) {
        if (!this.isStoreCreatedID(id)) {
            throw new IllegalArgumentException("This CDOID type " + id + " is not supported by this store. " + id.getClass().getName());
        }
    }

    public Serializable getIdValue(CDOID id) {
        if (id instanceof AbstractCDOIDString) {
            return ((AbstractCDOIDString)id).getStringValue();
        }
        if (id instanceof AbstractCDOIDLong) {
            return Long.valueOf(((AbstractCDOIDLong)id).getLongValue());
        }
        throw new IllegalArgumentException("This CDOID type " + id + " is not supported by this store.");
    }

    public String getEntityName(CDOID id) {
        CDOClassifierRef classifierRef = CDOIDUtil.getClassifierRef((CDOID)id);
        if (classifierRef == null) {
            throw new IllegalArgumentException("This CDOID type of " + id + " is not supported by this store.");
        }
        HibernateStoreAccessor accessor = HibernateThreadContext.getCurrentStoreAccessor();
        return accessor.getStore().getEntityName(classifierRef);
    }

    public XMLGregorianCalendar getXMLGregorianCalendarDate(Date date, boolean dateTime) {
        XMLGregorianCalendar gregCalendar = this.dataTypeFactory.newXMLGregorianCalendar();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        gregCalendar.setYear(calendar.get(1));
        gregCalendar.setMonth(calendar.get(2) + 1);
        gregCalendar.setDay(calendar.get(5));
        if (dateTime) {
            gregCalendar.setHour(calendar.get(11));
            gregCalendar.setMinute(calendar.get(12));
            gregCalendar.setSecond(calendar.get(13));
            gregCalendar.setMillisecond(calendar.get(14));
        }
        return gregCalendar;
    }
}

