/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCommitContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreAccessor;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class HibernateThreadContext {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateThreadContext.class);
    private static ThreadLocal<HibernateCommitContext> commitContext = new ThreadLocal();

    public static HibernateStoreAccessor getCurrentStoreAccessor() {
        return (HibernateStoreAccessor)StoreThreadLocal.getAccessor();
    }

    public static HibernateCommitContext getCommitContext() {
        HibernateCommitContext result = commitContext.get();
        if (result == null) {
            throw new IllegalStateException("CommitContext not set");
        }
        return result;
    }

    public static boolean isCommitContextSet() {
        return commitContext.get() != null;
    }

    public static void setCommitContext(InternalCommitContext newCommitContext) {
        if (TRACER.isEnabled()) {
            if (newCommitContext == null) {
                TRACER.trace("Clearing commitcontext in threadlocal");
            } else {
                TRACER.trace("Setting commitcontext in threadlocal");
            }
        }
        if (newCommitContext == null) {
            commitContext.set(null);
        } else {
            HibernateCommitContext hcc = new HibernateCommitContext();
            hcc.setCommitContext(newCommitContext);
            commitContext.set(hcc);
        }
    }
}

