/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreFactory;
import org.eclipse.emf.cdo.server.hibernate.IHibernateMappingProvider;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateStoreFactory
implements IStoreFactory {
    private static final String PROPERTY_TAG = "property";
    private static final String MAPPINGPROVIDER_TAG = "mappingProvider";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String TYPE_ATTRIBUTE = "type";

    public String getStoreType() {
        return "hibernate";
    }

    public IStore createStore(String repositoryName, Map<String, String> repositoryProperties, Element storeConfig) {
        IHibernateMappingProvider mappingProvider = this.getMappingProvider(storeConfig);
        Properties properties = new Properties();
        NodeList propertyNodes = storeConfig.getElementsByTagName(PROPERTY_TAG);
        int i = 0;
        while (i < propertyNodes.getLength()) {
            Element propertyElement = (Element)propertyNodes.item(i);
            properties.setProperty(propertyElement.getAttribute(NAME_ATTRIBUTE), propertyElement.getAttribute(VALUE_ATTRIBUTE));
            ++i;
        }
        return HibernateUtil.getInstance().createStore(mappingProvider, properties);
    }

    private IHibernateMappingProvider getMappingProvider(Element storeConfig) {
        NodeList mappingProviderConfigs = storeConfig.getElementsByTagName(MAPPINGPROVIDER_TAG);
        if (mappingProviderConfigs.getLength() != 1) {
            throw new IllegalStateException("Exactly one mapping provider must be configured for Hibernate store");
        }
        Element mappingProviderConfig = (Element)mappingProviderConfigs.item(0);
        String mappingProviderType = mappingProviderConfig.getAttribute(TYPE_ATTRIBUTE);
        IHibernateMappingProvider.Factory factory = HibernateUtil.getInstance().createMappingProviderFactory(mappingProviderType);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown mapping provider type: " + mappingProviderType);
        }
        IHibernateMappingProvider mappingProvider = factory.create(mappingProviderConfig);
        if (mappingProvider == null) {
            throw new IllegalArgumentException("No mapping provider created: " + mappingProviderType);
        }
        return mappingProvider;
    }
}

