/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStoreAccessor;
import org.eclipse.emf.cdo.server.internal.hibernate.ContainerInfoConverter;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateQueryHandler;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreChunkReader;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreLob;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.PersistableListHolder;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.WrappedHibernateList;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateStoreAccessor
extends StoreAccessor
implements IHibernateStoreAccessor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateStoreAccessor.class);
    private static final String NAME_EFEATURE_NAME = "name";
    private Session hibernateSession;
    private boolean errorOccured;

    public void addToRevisionCache(Object object) {
        if (object instanceof CDORevision) {
            this.getStore().getRepository().getRevisionManager().addRevision((CDORevision)object);
        } else if (object instanceof Object[]) {
            Object[] objects;
            Object[] objectArray = objects = (Object[])object;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.addToRevisionCache(o);
                ++n2;
            }
        }
    }

    public HibernateStoreAccessor(HibernateStore store, ISession session) {
        super((Store)store, session);
        if (TRACER.isEnabled()) {
            TRACER.trace("Created " + this.getClass().getName() + " for repository " + store.getRepository().getName());
        }
    }

    public HibernateStoreAccessor(HibernateStore store, ITransaction transaction) {
        super((Store)store, transaction);
        if (TRACER.isEnabled()) {
            TRACER.trace("Created " + this.getClass().getName() + " for repository " + store.getRepository().getName());
        }
    }

    public void resetHibernateSession() {
        this.endHibernateSession();
        this.beginHibernateSession();
    }

    @Override
    public HibernateStore getStore() {
        return (HibernateStore)super.getStore();
    }

    public void beginHibernateSession() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Creating hibernate session and transaction");
        }
        assert (this.hibernateSession == null);
        SessionFactory sessionFactory = this.getStore().getHibernateSessionFactory();
        this.hibernateSession = sessionFactory.openSession();
        this.hibernateSession.beginTransaction();
    }

    public void commitRollbackHibernateSession() {
        this.endHibernateSession();
    }

    public void endHibernateSession() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Closing hibernate session");
        }
        if (this.hibernateSession != null && this.hibernateSession.isOpen()) {
            try {
                if (this.hibernateSession.getTransaction().isActive()) {
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Commiting hibernate session");
                    }
                    if (this.isErrorOccured()) {
                        if (TRACER.isEnabled()) {
                            TRACER.trace("Rolling back hb transaction");
                        }
                        this.hibernateSession.getTransaction().rollback();
                    } else {
                        if (TRACER.isEnabled()) {
                            TRACER.trace("Committing hb transaction");
                        }
                        this.hibernateSession.getTransaction().commit();
                    }
                }
            }
            finally {
                this.hibernateSession.close();
            }
        }
        this.hibernateSession = null;
    }

    @Override
    public Session getHibernateSession() {
        if (this.hibernateSession == null) {
            this.beginHibernateSession();
        }
        return this.hibernateSession;
    }

    public Session getNewHibernateSession() {
        if (this.hibernateSession != null) {
            this.endHibernateSession();
        }
        if (this.hibernateSession != null) {
            throw new IllegalStateException("Hibernate session should be null");
        }
        this.beginHibernateSession();
        return this.hibernateSession;
    }

    public boolean isErrorOccured() {
        return this.errorOccured;
    }

    public void setErrorOccured(boolean errorOccured) {
        this.errorOccured = errorOccured;
    }

    @Override
    public HibernateStoreChunkReader createChunkReader(InternalCDORevision revision, EStructuralFeature feature) {
        return new HibernateStoreChunkReader(this, (CDORevision)revision, feature);
    }

    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        return this.getStore().getPackageHandler().getPackageUnits();
    }

    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        return this.getStore().getPackageHandler().loadPackageUnit(packageUnit);
    }

    public InternalCDORevision readRevision(CDOID id, CDOBranchPoint branchPoint, int listChunk, CDORevisionCacheAdder cache) {
        if (!HibernateUtil.getInstance().isStoreCreatedID(id)) {
            return null;
        }
        InternalCDORevision revision = HibernateUtil.getInstance().getCDORevision(id);
        if (revision == null) {
            CDOClassifierRef classifierRef = CDOIDUtil.getClassifierRef((CDOID)id);
            if (classifierRef == null) {
                throw new IllegalArgumentException("This CDOID type of " + id + " is not supported by this store.");
            }
            EClass eClass = HibernateUtil.getInstance().getEClass(classifierRef);
            return new DetachedCDORevision(eClass, id, branchPoint.getBranch(), 0, 0L);
        }
        revision.setBranchPoint(this.getStore().getMainBranchHead());
        return revision;
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        throw new UnsupportedOperationException();
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        throw new UnsupportedOperationException();
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        throw new UnsupportedOperationException();
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        throw new UnsupportedOperationException();
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
    }

    public Set<CDOID> readChangeSet(OMMonitor monitor, CDOChangeSetSegment ... segments) {
        throw new UnsupportedOperationException();
    }

    public void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        if (eClass != null) {
            this.handleRevisionsByEClass(eClass, handler);
        } else {
            for (EPackage ePackage : this.getStore().getPackageHandler().getEPackages()) {
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    if (!(eClassifier instanceof EClass)) continue;
                    EClass eClazz = (EClass)eClassifier;
                    try {
                        this.getStore().getEntityName(eClazz);
                    }
                    catch (IllegalArgumentException ex) {
                        continue;
                    }
                    this.handleRevisionsByEClass(eClazz, handler);
                }
            }
        }
    }

    private void handleRevisionsByEClass(EClass eClass, CDORevisionHandler handler) {
        Session session = this.getHibernateSession();
        Query query = session.createQuery("select e from " + this.getStore().getEntityName(eClass) + " e");
        for (Object o : query.list()) {
            handler.handleRevision((CDORevision)o);
        }
        session.clear();
    }

    public InternalCDORevision readRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int listChunk, CDORevisionCacheAdder cache) {
        InternalCDORevision revision = this.readRevision(id, branchVersion.getBranch().getPoint(System.currentTimeMillis()), listChunk, cache);
        if (revision != null) {
            revision.freeze();
        }
        return revision;
    }

    public void queryResources(IStoreAccessor.QueryResourcesContext context) {
        CDOID folderID = this.getHibernateID(context.getFolderID());
        String name = context.getName();
        boolean exactMatch = context.exactMatch();
        Session session = this.getHibernateSession();
        Criteria criteria = session.createCriteria(EresourcePackage.eINSTANCE.getCDOResourceNode().getName());
        if (folderID == null) {
            criteria.add(Restrictions.isNull((String)"containerID"));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)"containerID", (Object)folderID));
        }
        List result = criteria.list();
        for (Object o : result) {
            boolean match;
            CDORevision revision = (CDORevision)o;
            EStructuralFeature feature = revision.getEClass().getEStructuralFeature(NAME_EFEATURE_NAME);
            if (feature == null) continue;
            Object value = revision.data().get(feature, 0);
            if (value == CDORevisionData.NIL) {
                value = null;
            }
            String revisionName = (String)value;
            boolean bl = match = exactMatch || revisionName == null || name == null ? ObjectUtil.equals((Object)revisionName, (Object)name) : revisionName.startsWith(name);
            if (match && !context.addResource(HibernateUtil.getInstance().getCDOID(revision))) break;
        }
    }

    public void queryXRefs(IStoreAccessor.QueryXRefsContext context) {
        Session session = this.getHibernateSession();
        for (CDOID targetCdoId : context.getTargetObjects().keySet()) {
            InternalCDORevision revision = HibernateUtil.getInstance().getCDORevision(targetCdoId);
            EClass targetEClass = (EClass)context.getTargetObjects().get(targetCdoId);
            String targetEntityName = this.getStore().getEntityName(targetEClass);
            Map sourceCandidates = context.getSourceCandidates();
            for (EClass sourceEClass : sourceCandidates.keySet()) {
                String sourceEntityName = this.getStore().getEntityName(sourceEClass);
                for (EReference eref : (List)sourceCandidates.get(sourceEClass)) {
                    String hql = eref.isMany() ? "select ref from " + sourceEntityName + " as ref, " + targetEntityName + " as refTo where refTo = :to and refTo in elements(ref." + eref.getName() + ")" : "select ref from " + sourceEntityName + " as ref where :to = ref." + eref.getName();
                    Query qry = session.createQuery(hql);
                    qry.setEntity("to", (Object)revision);
                    ScrollableResults result = qry.scroll(ScrollMode.FORWARD_ONLY);
                    while (result.next()) {
                        boolean more;
                        InternalCDORevision sourceRevision = (InternalCDORevision)result.get()[0];
                        int sourceIndex = 0;
                        if (eref.isMany()) {
                            WrappedHibernateList cdoList = (WrappedHibernateList)sourceRevision.getList((EStructuralFeature)eref);
                            sourceIndex = cdoList.getDelegate().indexOf(revision);
                        }
                        if (more = context.addXRef(targetCdoId, sourceRevision.getID(), eref, sourceIndex)) continue;
                        return;
                    }
                }
            }
        }
    }

    private CDOID getHibernateID(CDOID id) {
        if (!CDOIDUtil.isNull((CDOID)id)) {
            if (HibernateUtil.getInstance().isStoreCreatedID(id)) {
                return id;
            }
            Long idValue = CDOIDUtil.getLong((CDOID)id);
            return CDOIDUtil.createLongWithClassifier((CDOClassifierRef)new CDOClassifierRef((EClassifier)EresourcePackage.eINSTANCE.getCDOResourceNode()), (long)idValue);
        }
        return null;
    }

    public IQueryHandler getQueryHandler(CDOQueryInfo info) {
        String queryLanguage = info.getQueryLanguage();
        if (StringUtil.equalsUpperOrLowerCase((String)queryLanguage, (String)"hql")) {
            HibernateQueryHandler queryHandler = new HibernateQueryHandler();
            queryHandler.setHibernateStoreAccessor(this);
            return queryHandler;
        }
        return null;
    }

    protected void doCommit(OMMonitor monitor) {
        this.commitRollbackHibernateSession();
        HibernateThreadContext.setCommitContext(null);
    }

    public void doWrite(InternalCommitContext context, OMMonitor monitor) {
        HibernateThreadContext.setCommitContext(context);
        if (context.getNewPackageUnits().length > 0) {
            this.writePackageUnits(context.getNewPackageUnits(), monitor);
        }
        try {
            InternalCDORevision revision;
            Session session = this.getNewHibernateSession();
            session.setFlushMode(FlushMode.MANUAL);
            ArrayList<InternalCDORevision> repairContainerIDs = new ArrayList<InternalCDORevision>();
            ArrayList<InternalCDORevision> repairResourceIDs = new ArrayList<InternalCDORevision>();
            InternalCDORevision[] internalCDORevisionArray = context.getNewObjects();
            int n = internalCDORevisionArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOID resourceID;
                revision = internalCDORevisionArray[n2];
                CDOID containerID = (CDOID)revision.getContainerID();
                if (containerID instanceof CDOIDTemp && !containerID.isNull()) {
                    repairContainerIDs.add(revision);
                }
                if ((resourceID = revision.getResourceID()) instanceof CDOIDTemp && !resourceID.isNull()) {
                    repairResourceIDs.add(revision);
                }
                String entityName = this.getStore().getEntityName(revision.getEClass());
                session.saveOrUpdate(entityName, (Object)revision);
                ++n2;
            }
            session.flush();
            internalCDORevisionArray = context.getDirtyObjects();
            n = internalCDORevisionArray.length;
            n2 = 0;
            while (n2 < n) {
                revision = internalCDORevisionArray[n2];
                String entityName = HibernateUtil.getInstance().getEntityName(revision.getID());
                session.merge(entityName, (Object)revision);
                if (TRACER.isEnabled()) {
                    TRACER.trace("Updated Object " + revision.getEClass().getName() + " id: " + revision.getID());
                }
                ++n2;
            }
            session.flush();
            internalCDORevisionArray = context.getDetachedObjects();
            n = internalCDORevisionArray.length;
            n2 = 0;
            while (n2 < n) {
                InternalCDORevision id = internalCDORevisionArray[n2];
                try {
                    InternalCDORevision revision2 = HibernateUtil.getInstance().getCDORevision((CDOID)id);
                    if (revision2 != null) {
                        session.delete((Object)revision2);
                    }
                }
                catch (ObjectNotFoundException revision2) {
                    // empty catch block
                }
                ++n2;
            }
            session.flush();
            this.repairContainerIDs(repairContainerIDs, session);
            this.repairResourceIDs(repairResourceIDs, session);
            session.flush();
            ExtendedDataInputStream in = context.getLobs();
            if (in != null) {
                try {
                    int count = in.readInt();
                    int i = 0;
                    while (i < count) {
                        byte[] id = in.readByteArray();
                        long size = in.readLong();
                        if (size > 0L) {
                            this.writeBlob(id, size, (InputStream)in);
                        } else {
                            this.writeClob(id, -size, new InputStreamReader((InputStream)in));
                        }
                        ++i;
                    }
                }
                catch (IOException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
            session.flush();
        }
        catch (Exception e) {
            OM.LOG.error((Throwable)e);
            throw WrappedException.wrap((Exception)e);
        }
        context.applyIDMappings(monitor);
    }

    private void repairContainerIDs(List<InternalCDORevision> repairContainerIDs, Session session) {
        for (InternalCDORevision revision : repairContainerIDs) {
            InternalCDORevision container = HibernateUtil.getInstance().getCDORevision((CDOID)revision.getContainerID());
            String entityName = this.getStore().getEntityName(revision.getEClass());
            CDOID id = revision.getID();
            String hqlUpdate = "update " + entityName + " set " + "containerID" + " = :containerInfo where " + this.getStore().getIdentifierPropertyName(entityName) + " = :id";
            Query qry = session.createQuery(hqlUpdate);
            qry.setParameter("containerInfo", (Object)ContainerInfoConverter.getInstance().convertContainerRelationToString(revision, container.getID()));
            qry.setParameter("id", (Object)HibernateUtil.getInstance().getIdValue(id));
            if (qry.executeUpdate() == 1) continue;
            throw new IllegalStateException("Not able to update container columns of " + entityName + " with id " + id);
        }
    }

    private void repairResourceIDs(List<InternalCDORevision> repairResourceIDs, Session session) {
        for (InternalCDORevision revision : repairResourceIDs) {
            InternalCDORevision resource = HibernateUtil.getInstance().getCDORevision(revision.getResourceID());
            String entityName = this.getStore().getEntityName(revision.getEClass());
            CDOID id = revision.getID();
            String hqlUpdate = "update " + entityName + " set " + "resourceID" + " = :resourceInfo where " + this.getStore().getIdentifierPropertyName(entityName) + " = :id";
            Query qry = session.createQuery(hqlUpdate);
            qry.setParameter("resourceInfo", (Object)resource.getID());
            qry.setParameter("id", (Object)HibernateUtil.getInstance().getIdValue(id));
            if (qry.executeUpdate() == 1) continue;
            throw new IllegalStateException("Not able to update resource ids of " + entityName + " with id " + id);
        }
    }

    protected void detachObjects(CDOID[] detachedObjects, CDOBranch branch, long timeStamp, OMMonitor monitor) {
    }

    protected void doRollback(IStoreAccessor.CommitContext context) {
        this.setErrorOccured(true);
        this.endHibernateSession();
        HibernateThreadContext.setCommitContext(null);
    }

    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        if (packageUnits != null && packageUnits.length != 0) {
            this.getStore().getPackageHandler().writePackageUnits(packageUnits);
        }
    }

    protected void writeCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, OMMonitor monitor) {
    }

    protected void writeRevisions(InternalCDORevision[] revisions, CDOBranch branch, OMMonitor monitor) {
    }

    public void addIDMappings(InternalCommitContext commitContext, OMMonitor monitor) {
    }

    public CDOID getNextCDOID(CDORevision revision) {
        throw new UnsupportedOperationException();
    }

    protected void writeRevisionDeltas(InternalCDORevisionDelta[] revisionDeltas, CDOBranch branch, long created, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public void queryLobs(List<byte[]> ids) {
        Iterator<byte[]> it = ids.iterator();
        while (it.hasNext()) {
            byte[] id = it.next();
            HibernateStoreLob lob = this.getCreateHibernateStoreLob(id);
            if (!lob.isNew()) continue;
            it.remove();
        }
    }

    public void handleLobs(long fromTime, long toTime, CDOLobHandler handler) throws IOException {
        Session session = this.getHibernateSession();
        Query qry = session.createQuery("select c from " + HibernateStoreLob.class.getName() + " as c");
        try {
            for (Object o : qry.list()) {
                Closeable in;
                HibernateStoreLob lob = (HibernateStoreLob)o;
                if (lob.getBlob() != null) {
                    OutputStream out = handler.handleBlob(HexUtil.hexToBytes((String)lob.getId()), (long)lob.getSize());
                    if (out == null) continue;
                    in = lob.getBlob().getBinaryStream();
                    try {
                        IOUtil.copyBinary((InputStream)in, (OutputStream)out, (long)lob.getSize());
                        continue;
                    }
                    finally {
                        IOUtil.close((Closeable)out);
                    }
                }
                Clob clob = lob.getClob();
                in = clob.getCharacterStream();
                Writer out = handler.handleClob(HexUtil.hexToBytes((String)lob.getId()), (long)lob.getSize());
                if (out == null) continue;
                try {
                    IOUtil.copyCharacter((Reader)in, (Writer)out, (long)lob.getSize());
                }
                finally {
                    IOUtil.close((Closeable)out);
                }
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void loadLob(byte[] id, OutputStream out) throws IOException {
        HibernateStoreLob lob = this.getCreateHibernateStoreLob(id);
        if (lob.isNew()) {
            throw new IllegalStateException("Lob with id " + HexUtil.bytesToHex((byte[])id) + " does not exist");
        }
        long size = lob.getSize();
        try {
            if (lob.getBlob() != null) {
                InputStream in = lob.getBlob().getBinaryStream();
                IOUtil.copyBinary((InputStream)in, (OutputStream)out, (long)size);
            } else {
                Clob clob = lob.getClob();
                Reader in = clob.getCharacterStream();
                IOUtil.copyCharacter((Reader)in, (Writer)new OutputStreamWriter(out), (long)size);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void writeBlob(byte[] id, long size, InputStream inputStream) throws IOException {
        HibernateStoreLob lob = this.getCreateHibernateStoreLob(id);
        if (!(inputStream != null && size != 0L || lob.isNew())) {
            this.getHibernateSession().delete((Object)lob);
        } else {
            lob.setBlob(Hibernate.createBlob((InputStream)inputStream, (int)((int)size)));
            lob.setSize((int)size);
            lob.setClob(null);
            this.getHibernateSession().saveOrUpdate((Object)lob);
        }
    }

    protected void writeClob(byte[] id, long size, Reader reader) throws IOException {
        HibernateStoreLob lob = this.getCreateHibernateStoreLob(id);
        if (!(reader != null && size != 0L || lob.isNew())) {
            this.getHibernateSession().delete((Object)lob);
        } else {
            lob.setClob(Hibernate.createClob((Reader)reader, (int)((int)size)));
            lob.setSize((int)size);
            lob.setBlob(null);
            this.getHibernateSession().saveOrUpdate((Object)lob);
        }
    }

    private HibernateStoreLob getCreateHibernateStoreLob(byte[] idBytes) {
        String id = HexUtil.bytesToHex((byte[])idBytes);
        Session session = this.getHibernateSession();
        HibernateStoreLob lob = (HibernateStoreLob)session.get(HibernateStoreLob.class, (Serializable)((Object)id));
        if (lob == null) {
            lob = new HibernateStoreLob();
            lob.setId(id);
        }
        return lob;
    }

    protected void doDeactivate() throws Exception {
        if (TRACER.isEnabled()) {
            TRACER.trace("Committing/rollback and closing hibernate session");
        }
        try {
            this.endHibernateSession();
        }
        finally {
            this.clearThreadState();
        }
    }

    protected void doPassivate() throws Exception {
        this.clearThreadState();
    }

    private void clearThreadState() {
        PersistableListHolder.getInstance().clearListMapping();
        HibernateThreadContext.setCommitContext(null);
    }

    protected void doActivate() throws Exception {
    }

    protected void doUnpassivate() throws Exception {
    }
}

