/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.Closeable;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.hibernate.IHibernateMappingProvider;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernatePackageHandler;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreAccessor;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.SystemInformation;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOInterceptor;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOMergeEventListener;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.MergeEventListener;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.type.StandardBasicTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateStore
extends Store
implements IHibernateStore {
    public static final String TYPE = "hibernate";
    public static final String ID_TYPE_EANNOTATION_SOURCE = "teneo.cdo";
    public static final String ID_TYPE_EANNOTATION_KEY = "id_type";
    public static final Set<CDOID.ObjectType> OBJECT_ID_TYPES = new HashSet<CDOID.ObjectType>(Arrays.asList(CDOID.ObjectType.STRING_WITH_CLASSIFIER, CDOID.ObjectType.LONG_WITH_CLASSIFIER));
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateStore.class);
    private static final String RESOURCE_HBM_PATH = "mappings/resource.hbm.xml";
    private static final String HBM2DLL_UPDATE = "update";
    private static final String HBM2DLL_CREATE = "create";
    private static ThreadLocal<HibernateStore> currentHibernateStore = new ThreadLocal();
    private Configuration hibernateConfiguration;
    private SessionFactory hibernateSessionFactory;
    private HibernatePackageHandler packageHandler;
    private IHibernateMappingProvider mappingProvider;
    private boolean doDropSchema;
    private SystemInformation systemInformation;
    private Map<String, EClass> entityNameToEClass;
    private Map<String, String> eClassToEntityName;
    private Map<String, String> identifierPropertyNameByEntity;
    private Properties properties;
    private CDOBranchPoint mainBranchHead;
    private String mappingXml = null;

    public HibernateStore(IHibernateMappingProvider mappingProvider) {
        this(mappingProvider, null);
    }

    public HibernateStore(IHibernateMappingProvider mappingProvider, Properties properties) {
        super(TYPE, OBJECT_ID_TYPES, HibernateStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.REVISION}), HibernateStore.set((Object[])new IStore.RevisionTemporality[]{IStore.RevisionTemporality.NONE}), HibernateStore.set((Object[])new IStore.RevisionParallelism[]{IStore.RevisionParallelism.NONE}));
        this.mappingProvider = mappingProvider;
        this.packageHandler = new HibernatePackageHandler(this);
        this.properties = properties;
        if (TRACER.isEnabled() && mappingProvider != null) {
            TRACER.trace("HibernateStore with mappingProvider " + mappingProvider.getClass().getName());
        }
    }

    public CDOBranchPoint getMainBranchHead() {
        if (this.mainBranchHead == null) {
            this.mainBranchHead = this.getRepository().getBranchManager().getMainBranch().getHead();
        }
        return this.mainBranchHead;
    }

    public String getIdentifierPropertyName(String entityName) {
        return this.identifierPropertyNameByEntity.get(entityName);
    }

    public void addEntityNameEClassMapping(String entityName, EClass eClass) {
        if (this.entityNameToEClass.get(entityName) != null) {
            EClass currentEClass = this.entityNameToEClass.get(entityName);
            throw new IllegalArgumentException("There is a entity name collision for EClasses " + currentEClass.getEPackage().getName() + "." + currentEClass.getName() + "/" + eClass.getEPackage().getName() + "." + eClass.getName());
        }
        this.entityNameToEClass.put(entityName, eClass);
        this.eClassToEntityName.put(String.valueOf(eClass.getEPackage().getNsURI()) + "#" + eClass.getName(), entityName);
    }

    public Properties getProperties() {
        if (this.properties == null || this.properties.isEmpty()) {
            this.properties = new Properties();
            Map storeProps = this.getRepository().getProperties();
            for (String key : storeProps.keySet()) {
                this.properties.setProperty(key, (String)storeProps.get(key));
            }
        }
        return this.properties;
    }

    public String getEntityName(EClass eClass) {
        if (eClass == null) {
            throw new IllegalArgumentException("EClass argument is null");
        }
        String entityName = this.eClassToEntityName.get(String.valueOf(eClass.getEPackage().getNsURI()) + "#" + eClass.getName());
        if (entityName == null) {
            throw new IllegalArgumentException("EClass " + eClass.getName() + " does not have an entity name, has it been mapped to Hibernate?");
        }
        return entityName;
    }

    public String getEntityName(CDOClassifierRef classifierRef) {
        if (classifierRef == null) {
            throw new IllegalArgumentException("classifierRef argument is null");
        }
        String entityName = this.eClassToEntityName.get(String.valueOf(classifierRef.getPackageURI()) + "#" + classifierRef.getClassifierName());
        if (entityName == null) {
            throw new IllegalArgumentException("EClass " + classifierRef + " does not have an entity name, has it been mapped to Hibernate?");
        }
        return entityName;
    }

    public EClass getEClass(String entityName) {
        if (entityName == null) {
            throw new IllegalArgumentException("entityname argument is null");
        }
        EClass eClass = this.entityNameToEClass.get(entityName);
        if (eClass == null) {
            throw new IllegalArgumentException("entityname " + entityName + " does not map to an EClass, has it been mapped to Hibernate?");
        }
        return eClass;
    }

    @Override
    public Configuration getHibernateConfiguration() {
        return this.hibernateConfiguration;
    }

    @Override
    public synchronized SessionFactory getHibernateSessionFactory() {
        if (this.hibernateSessionFactory == null) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Initializing SessionFactory for HibernateStore");
            }
            currentHibernateStore.set(this);
            this.entityNameToEClass = new HashMap<String, EClass>();
            this.eClassToEntityName = new HashMap<String, String>();
            this.identifierPropertyNameByEntity = new HashMap<String, String>();
            try {
                this.initConfiguration();
                this.hibernateSessionFactory = this.hibernateConfiguration.buildSessionFactory();
                Iterator iterator = this.hibernateConfiguration.getClassMappings();
                while (iterator.hasNext()) {
                    PersistentClass pc = (PersistentClass)iterator.next();
                    if (pc.getIdentifierProperty() == null) continue;
                    this.identifierPropertyNameByEntity.put(pc.getEntityName(), pc.getIdentifierProperty().getName());
                }
            }
            finally {
                currentHibernateStore.set(null);
            }
        }
        return this.hibernateSessionFactory;
    }

    public Connection getConnection() {
        String connectionURL = this.getProperties().getProperty("hibernate.connection.url");
        String userName = this.getProperties().getProperty("hibernate.connection.username");
        String passWord = this.getProperties().getProperty("hibernate.connection.password");
        try {
            Connection connection = DriverManager.getConnection(connectionURL, userName, passWord);
            if (connection == null) {
                throw new DBException("No connection from driver manager: " + connectionURL);
            }
            String autoCommit = this.getProperties().getProperty("hibernate.connection.autocommit");
            if (autoCommit != null) {
                connection.setAutoCommit(Boolean.valueOf(autoCommit));
            }
            return connection;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public boolean isLocal(CDOID id) {
        return false;
    }

    public CDOID createObjectID(String val) {
        int index = val.lastIndexOf("#");
        if (index == -1) {
            throw new IllegalArgumentException("Id string " + val + " is not a valid id");
        }
        String uriPart = val.substring(0, index);
        String idPart = val.substring(index + 1);
        CDOClassifierRef classifierRef = new CDOClassifierRef(uriPart);
        String entityName = this.getEntityName(classifierRef);
        EClass eClass = this.getEClass(entityName);
        EAnnotation typeEAnnotation = eClass.getEAnnotation(ID_TYPE_EANNOTATION_SOURCE);
        if (typeEAnnotation == null) {
            throw new IllegalStateException("EClass " + eClass + " does not have a type annotation");
        }
        String idTypeStr = (String)typeEAnnotation.getDetails().get((Object)ID_TYPE_EANNOTATION_KEY);
        if (StandardBasicTypes.STRING.getName().equals(idTypeStr)) {
            return HibernateUtil.getInstance().createCDOID(classifierRef, idPart);
        }
        if (StandardBasicTypes.LONG.getName().equals(idTypeStr)) {
            return HibernateUtil.getInstance().createCDOID(classifierRef, new Long(idPart));
        }
        throw new IllegalArgumentException("ID type " + idTypeStr + " not supported ");
    }

    public HibernateStoreAccessor createReader(ISession session) {
        return new HibernateStoreAccessor(this, session);
    }

    public HibernateStoreAccessor createWriter(ITransaction transaction) {
        return new HibernateStoreAccessor(this, transaction);
    }

    public Map<String, String> getPersistentProperties(Set<String> names) {
        Map<String, String> result = this.packageHandler.getSystemProperties();
        if (names == null || names.isEmpty()) {
            return result;
        }
        HashMap<String, String> filteredResult = new HashMap<String, String>();
        for (String name : names) {
            if (!result.containsKey(name)) continue;
            filteredResult.put(name, result.get(name));
        }
        return filteredResult;
    }

    public void setPersistentProperties(Map<String, String> properties) {
        this.packageHandler.setSystemProperties(properties);
    }

    public void removePersistentProperties(Set<String> names) {
        Map<String, String> props = this.getPersistentProperties(null);
        for (String name : names) {
            props.remove(name);
        }
        this.setPersistentProperties(props);
    }

    public synchronized int getNextPackageID() {
        return this.packageHandler.getNextPackageID();
    }

    public synchronized int getNextClassID() {
        return this.packageHandler.getNextClassID();
    }

    public synchronized int getNextFeatureID() {
        return this.packageHandler.getNextFeatureID();
    }

    public long getCreationTime() {
        return this.getSystemInformation().getCreationTime();
    }

    public void setCreationTime(long creationTime) {
        this.getSystemInformation().setCreationTime(creationTime);
    }

    public HibernatePackageHandler getPackageHandler() {
        return this.packageHandler;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.packageHandler.activate();
    }

    protected void doDeactivate() throws Exception {
        if (this.hibernateSessionFactory != null) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Closing SessionFactory");
            }
            this.hibernateSessionFactory.close();
            this.hibernateSessionFactory = null;
        }
        if (this.doDropSchema) {
            Configuration conf = this.getHibernateConfiguration();
            SchemaExport se = new SchemaExport(conf);
            se.drop(false, true);
        }
        this.hibernateConfiguration = null;
        LifecycleUtil.deactivate((Object)((Object)this.packageHandler), (OMLogger.Level)OMLogger.Level.WARN);
        super.doDeactivate();
    }

    protected StoreAccessorPool getReaderPool(ISession session, boolean forReleasing) {
        return null;
    }

    protected StoreAccessorPool getWriterPool(IView view, boolean forReleasing) {
        return null;
    }

    protected void reInitialize() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Re-Initializing HibernateStore");
        }
        if (this.hibernateSessionFactory != null) {
            if (!this.hibernateSessionFactory.isClosed()) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Closing SessionFactory");
                }
                this.hibernateSessionFactory.close();
            }
            this.hibernateSessionFactory = null;
        }
    }

    protected void initConfiguration() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Initializing Configuration");
        }
        InputStream in = null;
        try {
            try {
                this.hibernateConfiguration = new Configuration();
                if (this.mappingProvider != null) {
                    this.mappingProvider.setHibernateStore(this);
                    this.mappingXml = this.mappingProvider.getMapping();
                    this.hibernateConfiguration.addXML(this.mappingXml);
                }
                if (TRACER.isEnabled()) {
                    TRACER.trace("Adding resource.hbm.xml to configuration");
                }
                in = OM.BUNDLE.getInputStream(RESOURCE_HBM_PATH);
                this.hibernateConfiguration.addInputStream(in);
                this.hibernateConfiguration.setInterceptor((Interceptor)new CDOInterceptor());
                this.hibernateConfiguration.getEventListeners().setMergeEventListeners(new MergeEventListener[]{new CDOMergeEventListener()});
                Properties props = new Properties();
                props.putAll((Map<?, ?>)this.getProperties());
                this.hibernateConfiguration.setProperties(props);
                if (this.hibernateConfiguration.getProperty("hibernate.hbm2ddl.auto") != null && this.hibernateConfiguration.getProperty("hibernate.hbm2ddl.auto").startsWith(HBM2DLL_CREATE)) {
                    this.doDropSchema = true;
                    this.hibernateConfiguration.setProperty("hibernate.hbm2ddl.auto", HBM2DLL_UPDATE);
                } else {
                    this.doDropSchema = false;
                }
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((Closeable)in);
    }

    public static HibernateStore getCurrentHibernateStore() {
        return currentHibernateStore.get();
    }

    public boolean isFirstStart() {
        return this.getSystemInformation().isFirstTime();
    }

    private SystemInformation getSystemInformation() {
        if (this.systemInformation == null) {
            this.systemInformation = this.getPackageHandler().getSystemInformation();
        }
        return this.systemInformation;
    }
}

