/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.Serializable;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreAccessor;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.WrappedHibernateList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;

public class HibernateQueryHandler
implements IQueryHandler {
    @Deprecated
    public static final String QUERY_LANGUAGE = "hql";
    @Deprecated
    public static final String FIRST_RESULT = "firstResult";
    private HibernateStoreAccessor hibernateStoreAccessor;

    public void executeQuery(CDOQueryInfo info, IQueryContext context) {
        Session session = this.hibernateStoreAccessor.getHibernateSession();
        Query query = session.createQuery(info.getQueryString());
        int firstResult = -1;
        boolean cacheResults = true;
        for (String key : info.getParameters().keySet()) {
            if (key.compareToIgnoreCase("cacheResults") == 0) {
                try {
                    cacheResults = (Boolean)info.getParameters().get(key);
                    continue;
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Parameter cacheResults must be a boolean. errorMessage " + e.getMessage());
                }
            }
            if (key.compareToIgnoreCase(FIRST_RESULT) == 0) {
                Object o = info.getParameters().get(key);
                if (o == null) continue;
                try {
                    firstResult = (Integer)o;
                    continue;
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Parameter firstResult must be an integer but it is a " + o + " class " + o.getClass().getName());
                }
            }
            Object param = info.getParameters().get(key);
            if (param instanceof CDOID && HibernateUtil.getInstance().isStoreCreatedID((CDOID)param)) {
                CDOID id = (CDOID)param;
                String entityName = HibernateUtil.getInstance().getEntityName(id);
                Serializable idValue = HibernateUtil.getInstance().getIdValue(id);
                CDORevision revision = (CDORevision)session.get(entityName, idValue);
                query.setEntity(key, (Object)revision);
                if (!cacheResults) continue;
                this.addToRevisionCache(revision);
                continue;
            }
            query.setParameter(key, param);
        }
        if (firstResult > -1) {
            query.setFirstResult(firstResult);
        }
        if (info.getMaxResults() != -1) {
            query.setMaxResults(info.getMaxResults());
        }
        for (Object o : query.list()) {
            boolean addOneMore = context.addResult(o);
            if (cacheResults && o instanceof CDORevision) {
                this.addToRevisionCache((CDORevision)o);
            }
            if (addOneMore) continue;
            return;
        }
    }

    private void addToRevisionCache(CDORevision revision) {
        InternalCDORevision internalRevision = (InternalCDORevision)revision;
        for (EStructuralFeature feature : revision.getEClass().getEAllStructuralFeatures()) {
            if (!this.isMappedFeature(internalRevision, feature) || !feature.isMany() && !(feature instanceof EReference)) continue;
            Object value = internalRevision.getValue(feature);
            if (value instanceof WrappedHibernateList) {
                Hibernate.initialize(((WrappedHibernateList)value).getDelegate());
                continue;
            }
            Hibernate.initialize((Object)value);
        }
        this.hibernateStoreAccessor.addToRevisionCache(revision);
    }

    private boolean isMappedFeature(InternalCDORevision revision, EStructuralFeature feature) {
        try {
            int featureID = revision.getClassInfo().getEClass().getFeatureID(feature);
            revision.getClassInfo().getFeatureIndex(featureID);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    public HibernateStoreAccessor getHibernateStoreAccessor() {
        return this.hibernateStoreAccessor;
    }

    public void setHibernateStoreAccessor(HibernateStoreAccessor hibernateStoreAccessor) {
        this.hibernateStoreAccessor = hibernateStoreAccessor;
    }
}

