/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCDOPackageUnitDTO;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.SystemInformation;
import org.eclipse.emf.cdo.server.internal.hibernate.SystemProperty;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePackageHandler
extends Lifecycle {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernatePackageHandler.class);
    private static final boolean ZIP_PACKAGE_BYTES = true;
    private static final String CDO_PACKAGE_UNIT_ENTITY_NAME = "CDOPackageUnit";
    private static final String META_HBM_PATH = "mappings/meta.hbm.xml";
    private static final String HBM2DLL_UPDATE = "update";
    private static final String HBM2DLL_CREATE = "create";
    private Configuration configuration;
    private SessionFactory sessionFactory;
    private int nextPackageID;
    private int nextClassID;
    private int nextFeatureID;
    private Collection<InternalCDOPackageUnit> packageUnits;
    private Map<String, byte[]> ePackageBlobsByRootUri = new HashMap<String, byte[]>();
    private Map<String, EPackage[]> ePackagesByRootUri = new HashMap<String, EPackage[]>();
    private HibernateStore hibernateStore;
    private boolean doDropSchema;

    private static synchronized boolean writePackageUnits(InternalCDOPackageUnit[] packageUnits, SessionFactory sessionFactory, EPackage.Registry registry) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Persisting new EPackages");
        }
        Session session = sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        boolean err = true;
        boolean updated = false;
        try {
            try {
                InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
                int n = packageUnits.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                    HibernateCDOPackageUnitDTO hbPackageUnitDTO = new HibernateCDOPackageUnitDTO((CDOPackageUnit)packageUnit);
                    if (packageUnit.getPackageInfos().length > 0) {
                        String rootNSUri = packageUnit.getTopLevelPackageInfo().getPackageURI();
                        EPackage rootEPackage = registry.getEPackage(rootNSUri);
                        hbPackageUnitDTO.setEPackageByteArray(EMFUtil.getEPackageBytes((EPackage)rootEPackage, (boolean)true, (EPackage.Registry)registry));
                    }
                    if (session.get(CDO_PACKAGE_UNIT_ENTITY_NAME, (Serializable)((Object)hbPackageUnitDTO.getNsUri())) == null) {
                        session.saveOrUpdate(CDO_PACKAGE_UNIT_ENTITY_NAME, (Object)hbPackageUnitDTO);
                    }
                    updated = true;
                    ++n2;
                }
                tx.commit();
                err = false;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw WrappedException.wrap((Exception)e);
            }
        }
        finally {
            if (err) {
                tx.rollback();
            }
            session.close();
        }
        return updated;
    }

    public HibernatePackageHandler(HibernateStore store) {
        this.hibernateStore = store;
    }

    public List<EPackage> getEPackages() {
        EPackage ePackage;
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        InternalRepository localRepository = this.hibernateStore.getRepository();
        EPackage[] ePackageArray = localRepository.getPackageRegistry(false).getEPackages();
        int n = ePackageArray.length;
        int n2 = 0;
        while (n2 < n) {
            ePackage = ePackageArray[n2];
            ePackages.add(ePackage);
            ++n2;
        }
        ePackageArray = localRepository.getPackageRegistry(true).getEPackages();
        n = ePackageArray.length;
        n2 = 0;
        while (n2 < n) {
            ePackage = ePackageArray[n2];
            boolean alreadyPresent = false;
            for (EPackage ePackagePresent : ePackages) {
                if (!ePackagePresent.getNsURI().equals(ePackage.getNsURI())) continue;
                alreadyPresent = true;
                break;
            }
            if (!alreadyPresent) {
                ePackages.add(ePackage);
            }
            ++n2;
        }
        return ePackages;
    }

    private InternalCDOPackageRegistry getPackageRegistry() {
        return this.hibernateStore.getRepository().getPackageRegistry();
    }

    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits) {
        boolean updated = HibernatePackageHandler.writePackageUnits(packageUnits, this.getSessionFactory(), (EPackage.Registry)this.getPackageRegistry());
        if (updated) {
            this.reset();
            this.hibernateStore.reInitialize();
        }
    }

    public Collection<InternalCDOPackageUnit> getPackageUnits() {
        this.readPackageUnits();
        return this.packageUnits;
    }

    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        EPackage[] epacks;
        String nsUri = packageUnit.getTopLevelPackageInfo().getPackageURI();
        if (TRACER.isEnabled()) {
            TRACER.trace("Reading EPackages with root uri " + nsUri + " from db");
        }
        if ((epacks = this.ePackagesByRootUri.get(nsUri)) == null) {
            byte[] ePackageBlob = this.ePackageBlobsByRootUri.get(nsUri);
            if (ePackageBlob == null) {
                throw new IllegalArgumentException("EPackages with root uri " + nsUri + " not found");
            }
            ResourceSet resourceSet = EMFUtil.newEcoreResourceSet((EPackage.Registry)this.getPackageRegistry());
            EPackage rootEPackage = EMFUtil.createEPackage((String)nsUri, (byte[])ePackageBlob, (boolean)true, (ResourceSet)resourceSet, (boolean)false);
            epacks = EMFUtil.getAllPackages((EPackage)rootEPackage);
            this.ePackagesByRootUri.put(nsUri, epacks);
        }
        return epacks;
    }

    protected void readPackageUnits() {
        if (this.packageUnits == null || this.packageUnits.size() == 0) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Reading Package Units from db");
            }
            Session session = this.getSessionFactory().openSession();
            try {
                Criteria criteria = session.createCriteria(CDO_PACKAGE_UNIT_ENTITY_NAME);
                List list = criteria.list();
                if (TRACER.isEnabled()) {
                    TRACER.trace("Found " + list.size() + " CDOPackageUnits in DB");
                }
                CDOModelUtil.createPackageUnit();
                this.packageUnits = new ArrayList<InternalCDOPackageUnit>();
                for (HibernateCDOPackageUnitDTO dto : list) {
                    this.packageUnits.add(dto.createCDOPackageUnit(this.getPackageRegistry()));
                    this.ePackageBlobsByRootUri.put(dto.getNsUri(), dto.getEPackageByteArray());
                }
            }
            finally {
                session.close();
            }
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Finished reading Package Units");
        }
    }

    public synchronized SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.configuration.buildSessionFactory();
        }
        return this.sessionFactory;
    }

    public synchronized int getNextPackageID() {
        return this.nextPackageID++;
    }

    public synchronized int getNextClassID() {
        return this.nextClassID++;
    }

    public synchronized int getNextFeatureID() {
        return this.nextFeatureID++;
    }

    public void reset() {
        this.packageUnits = null;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.initConfiguration();
        this.initSchema();
    }

    protected void doDeactivate() throws Exception {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        if (this.doDropSchema) {
            SchemaExport se = new SchemaExport(this.configuration);
            se.drop(false, true);
        }
        this.configuration = null;
        super.doDeactivate();
    }

    protected void initConfiguration() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Initializing configuration for CDO metadata");
        }
        InputStream in = null;
        try {
            try {
                in = OM.BUNDLE.getInputStream(META_HBM_PATH);
                this.configuration = new Configuration();
                this.configuration.addInputStream(in);
                Properties props = new Properties();
                props.putAll((Map<?, ?>)this.hibernateStore.getProperties());
                this.configuration.setProperties(props);
                if (this.configuration.getProperty("hibernate.hbm2ddl.auto") != null && this.configuration.getProperty("hibernate.hbm2ddl.auto").startsWith(HBM2DLL_CREATE)) {
                    this.doDropSchema = true;
                    this.configuration.setProperty("hibernate.hbm2ddl.auto", HBM2DLL_UPDATE);
                } else {
                    this.doDropSchema = false;
                }
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((Closeable)in);
    }

    SystemInformation getSystemInformation() {
        Session session = this.getSessionFactory().openSession();
        session.beginTransaction();
        try {
            SystemInformation systemInformation;
            Criteria c = session.createCriteria(SystemInformation.class);
            List l = c.list();
            int records = l.size();
            if (records == 0) {
                systemInformation = new SystemInformation();
                systemInformation.setFirstTime(true);
                systemInformation.setCreationTime(System.currentTimeMillis());
                session.save((Object)systemInformation);
            } else if (records == 1) {
                systemInformation = (SystemInformation)l.get(0);
                systemInformation.setFirstTime(false);
            } else {
                throw new IllegalStateException("More than one record in the cdo_system_information table");
            }
            SystemInformation systemInformation2 = systemInformation;
            return systemInformation2;
        }
        finally {
            session.getTransaction().commit();
            session.close();
        }
    }

    Map<String, String> getSystemProperties() {
        Session session = this.getSessionFactory().openSession();
        session.beginTransaction();
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            Criteria c = session.createCriteria(SystemProperty.class);
            for (Object o : c.list()) {
                SystemProperty systemProperty = (SystemProperty)o;
                result.put(systemProperty.getName(), systemProperty.getValue());
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            session.getTransaction().commit();
            session.close();
        }
    }

    void setSystemProperties(Map<String, String> properties) {
        Session session = this.getSessionFactory().openSession();
        session.beginTransaction();
        try {
            SystemProperty systemProperty;
            HashMap<String, SystemProperty> currentValues = new HashMap<String, SystemProperty>();
            Criteria c = session.createCriteria(SystemProperty.class);
            for (Object o : c.list()) {
                SystemProperty systemProperty2 = (SystemProperty)o;
                currentValues.put(systemProperty2.getName(), systemProperty2);
            }
            HashMap<String, String> newValues = new HashMap<String, String>();
            for (String key : properties.keySet()) {
                if (currentValues.containsKey(key)) {
                    systemProperty = (SystemProperty)currentValues.get(key);
                    if (properties.get(key) == null) {
                        session.delete((Object)systemProperty);
                        continue;
                    }
                    systemProperty.setValue(properties.get(key));
                    session.update((Object)systemProperty);
                    continue;
                }
                newValues.put(key, properties.get(key));
            }
            for (String key : newValues.keySet()) {
                systemProperty = new SystemProperty();
                systemProperty.setName(key);
                systemProperty.setValue((String)newValues.get(key));
                session.save((Object)systemProperty);
            }
        }
        finally {
            session.getTransaction().commit();
            session.close();
        }
    }

    protected void initSchema() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Updating db schema for Hibernate PackageHandler");
        }
        new SchemaUpdate(this.configuration).execute(true, true);
    }
}

