/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.util.HashMap;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;

public class HibernateCommitContext {
    private InternalCommitContext commitContext;
    private HashMap<CDOID, InternalCDORevision> dirtyObjects;
    private HashMap<CDOID, InternalCDORevision> newObjects;

    public InternalCommitContext getCommitContext() {
        return this.commitContext;
    }

    public void setCommitContext(InternalCommitContext commitContext) {
        this.commitContext = commitContext;
    }

    protected void initialize() {
        InternalCDORevision cdoRevision;
        if (this.dirtyObjects != null) {
            return;
        }
        this.dirtyObjects = new HashMap();
        InternalCDORevision[] internalCDORevisionArray = this.commitContext.getDirtyObjects();
        int n = internalCDORevisionArray.length;
        int n2 = 0;
        while (n2 < n) {
            cdoRevision = internalCDORevisionArray[n2];
            this.dirtyObjects.put(cdoRevision.getID(), cdoRevision);
            ++n2;
        }
        this.newObjects = new HashMap();
        internalCDORevisionArray = this.commitContext.getNewObjects();
        n = internalCDORevisionArray.length;
        n2 = 0;
        while (n2 < n) {
            cdoRevision = internalCDORevisionArray[n2];
            this.newObjects.put(cdoRevision.getID(), cdoRevision);
            ++n2;
        }
    }

    public InternalCDORevision getDirtyObject(CDOID id) {
        this.initialize();
        return this.dirtyObjects.get(id);
    }

    public InternalCDORevision getNewObject(CDOID id) {
        this.initialize();
        return this.newObjects.get(id);
    }

    public void setNewID(CDOID oldId, CDOID newId) {
        this.initialize();
        InternalCDORevision cdoRevision = this.dirtyObjects.get(oldId);
        if (cdoRevision != null) {
            this.dirtyObjects.remove(oldId);
            this.dirtyObjects.put(newId, cdoRevision);
            return;
        }
        cdoRevision = this.newObjects.get(oldId);
        if (cdoRevision != null) {
            this.newObjects.remove(oldId);
            this.newObjects.put(newId, cdoRevision);
            return;
        }
    }
}

