/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.sql.Blob;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.hibernate.Hibernate;

public class HibernateCDOPackageUnitDTO {
    private CDOPackageUnit.Type originalType;
    private long timeStamp;
    private InternalCDOPackageInfo[] packageInfos;
    private byte[] ePackageByteArray;

    public HibernateCDOPackageUnitDTO() {
    }

    public HibernateCDOPackageUnitDTO(CDOPackageUnit cdoPackageUnit) {
        this.setPackageInfos((InternalCDOPackageInfo[])cdoPackageUnit.getPackageInfos());
        this.setOriginalType(cdoPackageUnit.getOriginalType());
        this.setTimeStamp(cdoPackageUnit.getTimeStamp());
    }

    public CDOPackageUnit.Type getOriginalType() {
        return this.originalType;
    }

    public void setOriginalType(CDOPackageUnit.Type originalType) {
        this.originalType = originalType;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public InternalCDOPackageInfo[] getPackageInfos() {
        return this.packageInfos;
    }

    public void setPackageInfos(InternalCDOPackageInfo[] packageInfos) {
        this.packageInfos = packageInfos;
    }

    public byte[] getEPackageByteArray() {
        return this.ePackageByteArray;
    }

    public void setEPackageByteArray(byte[] ePackageByteArray) {
        this.ePackageByteArray = ePackageByteArray;
    }

    public void setEPackageBlob(Blob ePackageBlob) {
        this.ePackageByteArray = this.toByteArray(ePackageBlob);
    }

    private byte[] toByteArray(Blob blob) {
        try {
            InputStream is = blob.getBinaryStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4000];
            try {
                int dataSize;
                while ((dataSize = is.read(buffer)) != -1) {
                    bos.write(buffer, 0, dataSize);
                }
            }
            finally {
                IOUtil.close((Closeable)is);
            }
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw WrappedException.wrap((Exception)e);
        }
    }

    public Blob getEPackageBlob() {
        return Hibernate.createBlob((byte[])this.getEPackageByteArray());
    }

    public InternalCDOPackageUnit createCDOPackageUnit(InternalCDOPackageRegistry packageRegistry) {
        InternalCDOPackageUnit packageUnit = (InternalCDOPackageUnit)CDOModelUtil.createPackageUnit();
        packageUnit.setOriginalType(this.originalType);
        packageUnit.setTimeStamp(this.timeStamp);
        packageUnit.setPackageRegistry(packageRegistry);
        packageUnit.setPackageInfos(this.packageInfos);
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = this.packageInfos;
        int n = this.packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            packageInfo.setPackageUnit(packageUnit);
            ++n2;
        }
        return packageUnit;
    }

    public String getNsUri() {
        return this.getPackageInfos()[0].getPackageURI();
    }

    public void setNsUri(String nsUri) {
    }
}

