/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateMappingProvider;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class FileHibernateMappingProvider
extends HibernateMappingProvider {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, FileHibernateMappingProvider.class);
    private final String mappingFileLocation;

    public FileHibernateMappingProvider(String mappingFileLocation) {
        if (mappingFileLocation == null || mappingFileLocation.length() == 0) {
            throw new IllegalArgumentException("mappingFileLocation");
        }
        this.mappingFileLocation = mappingFileLocation;
    }

    public String getMapping() {
        String string;
        if (TRACER.isEnabled()) {
            TRACER.trace("Adding hibernate mapping from location(s): " + this.mappingFileLocation);
        }
        InputStream is = null;
        try {
            String line;
            is = this.getClass().getResourceAsStream(this.mappingFileLocation);
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            string = sb.toString();
        }
        catch (Exception e) {
            try {
                throw WrappedException.wrap((Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)is);
        return string;
    }
}

