/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ContainerInfoConverter {
    private static String SEPARATOR = "_:_";
    private static String CONTAINER_PREFIX = "-";
    private static ContainerInfoConverter instance = new ContainerInfoConverter();

    public static ContainerInfoConverter getInstance() {
        return instance;
    }

    public static void setInstance(ContainerInfoConverter instance) {
        ContainerInfoConverter.instance = instance;
    }

    public String convertContainerRelationToString(InternalCDORevision cdoRevision) {
        return this.convertContainerRelationToString(cdoRevision, (CDOID)cdoRevision.getContainerID());
    }

    public String convertContainerRelationToString(InternalCDORevision cdoRevision, CDOID containerID) {
        if (containerID == null || containerID.isNull() || containerID.isTemporary()) {
            return null;
        }
        String strCDOID = HibernateUtil.getInstance().convertCDOIDToString(containerID);
        if (!HibernateUtil.getInstance().isStoreCreatedID(containerID)) {
            return String.valueOf(strCDOID) + SEPARATOR + cdoRevision.getContainingFeatureID();
        }
        if (cdoRevision.getContainingFeatureID() < 0) {
            String entityName = HibernateUtil.getInstance().getEntityName(containerID);
            HibernateStore store = HibernateThreadContext.getCurrentStoreAccessor().getStore();
            EClass containerEClass = store.getEClass(entityName);
            int featureID = -1 - cdoRevision.getContainingFeatureID();
            EStructuralFeature eFeature = containerEClass.getEStructuralFeature(featureID);
            return String.valueOf(strCDOID) + SEPARATOR + "-" + eFeature.getName();
        }
        EClass eContainedEClass = cdoRevision.getEClass();
        EStructuralFeature eFeature = eContainedEClass.getEStructuralFeature(cdoRevision.getContainingFeatureID());
        return String.valueOf(strCDOID) + SEPARATOR + eFeature.getName();
    }

    public void setContainerRelationFromString(InternalCDORevision cdoRevision, String containerInfo) {
        if (containerInfo == null) {
            return;
        }
        int index = containerInfo.lastIndexOf(SEPARATOR);
        if (index == -1) {
            return;
        }
        CDOID containerID = HibernateUtil.getInstance().convertStringToCDOID(containerInfo.substring(0, index));
        cdoRevision.setContainerID((Object)containerID);
        String containerFeatureStr = containerInfo.substring(index + SEPARATOR.length());
        if (containerID instanceof CDOIDExternal) {
            cdoRevision.setContainingFeatureID(Integer.parseInt(containerFeatureStr));
            return;
        }
        if (containerFeatureStr.startsWith(CONTAINER_PREFIX)) {
            CDOClassifierRef classifierRef = CDOIDUtil.getClassifierRef((CDOID)containerID);
            if (classifierRef == null) {
                throw new IllegalArgumentException("This CDOID type of " + containerID + " is not supported by this store.");
            }
            EClass containerEClass = HibernateUtil.getInstance().getEClass(classifierRef);
            EStructuralFeature eFeature = containerEClass.getEStructuralFeature(containerFeatureStr.substring(1));
            int containerFeatureID = -1 - containerEClass.getFeatureID(eFeature);
            cdoRevision.setContainingFeatureID(containerFeatureID);
            return;
        }
        EClass eContainedEClass = cdoRevision.getEClass();
        EStructuralFeature eFeature = eContainedEClass.getEStructuralFeature(containerFeatureStr);
        cdoRevision.setContainingFeatureID(eContainedEClass.getFeatureID(eFeature));
    }
}

