/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DBType {
    BOOLEAN(16){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            DBType.writeValueBoolean(out, resultSet, column, canBeNull);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            DBType.readValueBoolean(in, statement, column, canBeNull, this.getCode());
        }
    }
    ,
    BIT(-7){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            DBType.writeValueBoolean(out, resultSet, column, canBeNull);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            DBType.readValueBoolean(in, statement, column, canBeNull, this.getCode());
        }
    }
    ,
    TINYINT(-6){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            byte value = resultSet.getByte(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeByte((int)value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            byte value = in.readByte();
            statement.setByte(column, value);
        }
    }
    ,
    SMALLINT(5){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            short value = resultSet.getShort(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeShort((int)value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            short value = in.readShort();
            statement.setShort(column, value);
        }
    }
    ,
    INTEGER(4){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            int value = resultSet.getInt(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeInt(value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            int value = in.readInt();
            statement.setInt(column, value);
        }
    }
    ,
    BIGINT(-5){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            long value = resultSet.getLong(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeLong(value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            long value = in.readLong();
            statement.setLong(column, value);
        }
    }
    ,
    FLOAT(6){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            float value = resultSet.getFloat(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeFloat(value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            float value = in.readFloat();
            statement.setFloat(column, value);
        }
    }
    ,
    REAL(7){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            float value = resultSet.getFloat(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeFloat(value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            float value = in.readFloat();
            statement.setFloat(column, value);
        }
    }
    ,
    DOUBLE(8){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            double value = resultSet.getDouble(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeDouble(value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            double value = in.readDouble();
            statement.setDouble(column, value);
        }
    }
    ,
    NUMERIC(2){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            throw new UnsupportedOperationException("SQL NULL has to be considered");
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            throw new UnsupportedOperationException("SQL NULL has to be considered");
        }
    }
    ,
    DECIMAL(3){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            throw new UnsupportedOperationException("SQL NULL has to be considered");
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            throw new UnsupportedOperationException("SQL NULL has to be considered");
        }
    }
    ,
    CHAR(1){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            String value = resultSet.getString(column);
            out.writeString(value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            String value = in.readString();
            statement.setString(column, value);
        }
    }
    ,
    VARCHAR(12){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            String value = resultSet.getString(column);
            out.writeString(value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            String value = in.readString();
            statement.setString(column, value);
        }
    }
    ,
    LONGVARCHAR(-1, "LONG VARCHAR"){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            String value = resultSet.getString(column);
            out.writeString(value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            String value = in.readString();
            statement.setString(column, value);
        }
    }
    ,
    CLOB(2005){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            Clob value = resultSet.getClob(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            long length = value.length();
            Reader reader = value.getCharacterStream();
            try {
                out.writeLong(length);
                while (length-- > 0L) {
                    int c = reader.read();
                    out.writeChar(c);
                }
            }
            finally {
                IOUtil.close((Closeable)reader);
            }
        }

        public void readValue(final ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            long length = in.readLong();
            Reader reader = length > 0L ? new Reader(){

                public int read(char[] cbuf, int off, int len) throws IOException {
                    int read = 0;
                    try {
                        while (read < len) {
                            cbuf[off++] = in.readChar();
                            ++read;
                        }
                    }
                    catch (EOFException ex) {
                        read = -1;
                    }
                    return read;
                }

                public void close() throws IOException {
                }
            } : new Reader(){

                public int read(char[] cbuf, int off, int len) throws IOException {
                    return -1;
                }

                public void close() throws IOException {
                }
            };
            statement.setCharacterStream(column, reader, (int)length);
            reader.close();
        }
    }
    ,
    DATE(91){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            Date value = resultSet.getDate(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeLong(value.getTime());
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            long value = in.readLong();
            statement.setDate(column, new Date(value));
        }
    }
    ,
    TIME(92){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            Time value = resultSet.getTime(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeLong(value.getTime());
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            long value = in.readLong();
            statement.setTime(column, new Time(value));
        }
    }
    ,
    TIMESTAMP(93){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            Timestamp value = resultSet.getTimestamp(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeLong(value.getTime());
            out.writeInt(value.getNanos());
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            long value = in.readLong();
            int nanos = in.readInt();
            Timestamp timeStamp = new Timestamp(value);
            timeStamp.setNanos(nanos);
            statement.setTimestamp(column, timeStamp);
        }
    }
    ,
    BINARY(-2){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            byte[] value = resultSet.getBytes(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeInt(value.length);
            out.write(value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            byte[] value = in.readByteArray();
            statement.setBytes(column, value);
        }
    }
    ,
    VARBINARY(-3){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            byte[] value = resultSet.getBytes(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeInt(value.length);
            out.write(value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            byte[] value = in.readByteArray();
            statement.setBytes(column, value);
        }
    }
    ,
    LONGVARBINARY(-4, "LONG VARBINARY"){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            byte[] value = resultSet.getBytes(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            out.writeInt(value.length);
            out.write(value);
        }

        public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            byte[] value = in.readByteArray();
            statement.setBytes(column, value);
        }
    }
    ,
    BLOB(2004){

        public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            Blob value = resultSet.getBlob(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return;
                }
                out.writeBoolean(true);
            }
            long length = value.length();
            InputStream stream = value.getBinaryStream();
            try {
                out.writeLong(length);
                while (length-- > 0L) {
                    int b = stream.read();
                    out.writeByte(b + -128);
                }
            }
            finally {
                IOUtil.close((Closeable)stream);
            }
        }

        public void readValue(final ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return;
            }
            long length = in.readLong();
            InputStream value = null;
            try {
                value = length > 0L ? new InputStream(){

                    public int read() throws IOException {
                        return in.readByte() - -128;
                    }
                } : new ByteArrayInputStream(new byte[0]);
                statement.setBinaryStream(column, value, (int)length);
            }
            catch (Throwable throwable) {
                IOUtil.close(value);
                throw throwable;
            }
            IOUtil.close((Closeable)value);
        }
    };

    private static final int BOOLEAN_NULL = -1;
    private static final int BOOLEAN_FALSE = 0;
    private static final int BOOLEAN_TRUE = 1;
    private int code;
    private String keyword;

    private DBType(int code, String keyword) {
        this.code = code;
        this.keyword = keyword;
    }

    private DBType(int code) {
        this(code, (String)null);
    }

    public int getCode() {
        return this.code;
    }

    public String getKeyword() {
        return this.keyword == null ? super.toString() : this.keyword;
    }

    public String toString() {
        return this.getKeyword();
    }

    public abstract void writeValue(ExtendedDataOutput var1, ResultSet var2, int var3, boolean var4) throws SQLException, IOException;

    public abstract void readValue(ExtendedDataInput var1, PreparedStatement var2, int var3, boolean var4) throws SQLException, IOException;

    private static void writeValueBoolean(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
        boolean value = resultSet.getBoolean(column);
        if (canBeNull) {
            if (resultSet.wasNull()) {
                out.writeByte(-1);
            } else {
                out.writeByte(value ? 1 : 0);
            }
        } else {
            out.writeBoolean(value);
        }
    }

    private static void readValueBoolean(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull, int sqlType) throws IOException, SQLException {
        block6: {
            block5: {
                if (!canBeNull) break block5;
                byte opcode = in.readByte();
                switch (opcode) {
                    case -1: {
                        statement.setNull(column, sqlType);
                        break block6;
                    }
                    case 0: {
                        statement.setBoolean(column, false);
                        break block6;
                    }
                    case 1: {
                        statement.setBoolean(column, true);
                        break block6;
                    }
                    default: {
                        throw new IOException("Invalid boolean opcode: " + opcode);
                    }
                }
            }
            boolean value = in.readBoolean();
            statement.setBoolean(column, value);
        }
    }

    public static DBType getTypeByKeyword(String keyword) {
        DBType[] values = DBType.values();
        int i = 0;
        while (i < values.length) {
            DBType dbType = values[i];
            if (dbType.getKeyword().equalsIgnoreCase(keyword)) {
                return dbType;
            }
            ++i;
        }
        return null;
    }

    /* synthetic */ DBType(String string, int n, int n2, DBType dBType) {
        this(n2);
    }

    /* synthetic */ DBType(String string, int n, int n2, String string2, DBType dBType) {
        this(n2, string2);
    }
}

