/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerWriteIndication;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public class UnlockObjectsIndication
extends CDOServerWriteIndication {
    public UnlockObjectsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)25);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        IRWLockManager.LockType lockType = in.readCDOLockType();
        int size = in.readInt();
        InternalRepository repository = this.getRepository();
        InternalLockManager lockManager = repository.getLockManager();
        InternalView view = this.getSession().getView(viewID);
        if (size == -1) {
            lockManager.unlock(true, (IView)view);
        } else {
            boolean supportingBranches = repository.isSupportingBranches();
            CDOBranch branch = view.getBranch();
            ArrayList<CDOID> keys = new ArrayList<CDOID>(size);
            int i = 0;
            while (i < size) {
                CDOID id = in.readCDOID();
                CDOID key = supportingBranches ? CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)branch) : id;
                keys.add(key);
                ++i;
            }
            lockManager.unlock(true, lockType, (IView)view, keys);
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        out.writeBoolean(true);
    }
}

