/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerIndicationWithMonitoring;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.monitor.ProgressDistributor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTransactionIndication
extends CDOServerIndicationWithMonitoring {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CommitTransactionIndication.class);
    protected InternalCommitContext commitContext;

    public CommitTransactionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)11);
    }

    protected CommitTransactionIndication(CDOServerProtocol protocol, short signalID) {
        super(protocol, signalID);
    }

    @Override
    protected InternalCDOPackageRegistry getPackageRegistry() {
        return this.commitContext.getPackageRegistry();
    }

    @Override
    protected void indicatingFailed() {
        if (this.commitContext != null) {
            this.commitContext.postCommit(false);
            this.commitContext = null;
        }
    }

    @Override
    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        try {
            try {
                monitor.begin(10.0);
                this.indicatingCommit(in, monitor.fork(1.0));
                this.indicatingCommit(monitor.fork(9.0));
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                throw WrappedException.wrap((Exception)ex);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void indicatingCommit(CDODataInput in, OMMonitor monitor) throws Exception {
        this.initializeCommitContext(in);
        this.commitContext.preWrite();
        boolean autoReleaseLocksEnabled = in.readBoolean();
        this.commitContext.setAutoReleaseLocksEnabled(autoReleaseLocksEnabled);
        String commitComment = in.readString();
        InternalCDOPackageUnit[] newPackageUnits = new InternalCDOPackageUnit[in.readInt()];
        InternalCDORevision[] newObjects = new InternalCDORevision[in.readInt()];
        InternalCDORevisionDelta[] dirtyObjectDeltas = new InternalCDORevisionDelta[in.readInt()];
        CDOID[] detachedObjects = new CDOID[in.readInt()];
        monitor.begin((double)(newPackageUnits.length + newObjects.length + dirtyObjectDeltas.length + detachedObjects.length));
        try {
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} new package units", new Object[]{newPackageUnits.length});
            }
            InternalCDOPackageRegistry packageRegistry = this.commitContext.getPackageRegistry();
            ResourceSet resourceSet = this.createResourceSet(packageRegistry);
            int i = 0;
            while (i < newPackageUnits.length) {
                newPackageUnits[i] = (InternalCDOPackageUnit)in.readCDOPackageUnit(resourceSet);
                packageRegistry.putPackageUnit(newPackageUnits[i]);
                monitor.worked();
                ++i;
            }
            EMFUtil.safeResolveAll((ResourceSet)resourceSet);
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} new objects", new Object[]{newObjects.length});
            }
            i = 0;
            while (i < newObjects.length) {
                newObjects[i] = (InternalCDORevision)in.readCDORevision();
                monitor.worked();
                ++i;
            }
            Arrays.sort(newObjects, new Comparator<InternalCDORevision>(){

                @Override
                public int compare(InternalCDORevision r1, InternalCDORevision r2) {
                    return r1.getID().compareTo((Object)r2.getID());
                }
            });
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} dirty object deltas", new Object[]{dirtyObjectDeltas.length});
            }
            i = 0;
            while (i < dirtyObjectDeltas.length) {
                dirtyObjectDeltas[i] = (InternalCDORevisionDelta)in.readCDORevisionDelta();
                monitor.worked();
                ++i;
            }
            HashMap<CDOID, EClass> detachedObjectTypes = null;
            if (this.getRepository().isEnsuringReferentialIntegrity()) {
                detachedObjectTypes = new HashMap<CDOID, EClass>();
            }
            int i2 = 0;
            while (i2 < detachedObjects.length) {
                CDOID id;
                detachedObjects[i2] = id = in.readCDOID();
                if (detachedObjectTypes != null) {
                    EClass eClass = (EClass)in.readCDOClassifierRefAndResolve();
                    detachedObjectTypes.put(id, eClass);
                }
                monitor.worked();
                ++i2;
            }
            if (detachedObjectTypes != null && detachedObjectTypes.isEmpty()) {
                detachedObjectTypes = null;
            }
            this.commitContext.setNewPackageUnits(newPackageUnits);
            this.commitContext.setNewObjects(newObjects);
            this.commitContext.setDirtyObjectDeltas(dirtyObjectDeltas);
            this.commitContext.setDetachedObjects(detachedObjects);
            this.commitContext.setDetachedObjectTypes(detachedObjectTypes);
            this.commitContext.setCommitComment(commitComment);
            this.commitContext.setLobs(this.getIndicationStream());
        }
        finally {
            monitor.done();
        }
    }

    private ResourceSet createResourceSet(InternalCDOPackageRegistry packageRegistry) {
        ResourceSetImpl resourceSet = new ResourceSetImpl(){

            protected void demandLoad(Resource resource) throws IOException {
            }
        };
        EcoreResourceFactoryImpl resourceFactory = new EcoreResourceFactoryImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
        resourceSet.setPackageRegistry((EPackage.Registry)packageRegistry);
        return resourceSet;
    }

    protected void initializeCommitContext(CDODataInput in) throws Exception {
        int viewID = in.readInt();
        this.commitContext = this.getTransaction(viewID).createCommitContext();
    }

    protected void indicatingCommit(OMMonitor monitor) {
        ProgressDistributor distributor = this.getStore().getIndicatingCommitDistributor();
        distributor.run(InternalCommitContext.OPS, (Object)this.commitContext, monitor);
    }

    @Override
    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        boolean success = false;
        try {
            success = this.respondingException(out, this.commitContext.getRollbackMessage(), this.commitContext.getXRefs());
            if (success) {
                this.respondingResult(out);
                this.respondingMappingNewObjects(out);
            }
        }
        finally {
            this.commitContext.postCommit(success);
        }
    }

    protected boolean respondingException(CDODataOutput out, String rollbackMessage, List<CDOIDReference> xRefs) throws Exception {
        boolean success = rollbackMessage == null;
        out.writeBoolean(success);
        if (!success) {
            out.writeString(rollbackMessage);
            out.writeCDOBranchPoint(this.commitContext.getBranchPoint());
            out.writeLong(this.commitContext.getPreviousTimeStamp());
            if (xRefs != null) {
                out.writeInt(xRefs.size());
                for (CDOIDReference xRef : xRefs) {
                    out.writeCDOIDReference(xRef);
                }
            } else {
                out.writeInt(0);
            }
        }
        return success;
    }

    protected void respondingResult(CDODataOutput out) throws Exception {
        out.writeCDOBranchPoint(this.commitContext.getBranchPoint());
        out.writeLong(this.commitContext.getPreviousTimeStamp());
    }

    protected void respondingMappingNewObjects(CDODataOutput out) throws Exception {
        Map idMappings = this.commitContext.getIDMappings();
        for (Map.Entry entry : idMappings.entrySet()) {
            CDOID oldID = (CDOID)entry.getKey();
            CDOID newID = (CDOID)entry.getValue();
            out.writeCDOID(oldID);
            out.writeCDOID(newID);
        }
        out.writeCDOID(CDOID.NULL);
    }

    protected InternalTransaction getTransaction(int viewID) {
        InternalView view = this.getSession().getView(viewID);
        if (view instanceof InternalTransaction) {
            return (InternalTransaction)view;
        }
        throw new IllegalStateException("Illegal transaction: " + view);
    }
}

