/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IStreamWrapper;

public class GZIPStreamWrapper
implements IStreamWrapper {
    public GZIPInputStream wrapInputStream(InputStream in) throws IOException {
        if (in instanceof GZIPInputStream) {
            return (GZIPInputStream)in;
        }
        return new GZIPInputStream(in);
    }

    public GZIPOutputStream wrapOutputStream(OutputStream out) throws IOException {
        if (out instanceof GZIPOutputStream) {
            return (GZIPOutputStream)out;
        }
        return new GZIPOutputStream(out);
    }

    public void finishInputStream(InputStream in) throws IOException {
    }

    public void finishOutputStream(OutputStream out) throws IOException {
        ((GZIPOutputStream)out).finish();
    }

    public static void main(String[] args) throws Exception {
        PipedOutputStream pos = new PipedOutputStream();
        final PipedInputStream pis = new PipedInputStream(pos);
        GZIPOutputStream gos = new GZIPOutputStream(pos);
        final byte[] out = "eike".getBytes();
        Thread thread = new Thread(){

            public void run() {
                try {
                    GZIPInputStream gis = new GZIPInputStream(pis);
                    byte[] in = new byte[out.length];
                    gis.read(in);
                    gis.close();
                }
                catch (IOException ex) {
                    throw new IORuntimeException(ex);
                }
            }
        };
        thread.start();
        ConcurrencyUtil.sleep(1000L);
        gos.write(out);
        gos.close();
        ConcurrencyUtil.sleep(2000L);
    }
}

