/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;

public class ExpectedFileInputStream
extends FileInputStream {
    private long timeout = 2500L;
    private File file;
    private long expectedSize;
    private long pos;

    public ExpectedFileInputStream(File file, long expectedSize) throws FileNotFoundException {
        super(file);
        this.file = file;
        this.expectedSize = expectedSize;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long skip(long n) throws IOException {
        this.waitForInput(n);
        return super.skip(n);
    }

    public int read() throws IOException {
        this.waitForInput(1L);
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.waitForInput(len);
        return super.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInput(long n) throws IOException {
        ExpectedFileInputStream expectedFileInputStream = this;
        synchronized (expectedFileInputStream) {
            n = Math.min(n, this.expectedSize - this.pos);
            long restSize = this.file.length() - this.pos;
            long endTime = 0L;
            while (restSize < n) {
                long restTime;
                if (endTime == 0L) {
                    endTime = System.currentTimeMillis() + this.timeout;
                    restTime = this.timeout;
                } else {
                    restTime = endTime - System.currentTimeMillis();
                }
                if (restTime <= 0L) {
                    throw new TimeoutRuntimeException("Timeout while reading from " + this.file.getAbsolutePath());
                }
                try {
                    this.wait(Math.max(100L, restTime));
                }
                catch (InterruptedException ex) {
                    throw WrappedException.wrap(ex);
                }
                restSize = this.file.length() - this.pos;
            }
            this.pos += n;
        }
    }
}

