/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.bundle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.internal.util.bundle.AbstractBundle;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.internal.util.om.LegacyPlatform;
import org.eclipse.net4j.internal.util.om.OSGiPlatform;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.OMTraceHandlerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlatform
implements OMPlatform {
    public static final String SYSTEM_PROPERTY_OSGI_STATE = "osgi.instance.area";
    public static final String SYSTEM_PROPERTY_NET4J_STATE = "net4j.state";
    public static final String SYSTEM_PROPERTY_NET4J_CONFIG = "net4j.config";
    static Object systemContext;
    private static ContextTracer __TRACER__;
    private Map<String, AbstractBundle> bundles = new ConcurrentHashMap<String, AbstractBundle>(0);
    private Queue<OMLogHandler> logHandlers = new ConcurrentLinkedQueue<OMLogHandler>();
    private Queue<OMTraceHandler> traceHandlers = new ConcurrentLinkedQueue<OMTraceHandler>();
    private boolean debugging = Boolean.parseBoolean(this.getProperty("debug", "false"));

    protected AbstractPlatform() {
    }

    @Override
    public synchronized OMBundle bundle(String bundleID, Class<?> accessor) {
        OMBundle bundle = this.bundles.get(bundleID);
        if (bundle == null) {
            bundle = this.createBundle(bundleID, accessor);
        }
        return bundle;
    }

    @Override
    public void addLogHandler(OMLogHandler logHandler) {
        if (!this.logHandlers.contains(logHandler)) {
            this.logHandlers.add(logHandler);
        }
    }

    @Override
    public void removeLogHandler(OMLogHandler logHandler) {
        this.logHandlers.remove(logHandler);
    }

    @Override
    public void addTraceHandler(OMTraceHandler traceHandler) {
        if (!this.traceHandlers.contains(traceHandler)) {
            this.traceHandlers.add(traceHandler);
        }
    }

    @Override
    public void removeTraceHandler(OMTraceHandler traceHandler) {
        this.traceHandlers.remove(traceHandler);
    }

    @Override
    public boolean isExtensionRegistryAvailable() {
        try {
            return AbstractPlatform.internalExtensionRegistryAvailable();
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public boolean isDebugging() {
        return this.debugging;
    }

    @Override
    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    @Override
    public File getStateFolder() {
        File stateFolder;
        String state = this.getProperty(SYSTEM_PROPERTY_NET4J_STATE);
        if (state == null) {
            state = this.getProperty(SYSTEM_PROPERTY_OSGI_STATE);
            if (state == null) {
                state = "state";
            } else {
                try {
                    URI uri = new URI(state);
                    state = new File(new File(uri), ".metadata").getAbsolutePath();
                }
                catch (Exception ex) {
                    OM.LOG.error("Property osgi.instance.area is not a proper file URI: " + state);
                    state = "state";
                }
            }
        }
        if (!(stateFolder = new File(state)).exists() && !stateFolder.mkdirs()) {
            throw new IORuntimeException("State folder " + stateFolder.getAbsolutePath() + " could not be created");
        }
        if (!stateFolder.isDirectory()) {
            throw new IORuntimeException("State folder " + stateFolder.getAbsolutePath() + " is not a directoy");
        }
        return stateFolder;
    }

    @Override
    public File getConfigFolder() {
        String config = this.getProperty(SYSTEM_PROPERTY_NET4J_CONFIG, "config");
        File configFolder = new File(config);
        if (!configFolder.exists() && !configFolder.mkdirs()) {
            OM.LOG.error("Config folder " + configFolder.getAbsolutePath() + " could not be created");
            return null;
        }
        if (!configFolder.isDirectory()) {
            OM.LOG.error("Config folder " + configFolder.getAbsolutePath() + " is not a directoy");
            return null;
        }
        return configFolder;
    }

    @Override
    public File getConfigFile(String name) {
        File configFolder = this.getConfigFolder();
        if (configFolder == null) {
            return null;
        }
        return new File(configFolder, name);
    }

    @Override
    public Properties getConfigProperties(String name) {
        Properties properties;
        File configFile = this.getConfigFile(name);
        if (configFile == null) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configFile);
            Properties properties2 = new Properties();
            properties2.load(fis);
            properties = properties2;
        }
        catch (IOException ex) {
            try {
                OM.LOG.error("Config file " + configFile.getAbsolutePath() + " could not be read");
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(fis);
                throw throwable;
            }
            IOUtil.closeSilent(fis);
            return null;
        }
        IOUtil.closeSilent(fis);
        return properties;
    }

    public void log(OMLogger logger, OMLogger.Level level, String msg, Throwable t) {
        for (OMLogHandler logHandler : this.logHandlers) {
            try {
                logHandler.logged(logger, level, msg, t);
            }
            catch (Exception ex) {
                if (!AbstractPlatform.TRACER().isEnabled()) continue;
                AbstractPlatform.TRACER().trace(ex);
            }
        }
    }

    public void trace(OMTraceHandlerEvent event) {
        for (OMTraceHandler traceHandler : this.traceHandlers) {
            try {
                traceHandler.traced(event);
            }
            catch (Exception ex) {
                if (!AbstractPlatform.TRACER().isEnabled()) continue;
                AbstractPlatform.TRACER().trace(ex);
            }
        }
    }

    protected Map<String, AbstractBundle> getBundles() {
        return this.bundles;
    }

    @Override
    public String getProperty(String key) {
        return System.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }

    protected abstract OMBundle createBundle(String var1, Class<?> var2);

    protected abstract String getDebugOption(String var1, String var2);

    protected abstract void setDebugOption(String var1, String var2, String var3);

    public static synchronized OMPlatform createPlatform() {
        try {
            if (systemContext != null) {
                return new OSGiPlatform(systemContext);
            }
            return new LegacyPlatform();
        }
        catch (Exception ex) {
            if (AbstractPlatform.TRACER().isEnabled()) {
                AbstractPlatform.TRACER().trace(ex);
            }
            return null;
        }
    }

    private static ContextTracer TRACER() {
        if (__TRACER__ == null) {
            __TRACER__ = new ContextTracer(OM.DEBUG_OM, AbstractPlatform.class);
        }
        return __TRACER__;
    }

    private static boolean internalExtensionRegistryAvailable() throws Throwable {
        return Platform.getExtensionRegistry() != null;
    }
}

