/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

public class CDOSessionInvalidationAggregator {
    private CDOSession session;
    private IListener sessionListener = new IListener(){

        public void notifyEvent(IEvent event) {
            try {
                if (event instanceof CDOSessionInvalidationEvent) {
                    CDOSessionInvalidationEvent e = (CDOSessionInvalidationEvent)event;
                    CDOSessionInvalidationAggregator.this.handleEvent(e);
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
    };
    private CDOChangeSetData changeSetData;

    public CDOSessionInvalidationAggregator(CDOSession session) {
        this.session = session;
        session.addListener(this.sessionListener);
    }

    public void dispose() {
        this.reset();
        this.session.removeListener(this.sessionListener);
        this.session = null;
    }

    public CDOSession getSession() {
        return this.session;
    }

    public CDOChangeSetData getChangeSetData() {
        return this.changeSetData;
    }

    public void reset() {
        this.changeSetData = null;
    }

    protected void handleEvent(CDOSessionInvalidationEvent event) throws Exception {
        CDOChangeSetData copy = event.copy();
        if (this.changeSetData == null) {
            this.changeSetData = copy;
        } else {
            this.changeSetData.merge(copy);
        }
    }
}

