/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lob.CDOLobInfo;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticator;
import org.eclipse.emf.cdo.common.revision.CDOElementProxy;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.common.util.RepositoryStateChangedEvent;
import org.eclipse.emf.cdo.common.util.RepositoryTypeChangedEvent;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSingleValueFeatureDeltaImpl;
import org.eclipse.emf.cdo.session.CDOCollectionLoadingPolicy;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.spi.common.CDOLobStoreImpl;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOFeatureDeltaVisitorImpl;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.internal.cdo.analyzer.NOOPFetchRuleManager;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.object.CDOFactoryImpl;
import org.eclipse.emf.internal.cdo.session.DelegatingSessionProtocol;
import org.eclipse.emf.internal.cdo.session.SessionUtil;
import org.eclipse.emf.internal.cdo.session.remote.CDORemoteSessionManagerImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOTransactionImpl;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.RWLockManager;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.OptionsEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOSessionImpl
extends Container<CDOView>
implements InternalCDOSession {
    private CDOSession.ExceptionHandler exceptionHandler;
    private InternalCDOPackageRegistry packageRegistry;
    private InternalCDOBranchManager branchManager;
    private InternalCDORevisionManager revisionManager;
    private InternalCDOCommitInfoManager commitInfoManager;
    private CDOSessionProtocol sessionProtocol;
    @ReflectUtil.ExcludeFromDump
    private IListener sessionProtocolListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            CDOSessionImpl.this.sessionProtocolDeactivated();
        }
    };
    private int sessionID;
    private String userID;
    private long lastUpdateTime;
    @ReflectUtil.ExcludeFromDump
    private LastUpdateTimeLock lastUpdateTimeLock = new LastUpdateTimeLock();
    private CDOSession.Options options = this.createOptions();
    private OutOfSequenceInvalidations outOfSequenceInvalidations = new OutOfSequenceInvalidations();
    private CDORepositoryInfo repositoryInfo;
    private CDOFetchRuleManager ruleManager = new NOOPFetchRuleManager(){

        public CDOCollectionLoadingPolicy getCollectionLoadingPolicy() {
            return CDOSessionImpl.this.options().getCollectionLoadingPolicy();
        }
    };
    private IRWLockManager<CDOSessionImpl, Object> lockmanager = new RWLockManager();
    @ReflectUtil.ExcludeFromDump
    private Set<CDOSessionImpl> singletonCollection = Collections.singleton(this);
    private boolean mainBranchLocal;
    private CDOAuthenticator authenticator;
    private InternalCDORemoteSessionManager remoteSessionManager;
    private Set<InternalCDOView> views = new HashSet<InternalCDOView>();
    private Map<CDOID, CDOBranchPoint> committedSinceLastRefresh = new HashMap<CDOID, CDOBranchPoint>();
    @ReflectUtil.ExcludeFromDump
    private int lastViewID;

    @Override
    public CDORepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    @Override
    public void setRepositoryInfo(CDORepositoryInfo repositoryInfo) {
        this.repositoryInfo = repositoryInfo;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    @Override
    public void setSessionID(int sessionID) {
        this.sessionID = sessionID;
    }

    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Override
    public CDOSession.ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void setExceptionHandler(CDOSession.ExceptionHandler exceptionHandler) {
        this.checkInactive();
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    @Override
    public void setPackageRegistry(InternalCDOPackageRegistry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    @Override
    public InternalCDOBranchManager getBranchManager() {
        return this.branchManager;
    }

    @Override
    public void setBranchManager(InternalCDOBranchManager branchManager) {
        this.branchManager = branchManager;
    }

    @Override
    public InternalCDORevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    @Override
    public void setRevisionManager(InternalCDORevisionManager revisionManager) {
        this.revisionManager = revisionManager;
    }

    @Override
    public InternalCDOCommitInfoManager getCommitInfoManager() {
        return this.commitInfoManager;
    }

    @Override
    public void setCommitInfoManager(InternalCDOCommitInfoManager commitInfoManager) {
        this.commitInfoManager = commitInfoManager;
    }

    @Override
    public CDOSessionProtocol getSessionProtocol() {
        return this.sessionProtocol;
    }

    @Override
    public void setSessionProtocol(CDOSessionProtocol sessionProtocol) {
        if (this.exceptionHandler == null) {
            this.sessionProtocol = sessionProtocol;
        } else if (this.sessionProtocol instanceof DelegatingSessionProtocol) {
            ((DelegatingSessionProtocol)this.sessionProtocol).setDelegate(sessionProtocol);
        } else {
            this.sessionProtocol = new DelegatingSessionProtocol(sessionProtocol, this.exceptionHandler);
        }
    }

    @Override
    public CDOFetchRuleManager getFetchRuleManager() {
        return this.ruleManager;
    }

    @Override
    public void setFetchRuleManager(CDOFetchRuleManager fetchRuleManager) {
        this.ruleManager = fetchRuleManager;
    }

    @Override
    public CDOAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public void setAuthenticator(CDOAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public boolean isMainBranchLocal() {
        return this.mainBranchLocal;
    }

    @Override
    public void setMainBranchLocal(boolean mainBranchLocal) {
        this.mainBranchLocal = mainBranchLocal;
    }

    @Override
    public InternalCDORemoteSessionManager getRemoteSessionManager() {
        return this.remoteSessionManager;
    }

    @Override
    public void setRemoteSessionManager(InternalCDORemoteSessionManager remoteSessionManager) {
        this.remoteSessionManager = remoteSessionManager;
    }

    @Override
    public CDOLobStore getLobStore() {
        final CDOLobStore cache = this.options().getLobCache();
        return new CDOLobStore.Delegating(){

            public InputStream getBinary(CDOLobInfo info) throws IOException {
                while (true) {
                    try {
                        return super.getBinary(info);
                    }
                    catch (FileNotFoundException couldNotBeRead) {
                        try {
                            this.loadBinary(info);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        continue;
                    }
                    break;
                }
            }

            public Reader getCharacter(CDOLobInfo info) throws IOException {
                while (true) {
                    try {
                        return super.getCharacter(info);
                    }
                    catch (FileNotFoundException couldNotBeRead) {
                        try {
                            this.loadCharacter(info);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        continue;
                    }
                    break;
                }
            }

            private void loadBinary(final CDOLobInfo info) throws IOException {
                final File file = this.getDelegate().getBinaryFile(info.getID());
                final FileOutputStream out = new FileOutputStream(file);
                CDOSessionImpl.this.loadLobAsync(info, new Runnable(){

                    public void run() {
                        try {
                            CDOSessionImpl.this.getSessionProtocol().loadLob(info, out);
                        }
                        catch (Throwable t) {
                            OM.LOG.error(t);
                            IOUtil.delete((File)file);
                        }
                    }
                });
            }

            private void loadCharacter(final CDOLobInfo info) throws IOException {
                final File file = this.getDelegate().getCharacterFile(info.getID());
                final FileWriter out = new FileWriter(file);
                CDOSessionImpl.this.loadLobAsync(info, new Runnable(){

                    public void run() {
                        try {
                            CDOSessionImpl.this.getSessionProtocol().loadLob(info, out);
                        }
                        catch (Throwable t) {
                            OM.LOG.error(t);
                            IOUtil.delete((File)file);
                        }
                    }
                });
            }

            protected CDOLobStore getDelegate() {
                return cache;
            }
        };
    }

    protected void loadLobAsync(CDOLobInfo info, Runnable runnable) {
        new Thread(runnable, "LobLoader").start();
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    @Override
    public CDOSession.Options options() {
        return this.options;
    }

    protected CDOSession.Options createOptions() {
        return new OptionsImpl();
    }

    public Object processPackage(Object value) {
        CDOFactoryImpl.prepareDynamicEPackage(value);
        return value;
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        if (packageUnit.getOriginalType().isGenerated() && !this.options().isGeneratedPackageEmulationEnabled()) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOSessionImpl.0"), packageUnit));
        }
        return this.getSessionProtocol().loadPackages(packageUnit);
    }

    public void acquireAtomicRequestLock(Object key) {
        try {
            this.lockmanager.lock(IRWLockManager.LockType.WRITE, key, (Object)this, 0L);
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public void releaseAtomicRequestLock(Object key) {
        this.lockmanager.unlock(IRWLockManager.LockType.WRITE, key, this.singletonCollection);
    }

    @Override
    public CDOTransaction openTransaction(CDOBranchPoint target, ResourceSet resourceSet) {
        this.checkArg(target.getTimeStamp() == 0L, "Target is not head of a branch: " + target);
        return null;
    }

    @Override
    public CDOTransaction openTransaction(CDOBranchPoint target) {
        return this.openTransaction(target, this.createResourceSet());
    }

    @Override
    public InternalCDOTransaction openTransaction(CDOBranch branch, ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOTransaction transaction = this.createTransaction(branch);
        this.initView(transaction, resourceSet);
        return transaction;
    }

    @Override
    public InternalCDOTransaction openTransaction(ResourceSet resourceSet) {
        return this.openTransaction((CDOBranch)this.getBranchManager().getMainBranch(), resourceSet);
    }

    @Override
    public InternalCDOTransaction openTransaction(CDOBranch branch) {
        return this.openTransaction(branch, this.createResourceSet());
    }

    @Override
    public InternalCDOTransaction openTransaction() {
        return this.openTransaction((CDOBranch)this.getBranchManager().getMainBranch());
    }

    @Override
    public CDOTransaction openTransaction(String durableLockingID) {
        return this.openTransaction(durableLockingID, this.createResourceSet());
    }

    @Override
    public CDOTransaction openTransaction(String durableLockingID, ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOTransaction transaction = this.createTransaction(durableLockingID);
        this.initView(transaction, resourceSet);
        return transaction;
    }

    protected InternalCDOTransaction createTransaction(CDOBranch branch) {
        return new CDOTransactionImpl(branch);
    }

    protected InternalCDOTransaction createTransaction(String durableLockingID) {
        return new CDOTransactionImpl(durableLockingID);
    }

    @Override
    public CDOView openView(CDOBranchPoint target, ResourceSet resourceSet) {
        return this.openView(target.getBranch(), target.getTimeStamp(), resourceSet);
    }

    @Override
    public CDOView openView(CDOBranchPoint target) {
        return this.openView(target, this.createResourceSet());
    }

    @Override
    public InternalCDOView openView(CDOBranch branch, long timeStamp, ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOView view = this.createView(branch, timeStamp);
        this.initView(view, resourceSet);
        return view;
    }

    @Override
    public InternalCDOView openView(CDOBranch branch, long timeStamp) {
        return this.openView(branch, timeStamp, this.createResourceSet());
    }

    @Override
    public InternalCDOView openView(CDOBranch branch) {
        return this.openView(branch, 0L);
    }

    @Override
    public InternalCDOView openView(long timeStamp) {
        return this.openView((CDOBranch)this.getBranchManager().getMainBranch(), timeStamp);
    }

    @Override
    public InternalCDOView openView(ResourceSet resourceSet) {
        return this.openView((CDOBranch)this.getBranchManager().getMainBranch(), 0L, resourceSet);
    }

    @Override
    public InternalCDOView openView() {
        return this.openView(0L);
    }

    @Override
    public CDOView openView(String durableLockingID) {
        return this.openView(durableLockingID, this.createResourceSet());
    }

    @Override
    public CDOView openView(String durableLockingID, ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOView view = this.createView(durableLockingID);
        this.initView(view, resourceSet);
        return view;
    }

    protected InternalCDOView createView(CDOBranch branch, long timeStamp) {
        return new CDOViewImpl(branch, timeStamp);
    }

    protected InternalCDOView createView(String durableLockingID) {
        return new CDOViewImpl(durableLockingID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewDetached(InternalCDOView view) {
        view.getViewSet().remove(view);
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            if (!this.views.remove(view)) {
                return;
            }
        }
        if (this.isActive()) {
            try {
                LifecycleUtil.deactivate((Object)view);
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        this.fireElementRemovedEvent(view);
    }

    @Override
    public CDOView getView(int viewID) {
        this.checkActive();
        InternalCDOView[] internalCDOViewArray = this.getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            if (view.getViewID() == viewID) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCDOView[] getViews() {
        this.checkActive();
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            return this.views.toArray(new InternalCDOView[this.views.size()]);
        }
    }

    public CDOView[] getElements() {
        return this.getViews();
    }

    public boolean isEmpty() {
        this.checkActive();
        return this.views.isEmpty();
    }

    @Override
    public long refresh() {
        this.checkActive();
        if (this.options().isPassiveUpdateEnabled()) {
            return 0L;
        }
        return this.refresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long refresh(boolean enablePassiveUpdates) {
        OutOfSequenceInvalidations outOfSequenceInvalidations = this.outOfSequenceInvalidations;
        synchronized (outOfSequenceInvalidations) {
            HashMap<CDOBranch, List<InternalCDOView>> views = new HashMap<CDOBranch, List<InternalCDOView>>();
            HashMap<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions = new HashMap<CDOBranch, Map<CDOID, InternalCDORevision>>();
            this.collectViewedRevisions(views, viewedRevisions);
            this.cleanupRevisionCache(viewedRevisions);
            CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
            long lastUpdateTime = this.getLastUpdateTime();
            int initialChunkSize = this.options().getCollectionLoadingPolicy().getInitialChunkSize();
            CDOSessionProtocol.RefreshSessionResult result = sessionProtocol.refresh(lastUpdateTime, viewedRevisions, initialChunkSize, enablePassiveUpdates);
            this.setLastUpdateTime(result.getLastUpdateTime());
            this.registerPackageUnits(result.getPackageUnits());
            for (Map.Entry entry : views.entrySet()) {
                CDOBranch branch = (CDOBranch)entry.getKey();
                List branchViews = (List)entry.getValue();
                this.processRefreshSessionResult(result, branch, branchViews, viewedRevisions);
            }
            return result.getLastUpdateTime();
        }
    }

    @Override
    public void processRefreshSessionResult(CDOSessionProtocol.RefreshSessionResult result, CDOBranch branch, List<InternalCDOView> branchViews, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions) {
        Map<CDOID, InternalCDORevision> oldRevisions = viewedRevisions.get(branch);
        ArrayList<CDORevisionKey> changedObjects = new ArrayList<CDORevisionKey>();
        for (InternalCDORevision newRevision : result.getChangedObjects(branch)) {
            this.getRevisionManager().addRevision((CDORevision)newRevision);
            InternalCDORevision oldRevision = oldRevisions.get(newRevision.getID());
            InternalCDORevisionDelta delta = newRevision.compare((CDORevision)oldRevision);
            changedObjects.add((CDORevisionKey)delta);
        }
        List<CDOIDAndVersion> detachedObjects = result.getDetachedObjects(branch);
        for (CDOIDAndVersion detachedObject : detachedObjects) {
            this.getRevisionManager().reviseLatest(detachedObject.getID(), branch);
        }
        for (InternalCDOView view : branchViews) {
            view.invalidate(view.getBranch(), result.getLastUpdateTime(), changedObjects, detachedObjects, oldRevisions, false);
        }
    }

    private void collectViewedRevisions(Map<CDOBranch, List<InternalCDOView>> views, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions) {
        InternalCDOView[] internalCDOViewArray = this.getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            if (view.getTimeStamp() == 0L) {
                boolean needNewMap;
                CDOBranch branch = view.getBranch();
                Map<CDOID, InternalCDORevision> revisions = viewedRevisions.get(branch);
                boolean bl = needNewMap = revisions == null;
                if (needNewMap) {
                    revisions = new HashMap<CDOID, InternalCDORevision>();
                }
                view.collectViewedRevisions(revisions);
                if (!revisions.isEmpty()) {
                    List<InternalCDOView> list = views.get(branch);
                    if (list == null) {
                        list = new ArrayList<InternalCDOView>();
                        views.put(branch, list);
                    }
                    list.add(view);
                    if (needNewMap) {
                        viewedRevisions.put(branch, revisions);
                    }
                }
            }
            ++n2;
        }
    }

    private void cleanupRevisionCache(Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions) {
        HashSet<InternalCDORevision> set = new HashSet<InternalCDORevision>();
        for (Map<CDOID, InternalCDORevision> revisions : viewedRevisions.values()) {
            for (InternalCDORevision revision : revisions.values()) {
                set.add(revision);
            }
        }
        InternalCDORevisionCache cache = this.getRevisionManager().getCache();
        List currentRevisions = cache.getCurrentRevisions();
        for (InternalCDORevision revision : currentRevisions) {
            if (set.contains(revision)) continue;
            cache.removeRevision(revision.getID(), (CDOBranchVersion)revision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastUpdateTime() {
        LastUpdateTimeLock lastUpdateTimeLock = this.lastUpdateTimeLock;
        synchronized (lastUpdateTimeLock) {
            return this.lastUpdateTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastUpdateTime(long lastUpdateTime) {
        LastUpdateTimeLock lastUpdateTimeLock = this.lastUpdateTimeLock;
        synchronized (lastUpdateTimeLock) {
            if (this.lastUpdateTime < lastUpdateTime) {
                this.lastUpdateTime = lastUpdateTime;
            }
            this.lastUpdateTimeLock.notifyAll();
        }
    }

    @Override
    public void waitForUpdate(long updateTime) {
        this.waitForUpdate(updateTime, -1L);
    }

    @Override
    public boolean waitForUpdate(long updateTime, long timeoutMillis) {
        long end = timeoutMillis == -1L ? Long.MAX_VALUE : System.currentTimeMillis() + timeoutMillis;
        for (CDOView cDOView : this.views) {
            long viewTimeoutMillis;
            boolean ok = cDOView.waitForUpdate(updateTime, viewTimeoutMillis = timeoutMillis == -1L ? -1L : end - System.currentTimeMillis());
            if (ok) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object resolveElementProxy(CDORevision revision, EStructuralFeature feature, int accessIndex, int serverIndex) {
        CDOCollectionLoadingPolicy policy = this.options().getCollectionLoadingPolicy();
        return policy.resolveProxy(revision, feature, accessIndex, serverIndex);
    }

    @Override
    public void resolveAllElementProxies(CDORevision revision) {
        CDOCollectionLoadingPolicy policy = this.options().getCollectionLoadingPolicy();
        block0: for (EStructuralFeature feature : revision.getEClass().getEAllStructuralFeatures()) {
            EReference reference;
            if (!(feature instanceof EReference) || !(reference = (EReference)feature).isMany() || !EMFUtil.isPersistent((EStructuralFeature)reference)) continue;
            CDOList list = ((InternalCDORevision)revision).getList((EStructuralFeature)reference);
            for (Object element : list) {
                if (!(element instanceof CDOElementProxy)) continue;
                policy.resolveAllProxies(revision, (EStructuralFeature)reference);
                continue block0;
            }
        }
    }

    @Override
    public void handleRepositoryTypeChanged(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        this.fireEvent((IEvent)new RepositoryTypeChangedEvent((INotifier)this, oldType, newType));
    }

    @Override
    public void handleRepositoryStateChanged(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        this.fireEvent((IEvent)new RepositoryStateChangedEvent((INotifier)this, oldState, newState));
    }

    @Override
    public void handleBranchNotification(InternalCDOBranch branch) {
        this.getBranchManager().handleBranchCreated(branch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCommitNotification(CDOCommitInfo commitInfo) {
        try {
            OutOfSequenceInvalidations outOfSequenceInvalidations = this.outOfSequenceInvalidations;
            synchronized (outOfSequenceInvalidations) {
                this.registerPackageUnits(commitInfo.getNewPackageUnits());
                this.invalidate(commitInfo, null);
            }
        }
        catch (RuntimeException ex) {
            if (this.isActive()) {
                OM.LOG.error((Throwable)ex);
            }
            OM.LOG.info(Messages.getString("CDOSessionImpl.2"));
        }
    }

    private void registerPackageUnits(List<CDOPackageUnit> packageUnits) {
        InternalCDOPackageRegistry packageRegistry = this.getPackageRegistry();
        for (CDOPackageUnit newPackageUnit : packageUnits) {
            packageRegistry.putPackageUnit((InternalCDOPackageUnit)newPackageUnit);
        }
    }

    private Map<CDOID, InternalCDORevision> reviseRevisions(CDOCommitInfo commitInfo) {
        CDOID id;
        HashMap<CDOID, InternalCDORevision> oldRevisions = null;
        CDOBranch newBranch = commitInfo.getBranch();
        long timeStamp = commitInfo.getTimeStamp();
        InternalCDORevisionManager revisionManager = this.getRevisionManager();
        for (CDOIDAndVersion key : commitInfo.getNewObjects()) {
            if (!(key instanceof InternalCDORevision)) continue;
            InternalCDORevision newRevision = (InternalCDORevision)key;
            revisionManager.addRevision((CDORevision)newRevision);
        }
        for (CDOIDAndVersion key : commitInfo.getChangedObjects()) {
            CDORevisionDelta revisionDelta;
            InternalCDORevision oldRevision;
            if (key instanceof CDORevisionDelta && (oldRevision = revisionManager.getRevisionByVersion((revisionDelta = (CDORevisionDelta)key).getID(), (CDOBranchVersion)revisionDelta, -1, false)) != null) {
                CDOFeatureDeltaVisitorImpl visitor = new CDOFeatureDeltaVisitorImpl((CDORevision)oldRevision){
                    private List<Object> workList;
                    private final /* synthetic */ CDORevision val$oldRevision;
                    {
                        this.val$oldRevision = cDORevision;
                    }

                    public void visit(CDOAddFeatureDelta delta) {
                        this.workList.add(delta.getIndex(), delta.getValue());
                    }

                    public void visit(CDOClearFeatureDelta delta) {
                        this.workList.clear();
                    }

                    public void visit(CDOListFeatureDelta deltas) {
                        List list = (List)((InternalCDORevision)this.val$oldRevision).getValue(deltas.getFeature());
                        if (list != null) {
                            this.workList = new ArrayList<Object>(list);
                            super.visit(deltas);
                        }
                    }

                    public void visit(CDOMoveFeatureDelta delta) {
                        Object value = this.workList.get(delta.getOldPosition());
                        ((CDOMoveFeatureDeltaImpl)delta).setValue(value);
                        ECollections.move(this.workList, (int)delta.getNewPosition(), (int)delta.getOldPosition());
                    }

                    public void visit(CDORemoveFeatureDelta delta) {
                        Object oldValue = this.workList.remove(delta.getIndex());
                        ((CDOSingleValueFeatureDeltaImpl)delta).setValue(oldValue);
                    }

                    public void visit(CDOSetFeatureDelta delta) {
                        EStructuralFeature feature = delta.getFeature();
                        Object value = null;
                        value = feature.isMany() ? this.workList.set(delta.getIndex(), delta.getValue()) : ((InternalCDORevision)this.val$oldRevision).getValue(feature);
                        ((CDOSetFeatureDeltaImpl)delta).setOldValue(value);
                    }
                };
                for (CDOFeatureDelta featureDelta : revisionDelta.getFeatureDeltas()) {
                    featureDelta.accept((CDOFeatureDeltaVisitor)visitor);
                }
            }
            id = key.getID();
            Pair<InternalCDORevision, InternalCDORevision> pair = this.createNewRevision((CDORevisionKey)key, commitInfo);
            if (pair != null) {
                InternalCDORevision newRevision = (InternalCDORevision)pair.getElement2();
                revisionManager.addRevision((CDORevision)newRevision);
                if (oldRevisions == null) {
                    oldRevisions = new HashMap<CDOID, InternalCDORevision>();
                }
                InternalCDORevision oldRevision2 = (InternalCDORevision)pair.getElement1();
                oldRevisions.put(id, oldRevision2);
                continue;
            }
            if (!ObjectUtil.equals((Object)key.getBranch(), (Object)newBranch)) continue;
            revisionManager.reviseVersion(id, (CDOBranchVersion)key, timeStamp);
        }
        for (CDOIDAndVersion key : commitInfo.getDetachedObjects()) {
            id = key.getID();
            int version = key.getVersion();
            if (version == 0) {
                revisionManager.reviseLatest(id, newBranch);
                continue;
            }
            CDOBranchVersion branchVersion = newBranch.getVersion(version);
            revisionManager.reviseVersion(id, branchVersion, timeStamp);
        }
        return oldRevisions;
    }

    private Pair<InternalCDORevision, InternalCDORevision> createNewRevision(CDORevisionKey potentialDelta, CDOCommitInfo commitInfo) {
        if (potentialDelta instanceof CDORevisionDelta) {
            CDORevisionDelta delta = (CDORevisionDelta)potentialDelta;
            CDOID id = delta.getID();
            InternalCDORevisionManager revisionManager = this.getRevisionManager();
            InternalCDORevision oldRevision = revisionManager.getRevisionByVersion(id, (CDOBranchVersion)potentialDelta, -1, false);
            if (oldRevision != null) {
                InternalCDORevision newRevision = oldRevision.copy();
                newRevision.adjustForCommit(commitInfo.getBranch(), commitInfo.getTimeStamp());
                delta.apply((CDORevision)newRevision);
                return new Pair((Object)oldRevision, (Object)newRevision);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(CDOCommitInfo commitInfo, InternalCDOTransaction sender) {
        OutOfSequenceInvalidations outOfSequenceInvalidations = this.outOfSequenceInvalidations;
        synchronized (outOfSequenceInvalidations) {
            long previousTimeStamp = commitInfo.getPreviousTimeStamp();
            long lastUpdateTime = this.getLastUpdateTime();
            if (previousTimeStamp < lastUpdateTime) {
                previousTimeStamp = lastUpdateTime;
            }
            this.outOfSequenceInvalidations.put(previousTimeStamp, new Pair((Object)commitInfo, (Object)sender));
            long nextPreviousTimeStamp = lastUpdateTime;
            while (!this.outOfSequenceInvalidations.isEmpty()) {
                Pair currentPair = (Pair)this.outOfSequenceInvalidations.remove(nextPreviousTimeStamp);
                if (currentPair == null) break;
                CDOCommitInfo currentCommitInfo = (CDOCommitInfo)currentPair.getElement1();
                InternalCDOTransaction currentSender = (InternalCDOTransaction)currentPair.getElement2();
                nextPreviousTimeStamp = currentCommitInfo.getTimeStamp();
                this.invalidateOrdered(currentCommitInfo, currentSender);
            }
        }
    }

    private void invalidateOrdered(CDOCommitInfo commitInfo, InternalCDOTransaction sender) {
        boolean success;
        Map<CDOID, InternalCDORevision> oldRevisions = null;
        boolean bl = success = commitInfo.getBranch() != null;
        if (success) {
            oldRevisions = this.reviseRevisions(commitInfo);
        }
        if (this.options.isPassiveUpdateEnabled()) {
            this.setLastUpdateTime(commitInfo.getTimeStamp());
        }
        if (success) {
            this.fireInvalidationEvent(sender, commitInfo);
        }
        InternalCDOView[] internalCDOViewArray = this.getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            if (view != sender) {
                this.invalidateView(commitInfo, view, oldRevisions);
            } else {
                view.setLastUpdateTime(commitInfo.getTimeStamp());
            }
            ++n2;
        }
    }

    private void invalidateView(CDOCommitInfo commitInfo, InternalCDOView view, Map<CDOID, InternalCDORevision> oldRevisions) {
        try {
            CDOBranch branch = commitInfo.getBranch();
            long lastUpdateTime = commitInfo.getTimeStamp();
            List allChangedObjects = commitInfo.getChangedObjects();
            List allDetachedObjects = commitInfo.getDetachedObjects();
            view.invalidate(branch, lastUpdateTime, allChangedObjects, allDetachedObjects, oldRevisions, true);
        }
        catch (RuntimeException ex) {
            if (view.isActive()) {
                OM.LOG.error((Throwable)ex);
            }
            OM.LOG.info(Messages.getString("CDOSessionImpl.1"));
        }
    }

    public void fireInvalidationEvent(InternalCDOTransaction sender, CDOCommitInfo commitInfo) {
        this.fireEvent(new InvalidationEvent(sender, commitInfo));
    }

    public String toString() {
        String name = this.repositoryInfo == null ? "?" : this.repositoryInfo.getName();
        return MessageFormat.format("Session{0} [{1}]", this.sessionID, name);
    }

    @Override
    public CDOBranchPoint getCommittedSinceLastRefresh(CDOID id) {
        if (this.isSticky()) {
            return this.committedSinceLastRefresh.get(id);
        }
        return null;
    }

    @Override
    public void setCommittedSinceLastRefresh(CDOID id, CDOBranchPoint branchPoint) {
        if (this.isSticky()) {
            this.committedSinceLastRefresh.put(id, branchPoint);
        }
    }

    @Override
    public void clearCommittedSinceLastRefresh() {
        if (this.isSticky()) {
            this.committedSinceLastRefresh.clear();
        }
    }

    @Override
    public boolean isSticky() {
        return !this.options().isPassiveUpdateEnabled() && this.getRepositoryInfo().isSupportingAudits();
    }

    @Override
    public CDOChangeSetData compareRevisions(CDOBranchPoint source, CDOBranchPoint target) {
        long now = this.getLastUpdateTime();
        if (target.getTimeStamp() == 0L) {
            target = target.getBranch().getPoint(now);
        }
        if (source.getTimeStamp() == 0L) {
            source = source.getBranch().getPoint(now);
        }
        CDORevisionAvailabilityInfo targetInfo = this.createRevisionAvailabilityInfo(target);
        CDORevisionAvailabilityInfo sourceInfo = this.createRevisionAvailabilityInfo(source);
        Set<CDOID> ids = this.sessionProtocol.loadMergeData(targetInfo, sourceInfo, null, null);
        this.cacheRevisions(targetInfo);
        this.cacheRevisions(sourceInfo);
        return CDORevisionUtil.createChangeSetData(ids, (CDORevisionProvider)sourceInfo, (CDORevisionProvider)targetInfo);
    }

    @Override
    public CDORevisionAvailabilityInfo createRevisionAvailabilityInfo(CDOBranchPoint branchPoint) {
        CDORevisionAvailabilityInfo info = new CDORevisionAvailabilityInfo(branchPoint);
        InternalCDORevisionManager revisionManager = this.getRevisionManager();
        InternalCDORevisionCache cache = revisionManager.getCache();
        List revisions = cache.getRevisions(branchPoint);
        for (CDORevision revision : revisions) {
            if (revision instanceof PointerCDORevision) {
                PointerCDORevision pointer = (PointerCDORevision)revision;
                CDOBranchVersion target = pointer.getTarget();
                if (target != null) {
                    revision = cache.getRevisionByVersion(pointer.getID(), target);
                }
            } else if (revision instanceof DetachedCDORevision) {
                revision = null;
            }
            if (revision == null) continue;
            this.resolveAllElementProxies(revision);
            info.addRevision((CDORevisionKey)revision);
        }
        return info;
    }

    @Override
    public void cacheRevisions(CDORevisionAvailabilityInfo info) {
        InternalCDORevisionManager revisionManager = this.getRevisionManager();
        CDOBranch branch = info.getBranchPoint().getBranch();
        for (CDORevisionKey key : info.getAvailableRevisions().values()) {
            CDORevision revision = (CDORevision)key;
            revisionManager.addRevision(revision);
            if (ObjectUtil.equals((Object)revision.getBranch(), (Object)branch)) continue;
            CDOID id = revision.getID();
            CDORevision firstRevision = revisionManager.getCache().getRevisionByVersion(id, branch.getVersion(1));
            if (firstRevision == null) continue;
            long revised = firstRevision.getTimeStamp() - 1L;
            CDOBranchVersion target = CDOBranchUtil.copyBranchVersion((CDOBranchVersion)revision);
            PointerCDORevision pointer = new PointerCDORevision(revision.getEClass(), id, branch, revised, target);
            revisionManager.addRevision((CDORevision)pointer);
        }
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initView(InternalCDOView view, ResourceSet resourceSet) {
        InternalCDOViewSet viewSet = SessionUtil.prepareResourceSet(resourceSet);
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            view.setSession(this);
            view.setViewID(++this.lastViewID);
            this.views.add(view);
        }
        view.setViewSet(viewSet);
        viewSet.add(view);
        try {
            view.activate();
            this.fireElementAddedEvent(view);
        }
        catch (RuntimeException ex) {
            Set<InternalCDOView> set2 = this.views;
            synchronized (set2) {
                this.views.remove(view);
            }
            viewSet.remove(view);
            throw ex;
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        CDORemoteSessionManagerImpl remoteSessionManager = new CDORemoteSessionManagerImpl();
        remoteSessionManager.setLocalSession(this);
        this.setRemoteSessionManager(remoteSessionManager);
        remoteSessionManager.activate();
        this.checkState(this.sessionProtocol, "sessionProtocol");
        this.checkState(remoteSessionManager, "remoteSessionManager");
    }

    protected void doDeactivate() throws Exception {
        InternalCDOView[] internalCDOViewArray = this.views.toArray(new InternalCDOView[this.views.size()]);
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            try {
                view.close();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            ++n2;
        }
        this.views.clear();
        this.outOfSequenceInvalidations.clear();
        this.unhookSessionProtocol();
        InternalCDORemoteSessionManager remoteSessionManager = this.getRemoteSessionManager();
        this.setRemoteSessionManager(null);
        LifecycleUtil.deactivate((Object)remoteSessionManager);
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        LifecycleUtil.deactivate((Object)sessionProtocol);
        this.setSessionProtocol(null);
        super.doDeactivate();
    }

    protected CDOSessionProtocol hookSessionProtocol() {
        EventUtil.addListener((Object)this.sessionProtocol, (IListener)this.sessionProtocolListener);
        return this.sessionProtocol;
    }

    protected void unhookSessionProtocol() {
        EventUtil.removeListener((Object)this.sessionProtocol, (IListener)this.sessionProtocolListener);
    }

    protected void sessionProtocolDeactivated() {
        this.deactivate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InvalidationEvent
    extends Event
    implements CDOSessionInvalidationEvent {
        private static final long serialVersionUID = 1L;
        private InternalCDOTransaction sender;
        private CDOCommitInfo commitInfo;

        public InvalidationEvent(InternalCDOTransaction sender, CDOCommitInfo commitInfo) {
            super((INotifier)CDOSessionImpl.this);
            this.sender = sender;
            this.commitInfo = commitInfo;
        }

        @Override
        public CDOSession getSource() {
            return (CDOSession)super.getSource();
        }

        public CDOCommitInfoManager getCommitInfoManager() {
            return this.commitInfo.getCommitInfoManager();
        }

        @Override
        public CDOTransaction getLocalTransaction() {
            return this.sender;
        }

        @Override
        @Deprecated
        public InternalCDOView getView() {
            return this.sender;
        }

        @Override
        public boolean isRemote() {
            return this.sender == null;
        }

        public CDOBranch getBranch() {
            return this.commitInfo.getBranch();
        }

        public long getTimeStamp() {
            return this.commitInfo.getTimeStamp();
        }

        public long getPreviousTimeStamp() {
            return this.commitInfo.getPreviousTimeStamp();
        }

        public String getUserID() {
            return this.commitInfo.getUserID();
        }

        public String getComment() {
            return this.commitInfo.getComment();
        }

        public boolean isEmpty() {
            return false;
        }

        public CDOChangeSetData copy() {
            return this.commitInfo.copy();
        }

        public void merge(CDOChangeSetData changeSetData) {
            this.commitInfo.merge(changeSetData);
        }

        public List<CDOPackageUnit> getNewPackageUnits() {
            return this.commitInfo.getNewPackageUnits();
        }

        public List<CDOIDAndVersion> getNewObjects() {
            return this.commitInfo.getNewObjects();
        }

        public List<CDORevisionKey> getChangedObjects() {
            return this.commitInfo.getChangedObjects();
        }

        public List<CDOIDAndVersion> getDetachedObjects() {
            return this.commitInfo.getDetachedObjects();
        }

        public CDOChangeKind getChangeKind(CDOID id) {
            return this.commitInfo.getChangeKind(id);
        }

        public String toString() {
            return "CDOSessionInvalidationEvent[" + this.commitInfo + "]";
        }
    }

    private static final class LastUpdateTimeLock {
        private LastUpdateTimeLock() {
        }
    }

    protected class OptionsImpl
    extends Notifier
    implements CDOSession.Options {
        private boolean generatedPackageEmulationEnabled;
        private boolean passiveUpdateEnabled = true;
        private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode = CDOCommonSession.Options.PassiveUpdateMode.INVALIDATIONS;
        private CDOCollectionLoadingPolicy collectionLoadingPolicy;
        private CDOLobStore lobCache = CDOLobStoreImpl.INSTANCE;

        public OptionsImpl() {
            this.setCollectionLoadingPolicy(null);
        }

        public CDOSession getContainer() {
            return CDOSessionImpl.this;
        }

        public boolean isGeneratedPackageEmulationEnabled() {
            return this.generatedPackageEmulationEnabled;
        }

        public synchronized void setGeneratedPackageEmulationEnabled(boolean generatedPackageEmulationEnabled) {
            this.generatedPackageEmulationEnabled = generatedPackageEmulationEnabled;
            if (this.generatedPackageEmulationEnabled != generatedPackageEmulationEnabled) {
                this.generatedPackageEmulationEnabled = generatedPackageEmulationEnabled;
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new GeneratedPackageEmulationEventImpl(), listeners);
                }
            }
        }

        public boolean isPassiveUpdateEnabled() {
            return this.passiveUpdateEnabled;
        }

        public synchronized void setPassiveUpdateEnabled(boolean passiveUpdateEnabled) {
            if (this.passiveUpdateEnabled != passiveUpdateEnabled) {
                this.passiveUpdateEnabled = passiveUpdateEnabled;
                CDOSessionProtocol protocol = CDOSessionImpl.this.getSessionProtocol();
                if (protocol != null) {
                    if (passiveUpdateEnabled) {
                        CDOSessionImpl.this.refresh(true);
                    } else {
                        protocol.disablePassiveUpdate();
                    }
                    IListener[] listeners = this.getListeners();
                    if (listeners != null) {
                        this.fireEvent((IEvent)new PassiveUpdateEventImpl(!passiveUpdateEnabled, passiveUpdateEnabled, this.passiveUpdateMode, this.passiveUpdateMode), listeners);
                    }
                }
            }
        }

        public CDOCommonSession.Options.PassiveUpdateMode getPassiveUpdateMode() {
            return this.passiveUpdateMode;
        }

        public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode) {
            CDOSessionImpl.this.checkArg(passiveUpdateMode, "passiveUpdateMode");
            if (this.passiveUpdateMode != passiveUpdateMode) {
                CDOCommonSession.Options.PassiveUpdateMode oldMode = this.passiveUpdateMode;
                this.passiveUpdateMode = passiveUpdateMode;
                CDOSessionProtocol protocol = CDOSessionImpl.this.getSessionProtocol();
                if (protocol != null) {
                    protocol.setPassiveUpdateMode(passiveUpdateMode);
                    IListener[] listeners = this.getListeners();
                    if (listeners != null) {
                        this.fireEvent((IEvent)new PassiveUpdateEventImpl(this.passiveUpdateEnabled, this.passiveUpdateEnabled, oldMode, passiveUpdateMode), listeners);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOCollectionLoadingPolicy getCollectionLoadingPolicy() {
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                return this.collectionLoadingPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCollectionLoadingPolicy(CDOCollectionLoadingPolicy policy) {
            CDOSession oldSession;
            if (policy == null) {
                policy = CDOUtil.createCollectionLoadingPolicy(-1, -1);
            }
            if ((oldSession = policy.getSession()) != null) {
                throw new IllegalArgumentException("Policy is already associated with " + oldSession);
            }
            policy.setSession(CDOSessionImpl.this);
            IListener[] listeners = this.getListeners();
            CollectionLoadingPolicyEventImpl event = null;
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                if (this.collectionLoadingPolicy != policy) {
                    this.collectionLoadingPolicy = policy;
                    if (listeners != null) {
                        event = new CollectionLoadingPolicyEventImpl();
                    }
                }
            }
            if (event != null) {
                this.fireEvent((IEvent)event, listeners);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOLobStore getLobCache() {
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                return this.lobCache;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLobCache(CDOLobStore cache) {
            if (cache == null) {
                cache = CDOLobStoreImpl.INSTANCE;
            }
            IListener[] listeners = this.getListeners();
            LobCacheEventImpl event = null;
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                if (this.lobCache != cache) {
                    this.lobCache = cache;
                    if (listeners != null) {
                        event = new LobCacheEventImpl();
                    }
                }
            }
            if (event != null) {
                this.fireEvent((IEvent)event, listeners);
            }
        }

        private final class CollectionLoadingPolicyEventImpl
        extends OptionsEvent
        implements CDOSession.Options.CollectionLoadingPolicyEvent {
            private static final long serialVersionUID = 1L;

            public CollectionLoadingPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class GeneratedPackageEmulationEventImpl
        extends OptionsEvent
        implements CDOSession.Options.GeneratedPackageEmulationEvent {
            private static final long serialVersionUID = 1L;

            public GeneratedPackageEmulationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class LobCacheEventImpl
        extends OptionsEvent
        implements CDOSession.Options.LobCacheEvent {
            private static final long serialVersionUID = 1L;

            public LobCacheEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class PassiveUpdateEventImpl
        extends OptionsEvent
        implements CDOCommonSession.Options.PassiveUpdateEvent {
            private static final long serialVersionUID = 1L;
            private boolean oldEnabled;
            private boolean newEnabled;
            private CDOCommonSession.Options.PassiveUpdateMode oldMode;
            private CDOCommonSession.Options.PassiveUpdateMode newMode;

            public PassiveUpdateEventImpl(boolean oldEnabled, boolean newEnabled, CDOCommonSession.Options.PassiveUpdateMode oldMode, CDOCommonSession.Options.PassiveUpdateMode newMode) {
                super((IOptions)OptionsImpl.this);
                this.oldEnabled = oldEnabled;
                this.newEnabled = newEnabled;
                this.oldMode = oldMode;
                this.newMode = newMode;
            }

            public boolean getOldEnabled() {
                return this.oldEnabled;
            }

            public boolean getNewEnabled() {
                return this.newEnabled;
            }

            public CDOCommonSession.Options.PassiveUpdateMode getOldMode() {
                return this.oldMode;
            }

            public CDOCommonSession.Options.PassiveUpdateMode getNewMode() {
                return this.newMode;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OutOfSequenceInvalidations
    extends HashMap<Long, Pair<CDOCommitInfo, InternalCDOTransaction>> {
        private static final long serialVersionUID = 1L;

        private OutOfSequenceInvalidations() {
        }
    }
}

