/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.Factory;

public abstract class CDOSessionFactory
extends Factory {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.sessions";
    private static final String TRUE = Boolean.TRUE.toString();

    public CDOSessionFactory(String type) {
        super(PRODUCT_GROUP, type);
    }

    public CDOSession create(String description) {
        try {
            URI uri = new URI(description);
            String query = uri.getQuery();
            if (StringUtil.isEmpty((String)query)) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOSessionFactory.1"), description));
            }
            Map<String, String> result = CDOURIUtil.getParameters(query);
            String repositoryName = result.get("repositoryName");
            if (repositoryName == null) {
                throw new IllegalArgumentException("Repository name is missing: " + description);
            }
            boolean automaticPackageRegistry = TRUE.equals(result.get("automaticPackageRegistry"));
            return this.createSession(repositoryName, automaticPackageRegistry);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected abstract InternalCDOSession createSession(String var1, boolean var2);
}

