/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.query;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.BlockingCloseableIterator;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.internal.common.CDOQueryInfoImpl;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.query.CDOQueryCDOIDIteratorImpl;
import org.eclipse.emf.internal.cdo.query.CDOQueryResultIteratorImpl;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOQueryImpl
extends CDOQueryInfoImpl
implements CDOQuery {
    private static final String OBJECT_NOT_PERSISTED_MESSAGE = Messages.getString("CDOQueryImpl.0");
    private InternalCDOView view;

    public CDOQueryImpl(InternalCDOView view, String queryLanguage, String queryString, Object context) {
        super(queryLanguage, queryString, context);
        this.view = view;
        this.setLegacyModeEnabled(view.isLegacyModeEnabled());
    }

    @Override
    public InternalCDOView getView() {
        return this.view;
    }

    @Override
    public CDOQueryImpl setContext(Object context) {
        this.context = context;
        return this;
    }

    @Override
    public CDOQueryImpl setParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    @Override
    public CDOQueryImpl setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    protected <T> AbstractQueryIterator<T> createQueryResult(Class<T> classObject) {
        CDOQueryInfoImpl queryInfo = this.createQueryInfo();
        if (CDOID.class.equals(classObject)) {
            return new CDOQueryCDOIDIteratorImpl(this.view, (CDOQueryInfo)queryInfo);
        }
        return new CDOQueryResultIteratorImpl(this.view, (CDOQueryInfo)queryInfo);
    }

    @Override
    public <T> List<T> getResult(Class<T> classObject) {
        AbstractQueryIterator<T> queryResult = this.createQueryResult(classObject);
        this.view.getSession().getSessionProtocol().query(this.view, queryResult);
        return queryResult.asList();
    }

    @Override
    public <T> List<T> getResult() {
        return this.getResult(null);
    }

    public <T> BlockingCloseableIterator<T> getResultAsync(Class<T> classObject) {
        final AbstractQueryIterator<T> queryResult = this.createQueryResult(classObject);
        final Exception[] exception = new Exception[1];
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    CDOQueryImpl.this.view.getSession().getSessionProtocol().query(CDOQueryImpl.this.view, queryResult);
                }
                catch (Exception ex) {
                    queryResult.close();
                    exception[0] = ex;
                }
            }
        };
        new Thread(runnable).start();
        try {
            queryResult.waitForInitialization();
        }
        catch (Exception ex) {
            exception[0] = ex;
        }
        if (exception[0] != null) {
            throw WrappedException.wrap((Exception)exception[0]);
        }
        return queryResult;
    }

    public <T> BlockingCloseableIterator<T> getResultAsync() {
        return this.getResultAsync(null);
    }

    protected CDOQueryInfoImpl createQueryInfo() {
        CDOQueryInfoImpl queryInfo = new CDOQueryInfoImpl(this.getQueryLanguage(), this.getQueryString(), this.getContext());
        queryInfo.setMaxResults(this.getMaxResults());
        queryInfo.setLegacyModeEnabled(this.isLegacyModeEnabled());
        queryInfo.setChangeSetData(this.getChangeSetData());
        for (Map.Entry entry : this.getParameters().entrySet()) {
            Object value = entry.getValue();
            value = this.adapt(value);
            queryInfo.addParameter((String)entry.getKey(), value);
        }
        return queryInfo;
    }

    protected Object adapt(Object object) {
        if (object instanceof InternalCDOObject) {
            InternalCDOObject internalCDOObject = FSMUtil.adapt(object, this.view);
            CDOID id = internalCDOObject.cdoID();
            if (id == null) {
                throw new UnsupportedOperationException(OBJECT_NOT_PERSISTED_MESSAGE);
            }
            if (id.isTemporary()) {
                throw new UnsupportedOperationException(OBJECT_NOT_PERSISTED_MESSAGE);
            }
            return id;
        }
        return object;
    }
}

