/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import org.eclipse.emf.cdo.CDOLock;
import org.eclipse.emf.cdo.util.LockTimeoutException;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public class CDOLockImpl
implements CDOLock {
    public static final CDOLock NOOP = new NOOPLockImpl();
    private InternalCDOObject object;
    private IRWLockManager.LockType type;

    public CDOLockImpl(InternalCDOObject object, IRWLockManager.LockType type) {
        this.object = object;
        this.type = type;
    }

    public IRWLockManager.LockType getType() {
        return this.type;
    }

    public boolean isLocked() {
        return this.object.cdoView().isObjectLocked(this.object, this.type, false);
    }

    public boolean isLockedByOthers() {
        return this.object.cdoView().isObjectLocked(this.object, this.type, true);
    }

    public void lock() {
        try {
            this.object.cdoView().lockObjects(Collections.singletonList(this.object), this.type, 0L);
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public void lock(long time, TimeUnit unit) throws TimeoutException {
        try {
            if (!this.tryLock(time, unit)) {
                throw new TimeoutException();
            }
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public void lock(long millis) throws TimeoutException {
        this.lock(millis, TimeUnit.MILLISECONDS);
    }

    public boolean tryLock(long millis) throws InterruptedException {
        return this.tryLock(millis, TimeUnit.MILLISECONDS);
    }

    public void lockInterruptibly() throws InterruptedException {
        this.lock();
    }

    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public boolean tryLock() {
        try {
            this.object.cdoView().lockObjects(Collections.singletonList(this.object), this.type, 1L);
            return true;
        }
        catch (LockTimeoutException ex) {
            return false;
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        try {
            this.object.cdoView().lockObjects(Collections.singletonList(this.object), this.type, unit.toMillis(time));
            return true;
        }
        catch (LockTimeoutException ex) {
            return false;
        }
    }

    public void unlock() {
        this.object.cdoView().unlockObjects(Collections.singletonList(this.object), this.type);
    }

    public String toString() {
        return MessageFormat.format("CDOLock[object={0}, type={1}]", this.object, this.type);
    }

    public static final class NOOPLockImpl
    implements CDOLock {
        private NOOPLockImpl() {
        }

        public boolean isLocked() {
            return false;
        }

        public boolean isLockedByOthers() {
            return false;
        }

        public void lock() {
            throw new UnsupportedOperationException();
        }

        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        public Condition newCondition() {
            return null;
        }

        public void lock(long time, TimeUnit unit) throws TimeoutException {
            throw new UnsupportedOperationException();
        }

        public void lock(long millis) throws TimeoutException {
            throw new UnsupportedOperationException();
        }

        public boolean tryLock(long millis) throws InterruptedException {
            return false;
        }

        public boolean tryLock() {
            return false;
        }

        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return false;
        }

        public void unlock() {
            throw new UnsupportedOperationException();
        }

        public IRWLockManager.LockType getType() {
            return null;
        }
    }
}

