/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.pannotation.Column;
import org.eclipse.emf.teneo.annotations.pannotation.GeneratedValue;
import org.eclipse.emf.teneo.annotations.pannotation.GenerationType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.ManyToOne;
import org.eclipse.emf.teneo.annotations.pannotation.SequenceGenerator;
import org.eclipse.emf.teneo.annotations.pannotation.TableGenerator;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.hbannotation.GenericGenerator;
import org.eclipse.emf.teneo.hibernate.hbannotation.Parameter;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEPackage;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractAssociationMapper;
import org.eclipse.emf.teneo.hibernate.mapper.MappingContext;
import org.eclipse.emf.teneo.hibernate.mapper.MappingException;
import org.eclipse.emf.teneo.simpledom.DocumentHelper;
import org.eclipse.emf.teneo.simpledom.Element;

public class IdMapper
extends AbstractAssociationMapper
implements ExtensionPoint {
    private static final Log log = LogFactory.getLog(IdMapper.class);
    private static final String[] GENERATOR_CLASS_NAMES = new String[GenerationType.VALUES.size()];

    static {
        IdMapper.GENERATOR_CLASS_NAMES[GenerationType.AUTO.getValue()] = "native";
        IdMapper.GENERATOR_CLASS_NAMES[GenerationType.IDENTITY.getValue()] = "identity";
        IdMapper.GENERATOR_CLASS_NAMES[GenerationType.SEQUENCE.getValue()] = "sequence";
        IdMapper.GENERATOR_CLASS_NAMES[GenerationType.TABLE.getValue()] = "hilo";
        IdMapper.GENERATOR_CLASS_NAMES[GenerationType.SEQUENCESTYLE.getValue()] = "org.hibernate.id.enhanced.SequenceStyleGenerator";
        IdMapper.GENERATOR_CLASS_NAMES[GenerationType.ASSIGNED.getValue()] = "assigned";
    }

    public static Element getCreateIdElement(Element entityElement, PAnnotatedEClass aClass) {
        if (aClass.getIdClass() != null) {
            Element element = entityElement.element("composite-id");
            if (element == null) {
                element = DocumentHelper.createElement((String)"composite-id").addAttribute("class", aClass.getIdClass().getValue()).addAttribute("mapped", "true");
                entityElement.add(0, element);
            }
            return element;
        }
        Element element = entityElement.element("id");
        if (element == null) {
            element = DocumentHelper.createElement((String)"id");
            entityElement.add(0, element);
        }
        return element;
    }

    public static Element addSyntheticId(MappingContext mc, Element entityElement) {
        if (entityElement.element("id") != null || entityElement.element("composite-id") != null) {
            throw new MappingException("Syntheticid should only be called if there is no id element");
        }
        Element idElement = DocumentHelper.createElement((String)"id");
        entityElement.add(0, idElement);
        idElement.addAttribute("type", "long").addAttribute("name", mc.getIdColumnName()).addAttribute("column", mc.getIdColumnName()).addElement("generator").addAttribute("class", "native");
        Element meta = new Element("meta");
        meta.addAttribute("attribute", "syntheticId").addText("true");
        meta.addAttribute("inherit", "false");
        idElement.add(0, meta);
        if (mc.getSyntheticIdPropertyHandlerName() != null) {
            idElement.addAttribute("access", mc.getSyntheticIdPropertyHandlerName());
        }
        return idElement;
    }

    private static String hbGeneratorClass(GenerationType strategy) {
        return GENERATOR_CLASS_NAMES[strategy != null ? strategy.getValue() : GenerationType.AUTO.getValue()];
    }

    public void processEmbeddedId(PAnnotatedEReference aReference) {
        EReference eReference = aReference.getModelEReference();
        PAnnotatedEClass aClass = aReference.getPaModel().getPAnnotated(eReference.getEReferenceType());
        Element compositeIdElement = DocumentHelper.createElement((String)"composite-id");
        this.getHbmContext().getCurrent().add(0, compositeIdElement);
        compositeIdElement.addAttribute("name", eReference.getName());
        String className = this.getHbmContext().getInstanceClassName(aClass.getModelEClass());
        if (className.equals(DynamicEObjectImpl.class.getName())) {
            className = "org.eclipse.emf.teneo.hibernate.mapping.SerializableDynamicEObjectImpl";
        }
        compositeIdElement.addAttribute("class", className);
        this.getHbmContext().setCurrent(compositeIdElement);
        Element meta1 = new Element("meta");
        meta1.addAttribute("attribute", "eclassName").addText(eReference.getEReferenceType().getName());
        meta1.addAttribute("inherit", "false");
        Element meta2 = new Element("meta");
        meta2.addAttribute("attribute", "epackage").addText(eReference.getEReferenceType().getEPackage().getNsURI());
        meta2.addAttribute("inherit", "false");
        compositeIdElement.addElement(meta1);
        compositeIdElement.addElement(meta2);
        compositeIdElement.addAttribute("access", "org.eclipse.emf.teneo.hibernate.mapping.property.EReferencePropertyHandler");
        for (PAnnotatedEStructuralFeature aFeature : aClass.getPaEStructuralFeatures()) {
            if (aFeature instanceof PAnnotatedEAttribute) {
                PAnnotatedEAttribute aAttribute = (PAnnotatedEAttribute)aFeature;
                Element keyPropertyElement = compositeIdElement.addElement("key-property");
                keyPropertyElement.addAttribute("name", aFeature.getModelEStructuralFeature().getName());
                this.addColumnsAndFormula(keyPropertyElement, (PAnnotatedEStructuralFeature)aAttribute, this.getColumns((PAnnotatedEStructuralFeature)aAttribute), this.getHbmContext().isCurrentElementFeatureMap(), false);
                this.setType(aAttribute, keyPropertyElement);
                continue;
            }
            if (!(aFeature instanceof PAnnotatedEReference) || ((PAnnotatedEReference)aFeature).getModelEReference().isMany()) continue;
            this.addKeyManyToOne(compositeIdElement, (PAnnotatedEReference)aFeature);
        }
        this.getHbmContext().setCurrent(compositeIdElement.getParent());
        this.addAccessor(compositeIdElement, this.hbmContext.getComponentPropertyHandlerName());
    }

    private void addKeyManyToOne(Element currentParent, PAnnotatedEReference paReference) {
        log.debug((Object)("Process many-to-one " + paReference));
        List<JoinColumn> jcs = this.getJoinColumns(paReference);
        EClass referedTo = paReference.getModelEReference().getEReferenceType();
        ManyToOne mto = paReference.getManyToOne();
        String targetName = mto.getTargetEntity();
        if (targetName == null) {
            targetName = this.getHbmContext().getEntityName(referedTo);
        }
        log.debug((Object)("Target " + targetName));
        Element associationElement = this.addManyToOne(currentParent, paReference, targetName, true);
        this.addForeignKeyAttribute(associationElement, (PAnnotatedEStructuralFeature)paReference);
        this.addLazyProxy(associationElement, mto.getFetch(), paReference);
        this.addJoinColumns(paReference, associationElement, jcs, this.getHbmContext().isDoForceOptional((PAnnotatedEStructuralFeature)paReference) || mto.isOptional() || this.getHbmContext().isCurrentElementFeatureMap());
    }

    public void processIdProperty(PAnnotatedEAttribute id) {
        PAnnotatedEClass aClass = id.getPaEClass();
        if (aClass.getPaSuperEntity() != null && aClass.getPaSuperEntity().hasIdAnnotatedFeature()) {
            log.error((Object)("The annotated eclass: " + aClass + " has an id-annotated feature: " + id + " while it has a " + "superclass/type, id properties should always be specified in the top of the inheritance structure"));
            throw new MappingException("The annotated eclass: " + aClass + " has an id-annotated feature: " + id + " while it has a " + "superclass/type, id properties should always be specified in the top of the inheritance structure");
        }
        EAttribute eAttribute = id.getModelEAttribute();
        List<Column> columns = this.getColumns((PAnnotatedEStructuralFeature)id);
        GeneratedValue generatedValue = id.getGeneratedValue();
        Element idElement = IdMapper.getCreateIdElement(this.getHbmContext().getCurrent(), aClass);
        boolean isCompositeId = aClass.getIdClass() != null;
        Element usedIdElement = isCompositeId ? idElement.addElement("key-property") : idElement;
        this.addColumnsAndFormula(usedIdElement, (PAnnotatedEStructuralFeature)id, columns, false, false, aClass.getIdClass() == null, true);
        usedIdElement.addAttribute("name", eAttribute.getName());
        if (id.getEnumerated() == null) {
            this.setType(id, usedIdElement);
            if (eAttribute.getDefaultValue() != null) {
                usedIdElement.addAttribute("unsaved-value", eAttribute.getDefaultValue().toString());
            } else if (eAttribute.getEType().getDefaultValue() != null) {
                usedIdElement.addAttribute("unsaved-value", eAttribute.getEType().getDefaultValue().toString());
            }
        } else {
            EClassifier eclassifier = id.getModelEAttribute().getEType();
            if (!this.getHbmContext().isGeneratedByEMF() && !this.getHbmContext().isDynamic(eclassifier)) {
                String typeName = this.getEnumUserType(id.getEnumerated());
                Class<?> instanceClass = this.getHbmContext().getInstanceClass(eclassifier);
                usedIdElement.addElement("type").addAttribute("name", typeName).addElement("param").addAttribute("name", "enumClassName").addText(instanceClass.getName());
            } else {
                if (!this.getHbmContext().isGeneratedByEMF() && this.getHbmContext().isDynamic(eclassifier)) {
                    throw new UnsupportedOperationException("DYNAMIC WITH ENUM ID NOT YET SUPPORTED");
                }
                if (id.getModelEAttribute().getEType().getInstanceClass() != null) {
                    usedIdElement.addElement("type").addAttribute("name", this.getEnumUserType(id.getEnumerated())).addElement("param").addAttribute("name", "enumClass").addText(eAttribute.getEType().getInstanceClass().getName());
                } else {
                    Element typeElement = usedIdElement.addElement("type").addAttribute("name", this.hbDynamicEnumType(id.getEnumerated()));
                    typeElement.addElement("param").addAttribute("name", "eclassifier").addText(id.getModelEAttribute().getEType().getName());
                    typeElement.addElement("param").addAttribute("name", "epackage").addText(id.getModelEAttribute().getEType().getEPackage().getNsURI());
                }
            }
        }
        if (generatedValue != null) {
            SequenceGenerator sg;
            GenericGenerator gg;
            if (isCompositeId) {
                throw new MappingException("Composite id can not have a generated value " + id.getModelEAttribute().getEContainingClass().getName() + "/" + id.getModelEAttribute().getName());
            }
            Element generatorElement = usedIdElement.addElement("generator");
            if (generatedValue.getGenerator() != null && (gg = this.getGenericGenerator(id.getPaModel(), generatedValue.getGenerator())) != null) {
                log.debug((Object)"GenericGenerator the strategy in the GeneratedValue is ignored (if even set)");
                generatorElement.addAttribute("class", gg.getStrategy());
                if (gg.getParameters() != null) {
                    for (Parameter param : gg.getParameters()) {
                        generatorElement.addElement("param").addAttribute("name", param.getName()).addText(param.getValue());
                    }
                }
            } else if (GenerationType.IDENTITY.equals((Object)generatedValue.getStrategy())) {
                generatorElement.addAttribute("class", "identity");
            } else if (GenerationType.TABLE.equals((Object)generatedValue.getStrategy())) {
                generatorElement.addAttribute("class", IdMapper.hbGeneratorClass(generatedValue.getStrategy()));
                if (generatedValue.getGenerator() != null) {
                    TableGenerator tg = id.getPaModel().getTableGenerator((EStructuralFeature)id.getModelEAttribute(), generatedValue.getGenerator());
                    generatorElement.addElement("param").addAttribute("name", "table").setText(tg.getTable() != null ? tg.getTable() : "uid_table");
                    generatorElement.addElement("param").addAttribute("name", "column").setText(tg.getValueColumnName() != null ? tg.getValueColumnName() : "next_hi_value_column");
                    generatorElement.addElement("param").addAttribute("name", "max_lo").setText(String.valueOf(tg.getAllocationSize() - 1));
                } else {
                    generatorElement.addElement("param").addAttribute("name", "table").setText("uid_table");
                    generatorElement.addElement("param").addAttribute("name", "column").setText("next_hi_value_column");
                }
            } else if (GenerationType.SEQUENCE.equals((Object)generatedValue.getStrategy())) {
                if (generatedValue.getGenerator() != null) {
                    sg = id.getPaModel().getSequenceGenerator((EStructuralFeature)id.getModelEAttribute(), generatedValue.getGenerator());
                    if (sg.isSetAllocationSize()) {
                        generatorElement.addAttribute("class", "seqhilo");
                        generatorElement.addElement("param").addAttribute("name", "sequence").setText(sg.getSequenceName());
                        generatorElement.addElement("param").addAttribute("name", "max_lo").setText(Integer.toString(sg.getAllocationSize() - 1));
                    } else {
                        generatorElement.addAttribute("class", IdMapper.hbGeneratorClass(generatedValue.getStrategy()));
                        generatorElement.addElement("param").addAttribute("name", "sequence").setText(sg.getSequenceName());
                    }
                } else {
                    generatorElement.addAttribute("class", IdMapper.hbGeneratorClass(generatedValue.getStrategy()));
                }
            } else if (GenerationType.SEQUENCESTYLE.equals((Object)generatedValue.getStrategy())) {
                generatorElement.addAttribute("class", IdMapper.hbGeneratorClass(generatedValue.getStrategy()));
                if (generatedValue.getGenerator() != null) {
                    sg = id.getPaModel().getSequenceStyleGenerator((EStructuralFeature)id.getModelEAttribute(), generatedValue.getGenerator());
                    generatorElement.addElement("param").addAttribute("name", "sequence_name").setText(sg.getSequenceName());
                    generatorElement.addElement("param").addAttribute("name", "optimizer").setText(sg.getOptimizer().getName().toLowerCase());
                    generatorElement.addElement("param").addAttribute("name", "initial_value").setText(Integer.toString(sg.getInitialValue()));
                    generatorElement.addElement("param").addAttribute("name", "increment_size").setText(Integer.toString(sg.getIncrementSize()));
                }
            } else {
                generatorElement.addAttribute("class", IdMapper.hbGeneratorClass(generatedValue.getStrategy()));
            }
        } else {
            this.checkAddForeignGenerator(idElement, aClass);
        }
    }

    protected boolean checkAddForeignGenerator(Element idElement, PAnnotatedEClass aClass) {
        for (PAnnotatedEStructuralFeature aFeature : aClass.getPaEStructuralFeatures()) {
            PAnnotatedEReference aReference;
            if (!(aFeature instanceof PAnnotatedEReference) || (aReference = (PAnnotatedEReference)aFeature).getOneToOne() == null || aReference.getPrimaryKeyJoinColumns().isEmpty()) continue;
            Element genElement = idElement.addElement("generator");
            genElement.addAttribute("class", "foreign");
            Element paramElement = genElement.addElement("param");
            paramElement.addAttribute("name", "property");
            paramElement.addText(aReference.getModelElement().getName());
            return true;
        }
        return false;
    }

    public GenericGenerator getGenericGenerator(PAnnotatedModel paModel, String name) {
        for (PAnnotatedEPackage annotatedEPackage : paModel.getPaEPackages()) {
            HbAnnotatedEPackage pae = (HbAnnotatedEPackage)annotatedEPackage;
            for (GenericGenerator gg : pae.getHbGenericGenerators()) {
                if (gg.getName() == null || gg.getName().compareTo(name) != 0) continue;
                if (gg.getStrategy() == null) {
                    throw new MappingException("The GenericGenerator: " + name + " has no strategy defined!");
                }
                return gg;
            }
        }
        log.debug((Object)("No GenericGenerator defined under name: " + name));
        return null;
    }
}

