/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.annotations;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.AbstractAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.OneToManyReferenceAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.StoreMappingException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.OneToMany;
import org.eclipse.emf.teneo.hibernate.annotations.HbAnnotationUtil;
import org.eclipse.emf.teneo.hibernate.hbannotation.Cache;
import org.eclipse.emf.teneo.hibernate.hbannotation.CacheConcurrencyStrategy;
import org.eclipse.emf.teneo.hibernate.hbannotation.Cascade;
import org.eclipse.emf.teneo.hibernate.hbannotation.HbCascadeType;
import org.eclipse.emf.teneo.hibernate.hbannotation.HbannotationFactory;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HbOneToManyReferenceAnnotator
extends OneToManyReferenceAnnotator {
    protected static final Log log = LogFactory.getLog(HbOneToManyReferenceAnnotator.class);
    private String defaultCacheStrategy = CacheConcurrencyStrategy.NONE.getName();

    public void annotate(PAnnotatedEReference aReference) {
        boolean hasCache;
        boolean doHbCascade;
        boolean isCollectionOfElements = aReference instanceof HbAnnotatedEReference && ((HbAnnotatedEReference)aReference).getHbCollectionOfElements() != null;
        HbAnnotatedEReference hbReference = (HbAnnotatedEReference)aReference;
        OneToMany otm = aReference.getOneToMany();
        boolean bl = doHbCascade = otm == null || otm.getCascade().isEmpty();
        if (this.getPersistenceOptions().alwaysMapListAsIdBag() && aReference.getModelEReference().isMany() && aReference.getOneToMany() == null && !aReference.getModelEReference().isContainment()) {
            hbReference.setHbIdBag(HbannotationFactory.eINSTANCE.createIdBag());
        }
        if (this.getPersistenceOptions().isAddIndexForForeignKey()) {
            HbAnnotationUtil.setIndex(aReference, (AbstractAnnotator)this);
        }
        if (!isCollectionOfElements) {
            super.annotate(aReference);
        }
        boolean bl2 = hasCache = hbReference.getHbCache() != null;
        if (!hasCache && this.defaultCacheStrategy.compareToIgnoreCase(CacheConcurrencyStrategy.NONE.getName()) != 0) {
            CacheConcurrencyStrategy ccs = CacheConcurrencyStrategy.getByName(this.defaultCacheStrategy);
            if (ccs == null) {
                throw new StoreMappingException("The default cache strategy: " + this.defaultCacheStrategy + " is not one of the allowed values (uppercase) " + "as defined in the JPA Hibernate Annotation Extensions.");
            }
            log.debug((Object)("Setting cache strategy " + this.defaultCacheStrategy + " on " + aReference.getModelEReference().getName()));
            Cache cache = HbannotationFactory.eINSTANCE.createCache();
            cache.setUsage(ccs);
            hbReference.setHbCache(cache);
        }
        if (doHbCascade && hbReference.getHbCascade() == null) {
            String option = "";
            if (aReference.getModelEReference().isContainment()) {
                option = this.getPersistenceOptions().isSetCascadeAllOnContainment() ? HbCascadeType.ALL.getName() : this.getPersistenceOptions().getCascadePolicyForContainment();
                if (this.getPersistenceOptions().isSetCascadePersistOnContainment()) {
                    option = String.valueOf(option) + HbCascadeType.LOCK.getName() + ", " + HbCascadeType.SAVE_UPDATE.getName();
                }
            } else if (this.getPersistenceOptions().isSetCascadePolicyForNonContainment()) {
                option = this.getPersistenceOptions().getCascadePolicyForNonContainment();
                if (this.getPersistenceOptions().isSetCascadePersistOnNonContainment()) {
                    option = String.valueOf(option) + HbCascadeType.LOCK.getName() + ", " + HbCascadeType.SAVE_UPDATE.getName();
                }
            } else {
                option = String.valueOf(HbCascadeType.PERSIST.getName()) + ", " + HbCascadeType.MERGE.getName() + ", " + HbCascadeType.REFRESH.getName() + ", " + HbCascadeType.LOCK.getName() + ", " + HbCascadeType.SAVE_UPDATE.getName();
            }
            Cascade hbCascade = HbannotationFactory.eINSTANCE.createCascade();
            HbCascadeType[] hbCascadeTypeArray = HbCascadeType.values();
            int n = hbCascadeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                HbCascadeType hbCascadeValue = hbCascadeTypeArray[n2];
                if (option.contains(hbCascadeValue.getName())) {
                    hbCascade.getValue().add((Object)hbCascadeValue);
                }
                ++n2;
            }
            if (hbCascade.getValue().size() > 0) {
                hbReference.setHbCascade(hbCascade);
            }
        }
    }

    protected void setCascade(List<CascadeType> cascadeList, boolean isContainment) {
        if (!cascadeList.isEmpty()) {
            return;
        }
    }

    public void setPersistenceOptions(PersistenceOptions persistenceOptions) {
        super.setPersistenceOptions(persistenceOptions);
        this.defaultCacheStrategy = persistenceOptions.getDefaultCacheStrategy();
    }
}

