/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.commit;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitInfoImpl;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class CDOCommitInfoManagerImpl
extends Lifecycle
implements InternalCDOCommitInfoManager {
    private InternalCDOCommitInfoManager.CommitInfoLoader commitInfoLoader;

    public InternalCDOCommitInfoManager.CommitInfoLoader getCommitInfoLoader() {
        return this.commitInfoLoader;
    }

    public void setCommitInfoLoader(InternalCDOCommitInfoManager.CommitInfoLoader commitInfoLoader) {
        this.checkInactive();
        this.commitInfoLoader = commitInfoLoader;
    }

    public CDOCommitInfo createCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOCommitData commitData) {
        this.checkActive();
        return new CDOCommitInfoImpl(this, branch, timeStamp, previousTimeStamp, userID, comment, commitData);
    }

    public CDOCommitInfo getCommitInfo(long timeStamp) {
        this.checkActive();
        final CDOCommitInfo[] result = new CDOCommitInfo[1];
        this.getCommitInfos(null, timeStamp, timeStamp, new CDOCommitInfoHandler(){

            public void handleCommitInfo(CDOCommitInfo commitInfo) {
                result[0] = commitInfo;
            }
        });
        return result[0];
    }

    public void getCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        this.checkActive();
        this.commitInfoLoader.loadCommitInfos(branch, startTime, endTime, handler);
    }

    public void getCommitInfos(CDOBranch branch, long startTime, String userID, String comment, int count, CDOCommitInfoHandler handler) {
        this.checkActive();
        throw new UnsupportedOperationException();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.commitInfoLoader, "commitInfoLoader");
    }
}

