/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.id;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.internal.common.id.CDOIDExternalImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectLongImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectLongWithClassifierImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectStringImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectStringWithClassifierImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectUUIDImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempObjectExternalImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempObjectImpl;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.revision.CDOIDAndBranchImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDOIDAndVersionImpl;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOIDLong;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOIDString;
import org.eclipse.emf.cdo.spi.common.id.InternalCDOIDObject;
import org.eclipse.net4j.util.ObjectUtil;

public final class CDOIDUtil {
    private CDOIDUtil() {
    }

    public static boolean isNull(CDOID id) {
        return id == null || id.isNull();
    }

    public static long getLong(CDOID id) {
        if (id == null) {
            return 0L;
        }
        switch (id.getType()) {
            case NULL: {
                return 0L;
            }
            case OBJECT: {
                if (id instanceof AbstractCDOIDLong) {
                    return ((AbstractCDOIDLong)id).getLongValue();
                }
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.0"), id.getClass().getName()));
            }
            case TEMP_OBJECT: {
                throw new IllegalArgumentException(Messages.getString("CDOIDUtil.1"));
            }
            case EXTERNAL_OBJECT: 
            case EXTERNAL_TEMP_OBJECT: {
                throw new IllegalArgumentException(Messages.getString("CDOIDUtil.2"));
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.3"), id.getClass().getName()));
    }

    public static String getString(CDOID id) {
        if (id == null) {
            return AbstractCDOIDString.NULL_VALUE;
        }
        switch (id.getType()) {
            case NULL: {
                return AbstractCDOIDString.NULL_VALUE;
            }
            case OBJECT: {
                if (id instanceof AbstractCDOIDString) {
                    return ((AbstractCDOIDString)id).getStringValue();
                }
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.0"), id.getClass().getName()));
            }
            case TEMP_OBJECT: {
                throw new IllegalArgumentException(Messages.getString("CDOIDUtil.1"));
            }
            case EXTERNAL_OBJECT: 
            case EXTERNAL_TEMP_OBJECT: {
                if (id instanceof CDOIDExternalImpl) {
                    return ((CDOIDExternalImpl)id).getURI();
                }
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.0"), id.getClass().getName()));
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.3"), id.getClass().getName()));
    }

    public static CDOClassifierRef getClassifierRef(CDOID id) {
        if (id instanceof CDOClassifierRef.Provider) {
            return ((CDOClassifierRef.Provider)((Object)id)).getClassifierRef();
        }
        return null;
    }

    public static CDOIDTemp createTempObject(int value) {
        return new CDOIDTempObjectImpl(value);
    }

    public static CDOIDExternal createTempObjectExternal(String uri) {
        return new CDOIDTempObjectExternalImpl(uri);
    }

    public static CDOID createLong(long value) {
        if (value == 0L) {
            return CDOID.NULL;
        }
        return new CDOIDObjectLongImpl(value);
    }

    public static CDOID createLongWithClassifier(CDOClassifierRef classifierRef, long value) {
        return new CDOIDObjectLongWithClassifierImpl(classifierRef, value);
    }

    public static CDOID createString(String value) {
        return new CDOIDObjectStringImpl(value);
    }

    public static CDOID createStringWithClassifier(CDOClassifierRef classifierRef, String value) {
        return new CDOIDObjectStringWithClassifierImpl(classifierRef, value);
    }

    public static CDOIDExternal createExternal(String uri) {
        return new CDOIDExternalImpl(uri);
    }

    public static CDOIDAndVersion createIDAndVersion(CDOID id, int version) {
        return new CDOIDAndVersionImpl(id, version);
    }

    public static CDOIDAndVersion createIDAndVersion(CDOIDAndVersion source) {
        return CDOIDUtil.createIDAndVersion(source.getID(), source.getVersion());
    }

    public static CDOIDAndBranch createIDAndBranch(CDOID id, CDOBranch branch) {
        return new CDOIDAndBranchImpl(id, branch);
    }

    public static AbstractCDOID createCDOIDObject(CDOID.ObjectType subType) {
        AbstractCDOID id;
        if (subType == null) {
            throw new IllegalArgumentException("SubType may not be null");
        }
        switch (subType) {
            case LONG: {
                id = new CDOIDObjectLongImpl();
                break;
            }
            case STRING: {
                id = new CDOIDObjectStringImpl();
                break;
            }
            case LONG_WITH_CLASSIFIER: {
                id = new CDOIDObjectLongWithClassifierImpl();
                break;
            }
            case STRING_WITH_CLASSIFIER: {
                id = new CDOIDObjectStringWithClassifierImpl();
                break;
            }
            case UUID: {
                id = new CDOIDObjectUUIDImpl();
                break;
            }
            default: {
                throw new IllegalArgumentException("Subtype " + subType.name() + " not supported");
            }
        }
        if (id.getSubType() != subType) {
            throw new IllegalStateException("Subtype of created id " + id + " is unequal (" + id.getSubType().name() + ") to requested subtype " + subType.name());
        }
        return id;
    }

    public static void write(StringBuilder builder, CDOID id) {
        if (id == null) {
            id = CDOID.NULL;
        }
        if (id instanceof InternalCDOIDObject) {
            CDOID.ObjectType subType = ((InternalCDOIDObject)id).getSubType();
            builder.append(subType.getID());
        } else {
            CDOID.Type type = id.getType();
            builder.append(type.getID());
        }
        builder.append(id.toURIFragment());
    }

    public static CDOID read(String uriFragment) {
        char typeID = uriFragment.charAt(0);
        Enum<?> literal = CDOID.Type.getLiteral(typeID);
        if (literal == null) {
            throw new IllegalArgumentException("Unknown type ID: " + typeID);
        }
        String fragment = uriFragment.substring(1);
        if (literal instanceof CDOID.ObjectType) {
            return CDOIDUtil.readCDOIDObject((CDOID.ObjectType)literal, fragment);
        }
        CDOID.Type type = (CDOID.Type)literal;
        switch (type) {
            case NULL: {
                return CDOID.NULL;
            }
            case TEMP_OBJECT: {
                return new CDOIDTempObjectImpl(Integer.valueOf(fragment));
            }
            case EXTERNAL_OBJECT: {
                return new CDOIDExternalImpl(fragment);
            }
            case EXTERNAL_TEMP_OBJECT: {
                return new CDOIDTempObjectExternalImpl(fragment);
            }
            case OBJECT: {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.5"), uriFragment));
    }

    private static CDOID readCDOIDObject(CDOID.ObjectType subType, String fragment) {
        AbstractCDOID id = CDOIDUtil.createCDOIDObject(subType);
        id.read(fragment);
        return id;
    }

    public static boolean equals(CDOID id1, CDOID id2) {
        if (id1 == null) {
            id1 = CDOID.NULL;
        }
        if (id2 == null) {
            id2 = CDOID.NULL;
        }
        return ObjectUtil.equals((Object)id1, (Object)id2);
    }
}

