/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.hibernate.teneo;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.cdo.server.hibernate.teneo.CDOEDataTypeAnnotator;
import org.eclipse.emf.cdo.server.hibernate.teneo.CDOEFeatureAnnotator;
import org.eclipse.emf.cdo.server.hibernate.teneo.CDOManyAttributeMapper;
import org.eclipse.emf.cdo.server.hibernate.teneo.CDOMappingContext;
import org.eclipse.emf.cdo.server.hibernate.teneo.CDOXmlPersistenceContentHandler;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.annotations.mapper.EDataTypeAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.EFeatureAnnotator;
import org.eclipse.emf.teneo.annotations.xml.XmlPersistenceContentHandler;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerFactory;
import org.eclipse.emf.teneo.extension.ExtensionUtil;
import org.eclipse.emf.teneo.hibernate.mapper.ManyAttributeMapper;
import org.eclipse.emf.teneo.hibernate.mapper.MappingContext;
import org.eclipse.emf.teneo.hibernate.mapper.MappingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOMappingGenerator {
    private static Map<String, String> extensions = new HashMap<String, String>();
    private ExtensionManager extensionManager = ExtensionManagerFactory.getInstance().create();

    public void registerCDOExtensions(ExtensionManager extensionManager) {
        MappingUtil.registerHbExtensions((ExtensionManager)extensionManager);
        this.addDefaultExtension(MappingContext.class, CDOMappingContext.class, extensionManager);
        this.addDefaultExtension(EFeatureAnnotator.class, CDOEFeatureAnnotator.class, extensionManager);
        this.addDefaultExtension(ManyAttributeMapper.class, CDOManyAttributeMapper.class, extensionManager);
        this.addDefaultExtension(XmlPersistenceContentHandler.class, CDOXmlPersistenceContentHandler.class, extensionManager);
        this.addDefaultExtension(EDataTypeAnnotator.class, CDOEDataTypeAnnotator.class, extensionManager);
        for (String key : extensions.keySet()) {
            try {
                Class<?> keyClass = Thread.currentThread().getContextClassLoader().loadClass(key);
                Class<?> valueClass = Thread.currentThread().getContextClassLoader().loadClass(extensions.get(key));
                extensionManager.registerExtension(ExtensionUtil.createExtension(keyClass, valueClass, (boolean)false));
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
    }

    protected void addDefaultExtension(Class<?> extensionClass, Class<?> extendingClass, ExtensionManager extensionManager) {
        if (extensions.containsKey(extensionClass.getName())) {
            return;
        }
        extensionManager.registerExtension(ExtensionUtil.createExtension(extensionClass, extendingClass, (boolean)false));
    }

    public Map<String, String> getExtensions() {
        return extensions;
    }

    public void putExtension(String extensionClassName, String extendingClassName) {
        extensions.put(extensionClassName, extendingClassName);
    }

    public String generateMapping(EPackage[] epackages, Properties props) {
        props.put("teneo.mapping.always_version", "false");
        if (!props.containsKey("teneo.naming.default_id_column")) {
            props.put("teneo.naming.default_id_column", "idcol");
        }
        if (!props.containsKey("teneo.naming.version_column")) {
            props.put("teneo.naming.version_column", "version");
        }
        props.put("teneo.mapping.also_map_as_class", "false");
        props.put("teneo.mapping.emap_as_true_map", "false");
        this.registerCDOExtensions(this.extensionManager);
        return MappingUtil.generateMapping((EPackage[])epackages, (Properties)props, (ExtensionManager)this.extensionManager);
    }
}

