/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.hibernate.teneo;

import java.util.List;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOIDUserType;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.hibernate.mapper.EntityMapper;
import org.eclipse.emf.teneo.simpledom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOEntityMapper
extends EntityMapper {
    private PAnnotatedEClass currentEntity;
    private boolean addedExtraMappings;

    public void processEntity(PAnnotatedEClass entity) {
        this.currentEntity = entity;
        try {
            this.addedExtraMappings = false;
            super.processEntity(entity);
        }
        finally {
            this.currentEntity = null;
        }
    }

    protected void processFeatures(List<PAnnotatedEStructuralFeature> features) {
        super.processFeatures(features);
        Element entityElement = this.getHbmContext().getCurrent();
        entityElement.addAttribute("lazy", "true");
        if (!this.addedExtraMappings && this.currentEntity.getPaSuperEntity() == null) {
            Element resourceElement = entityElement.addElement("property");
            resourceElement.addAttribute("name", "resourceID");
            resourceElement.addElement("column").addAttribute("name", "resource_id");
            resourceElement.addAttribute("type", CDOIDUserType.class.getName());
            Element containerElement = entityElement.addElement("property");
            containerElement.addAttribute("name", "containerID").addAttribute("type", "string");
            Element columnElement = containerElement.addElement("column").addAttribute("name", "container_id");
            Element versionElement = entityElement.addElement("property");
            versionElement.addAttribute("name", this.getHbmContext().getVersionColumnName());
            versionElement.addElement("meta").addAttribute("attribute", "version").setText("true");
            versionElement.addElement("column").addAttribute("name", this.getHbmContext().getVersionColumnName());
            versionElement.addAttribute("type", Integer.class.getName());
            if (this.getHbmContext().getCurrentEClass() == EresourcePackage.eINSTANCE.getCDOResourceNode()) {
                columnElement.addAttribute("unique-key", "c0");
            }
            this.addedExtraMappings = true;
        }
    }
}

