/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.hibernate.internal.teneo;

import java.util.Properties;
import org.eclipse.emf.cdo.server.hibernate.IHibernateMappingProvider;
import org.eclipse.emf.cdo.server.hibernate.internal.teneo.TeneoHibernateMappingProvider;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TeneoHibernateMappingProviderFactory
implements IHibernateMappingProvider.Factory {
    public static final String TYPE = "teneo";
    private static final String PROPERTY_TAG = "property";
    private static final String EXTENSION_TAG = "extension";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";

    public String getType() {
        return TYPE;
    }

    public TeneoHibernateMappingProvider create(Element config) {
        Properties properties = new Properties();
        NodeList propertyNodes = config.getElementsByTagName(PROPERTY_TAG);
        int i = 0;
        while (i < propertyNodes.getLength()) {
            Element propertyElement = (Element)propertyNodes.item(i);
            properties.setProperty(propertyElement.getAttribute(NAME_ATTR), propertyElement.getAttribute(VALUE_ATTR));
            ++i;
        }
        TeneoHibernateMappingProvider mappingProvider = new TeneoHibernateMappingProvider();
        mappingProvider.setMappingProviderProperties(properties);
        this.collectExtensions(config, mappingProvider);
        return mappingProvider;
    }

    private void collectExtensions(Element config, TeneoHibernateMappingProvider mappingProvider) {
        NodeList extensionNodes = config.getElementsByTagName(EXTENSION_TAG);
        int i = 0;
        while (i < extensionNodes.getLength()) {
            Element extensionElement = (Element)extensionNodes.item(i);
            String nameAttrValue = extensionElement.getAttribute(NAME_ATTR);
            String valueAttrValue = extensionElement.getAttribute(VALUE_ATTR);
            if (nameAttrValue == null || valueAttrValue == null) {
                throw new IllegalArgumentException("Extension element has incorrect format, both the name and value attribute should be present");
            }
            mappingProvider.putExtension(nameAttrValue, valueAttrValue);
            ++i;
        }
    }
}

