/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.hibernate.internal.teneo;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.server.hibernate.internal.teneo.bundle.OM;
import org.eclipse.emf.cdo.server.hibernate.teneo.CDOMappingGenerator;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateMappingProvider;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOBlobUserType;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOClobUserType;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.PackageRegistryProvider;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class TeneoHibernateMappingProvider
extends HibernateMappingProvider {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, TeneoHibernateMappingProvider.class);
    private Map<String, String> extensions = new HashMap<String, String>();
    private Properties mappingProviderProperties = new Properties();

    public void putExtension(String extensionClassName, String extendingClassName) {
        this.extensions.put(extensionClassName, extendingClassName);
    }

    public HibernateStore getHibernateStore() {
        return (HibernateStore)super.getHibernateStore();
    }

    public String getMapping() {
        String mapping = this.generateMapping();
        if (TRACER.isEnabled()) {
            TRACER.trace("Generated hibernate mapping:");
            TRACER.trace(mapping);
        }
        return mapping;
    }

    public String generateMapping() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Generating Hibernate Mapping");
        }
        Properties storeProperties = this.getHibernateStore().getProperties();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)storeProperties);
        properties.putAll((Map<?, ?>)this.mappingProviderProperties);
        PackageRegistryProvider.getInstance().setThreadPackageRegistry((EPackage.Registry)this.getHibernateStore().getRepository().getPackageRegistry());
        boolean hasXMLTypePackage = false;
        List epacks = this.getHibernateStore().getPackageHandler().getEPackages();
        ListIterator iterator = epacks.listIterator();
        while (iterator.hasNext()) {
            EPackage epack = (EPackage)iterator.next();
            if (CDOModelUtil.isSystemPackage((EPackage)epack) && epack != EtypesPackage.eINSTANCE) {
                iterator.remove();
                continue;
            }
            if (epack != XMLTypePackage.eINSTANCE) continue;
            hasXMLTypePackage = true;
        }
        if (hasXMLTypePackage) {
            this.addTypeAnnotationToXMLTypes();
        }
        this.addUniqueConstraintAnnotation();
        EPackage[] ePackageArray = epacks.toArray(new EPackage[epacks.size()]);
        if (ePackageArray.length == 0 && properties.getProperty("teneo.mapping.persistence_xml") != null) {
            properties.remove("teneo.mapping.persistence_xml");
        }
        this.addTypeAnnotationToEDataType(EtypesPackage.eINSTANCE.getBlob(), CDOBlobUserType.class.getName());
        this.addTypeAnnotationToEDataType(EtypesPackage.eINSTANCE.getClob(), CDOClobUserType.class.getName());
        CDOMappingGenerator mappingGenerator = new CDOMappingGenerator();
        mappingGenerator.getExtensions().putAll(this.extensions);
        String hbm = mappingGenerator.generateMapping(ePackageArray, properties);
        hbm = hbm.replaceAll("_cont", "cont");
        return hbm;
    }

    private void addTypeAnnotationToXMLTypes() {
        for (EClassifier eClassifier : XMLTypePackage.eINSTANCE.getEClassifiers()) {
            EDataType eDataType;
            if (!(eClassifier instanceof EDataType) || (eDataType = (EDataType)eClassifier).getEAnnotation("teneo.jpa") != null) continue;
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("teneo.jpa");
            String typeAnnotation = "@Type(type=\"org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.XMLUserType$" + eDataType.getName() + "\")";
            eAnnotation.getDetails().put((Object)"value", (Object)typeAnnotation);
            eDataType.getEAnnotations().add((Object)eAnnotation);
        }
    }

    private void addTypeAnnotationToEDataType(EDataType eDataType, String type) {
        if (eDataType.getEAnnotation("teneo.jpa") != null) {
            return;
        }
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setSource("teneo.jpa");
        String typeAnnotation = "@Type(type=\"" + type + "\")";
        eAnnotation.getDetails().put((Object)"value", (Object)typeAnnotation);
        eDataType.getEAnnotations().add((Object)eAnnotation);
    }

    private void addUniqueConstraintAnnotation() {
        EClass eClass = EresourcePackage.eINSTANCE.getCDOResourceNode();
        if (eClass.getEAnnotation("teneo.jpa") != null) {
            return;
        }
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource("teneo.jpa");
        String tableAnnotation = "@Table(uniqueConstraints={@UniqueConstraint(columnNames={\"container_id\", \"" + EresourcePackage.eINSTANCE.getCDOResourceNode_Name().getName() + "\"})})";
        annotation.getDetails().put((Object)"value", (Object)tableAnnotation);
        eClass.getEAnnotations().add((Object)annotation);
    }

    public Properties getMappingProviderProperties() {
        return this.mappingProviderProperties;
    }

    public void setMappingProviderProperties(Properties mappingProviderProperties) {
        this.mappingProviderProperties = mappingProviderProperties;
    }
}

