/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j;

import java.util.concurrent.ExecutorService;
import org.eclipse.internal.net4j.TransportConfig;
import org.eclipse.internal.net4j.buffer.BufferFactory;
import org.eclipse.internal.net4j.buffer.BufferPool;
import org.eclipse.internal.net4j.buffer.BufferProviderFactory;
import org.eclipse.net4j.ITransportConfig;
import org.eclipse.net4j.TransportInjector;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.buffer.IBufferPool;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.heartbeat.HeartBeatProtocol;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.ExecutorServiceFactory;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.lifecycle.ILifecycle;

public final class Net4jUtil {
    public static final String SCHEME_SEPARATOR = "://";
    public static final short DEFAULT_BUFFER_CAPACITY = 4096;

    private Net4jUtil() {
    }

    public static void prepareContainer(IManagedContainer container) {
        ContainerUtil.prepareContainer((IManagedContainer)container);
        container.registerFactory((IFactory)new BufferProviderFactory());
        container.addPostProcessor((IElementProcessor)new TransportInjector());
        container.registerFactory((IFactory)new HeartBeatProtocol.Server.Factory());
        container.addPostProcessor((IElementProcessor)new HeartBeatProtocol.Server.TimerInjector());
    }

    public static ExecutorService getExecutorService(IManagedContainer container) {
        return ExecutorServiceFactory.get((IManagedContainer)container);
    }

    public static IBufferProvider getBufferProvider(IManagedContainer container) {
        return BufferProviderFactory.get(container);
    }

    public static IAcceptor getAcceptor(IManagedContainer container, String type, String description) {
        return (IAcceptor)container.getElement("org.eclipse.net4j.acceptors", type, description);
    }

    public static IConnector getConnector(IManagedContainer container, String type, String description, long timeout) {
        IConnector connector = (IConnector)container.getElement("org.eclipse.net4j.connectors", type, description);
        try {
            connector.waitForConnection(timeout);
        }
        catch (ConnectorException ex) {
            container.removeElement("org.eclipse.net4j.connectors", type, description);
            throw ex;
        }
        return connector;
    }

    public static IConnector getConnector(IManagedContainer container, String type, String description) {
        return Net4jUtil.getConnector(container, type, description, 10000L);
    }

    public static IConnector getConnector(IManagedContainer container, String description) {
        int pos = description.indexOf(SCHEME_SEPARATOR);
        if (pos <= 0) {
            throw new IllegalArgumentException("Connector type (scheme) missing: " + description);
        }
        String factoryType = description.substring(0, pos);
        String connectorDescription = description.substring(pos + SCHEME_SEPARATOR.length());
        if (StringUtil.isEmpty((String)connectorDescription)) {
            throw new IllegalArgumentException("Illegal connector description: " + description);
        }
        return Net4jUtil.getConnector(container, factoryType, connectorDescription);
    }

    public static IBufferProvider createBufferFactory(short bufferCapacity) {
        return new BufferFactory(bufferCapacity);
    }

    public static IBufferProvider createBufferFactory() {
        return Net4jUtil.createBufferFactory((short)4096);
    }

    public static IBufferPool createBufferPool(IBufferProvider factory) {
        return new BufferPool(factory);
    }

    public static IBufferPool createBufferPool(short bufferCapacity) {
        return Net4jUtil.createBufferPool(Net4jUtil.createBufferFactory(bufferCapacity));
    }

    public static IBufferPool createBufferPool() {
        return Net4jUtil.createBufferPool(Net4jUtil.createBufferFactory());
    }

    public static long getProvidedBuffers(IBufferProvider bufferProvider) {
        if (bufferProvider instanceof IBufferProvider.Introspection) {
            return ((IBufferProvider.Introspection)bufferProvider).getProvidedBuffers();
        }
        return -1L;
    }

    public static long getRetainedBuffers(IBufferProvider bufferProvider) {
        if (bufferProvider instanceof IBufferProvider.Introspection) {
            return ((IBufferProvider.Introspection)bufferProvider).getRetainedBuffers();
        }
        return -1L;
    }

    public static int getPooledBuffers(IBufferPool bufferPool) {
        if (bufferPool instanceof IBufferPool.Introspection) {
            return ((IBufferPool.Introspection)bufferPool).getPooledBuffers();
        }
        return -1;
    }

    public static ITransportConfig copyTransportConfig(ILifecycle lifecycle, ITransportConfig source) {
        return new TransportConfig(lifecycle, source.getReceiveExecutor(), source.getBufferProvider(), source.getProtocolProvider(), source.getNegotiator());
    }
}

