/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db.postgresql;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import javax.sql.DataSource;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.internal.postgresql.bundle.OM;
import org.eclipse.net4j.spi.db.DBAdapter;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.postgresql.Driver;
import org.postgresql.ds.PGSimpleDataSource;

public class PostgreSQLAdapter
extends DBAdapter {
    public static final String NAME = "postgresql";
    public static final String VERSION = "8.3";
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SQL, DBAdapter.class);
    private static final String[] RESERVED_WORDS = new String[]{"ALL", "ANALYSE", "ANALYZE", "AND", "ANY", "AS", "ASC", "ATOMIC", "AUTHORIZATION", "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN", "BOTH", "C", "CASE", "CAST", "CHAR", "CHARACTER", "CHECK", "COALESCE", "COLLATE", "COLUMN", "CONSTRAINT", "CONVERT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEC", "DECIMAL", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DO", "ELSE", "END", "EXCEPT", "EXECUTE", "EXISTS", "EXTRACT", "FALSE", "FLOAT", "FOR", "FOREIGN", "FREEZE", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "ILIKE", "IN", "INITIALLY", "INNER", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISNULL", "JOIN", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NCHAR", "NCLOB", "NEW", "NONE", "NOT", "NOTNULL", "NULL", "NULLIF", "NUMERIC", "OFF", "OFFSET", "OLD", "ON", "ONLY", "OR", "ORDER", "OUTER", "OVERLAPS", "OVERLAY", "PLACING", "POSITION", "PRIMARY", "REAL", "RECHECK", "REFERENCES", "RIGHT", "ROW", "SELECT", "SESSION_USER", "SETOF", "SIMILAR", "SMALLINT", "SOME", "SUBSTRING", "TABLE", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TREAT", "TRIM", "TRUE", "UNION", "UNIQUE", "USER", "USING", "VARCHAR", "VERBOSE", "WHEN", "WHERE"};

    public PostgreSQLAdapter() {
        super(NAME, VERSION);
    }

    public Driver getJDBCDriver() {
        return new Driver();
    }

    public DataSource createJDBCDataSource() {
        return new PGSimpleDataSource();
    }

    public int getMaxTableNameLength() {
        return 63;
    }

    public int getMaxFieldNameLength() {
        return 63;
    }

    protected String getTypeName(IDBField field) {
        DBType type = field.getType();
        switch (type) {
            case VARCHAR: 
            case LONGVARCHAR: 
            case CLOB: {
                return "text";
            }
            case BLOB: {
                return "bytea";
            }
            case DOUBLE: {
                return "double precision";
            }
        }
        return super.getTypeName(field);
    }

    public String[] getReservedWords() {
        return RESERVED_WORDS;
    }

    public boolean createTable(IDBTable table, Statement statement) throws DBException {
        boolean created = true;
        Savepoint savepoint = null;
        try {
            savepoint = statement.getConnection().setSavepoint();
        }
        catch (SQLException ex) {
            OM.LOG.error((Throwable)ex);
        }
        try {
            this.doCreateTable(table, statement);
        }
        catch (SQLException ex) {
            created = false;
            if (TRACER.isEnabled()) {
                TRACER.trace("-- " + ex.getMessage() + ". Trying to rollback operation");
            }
            if (savepoint != null) {
                try {
                    statement.getConnection().rollback(savepoint);
                }
                catch (SQLException ex1) {
                    OM.LOG.error((Throwable)ex1);
                }
            }
            OM.LOG.error("Could not rollback last operation. Savepoint was not created.");
        }
        this.validateTable(table, statement);
        return created;
    }

    public DBType adaptType(DBType type) {
        switch (type) {
            case BLOB: {
                return DBType.VARBINARY;
            }
        }
        return super.adaptType(type);
    }
}

