/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.type;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.util.StoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentStoreAdapter
implements Adapter {
    private static final long serialVersionUID = 1L;
    private Notifier target;
    private boolean targetCreatedByORM;
    private Map<EStructuralFeature, Object> storeCollections = new HashMap<EStructuralFeature, Object>();
    private Map<String, Object> syntheticProperties = new HashMap<String, Object>();

    public void addStoreCollection(EStructuralFeature eFeature, Object storeCollection) {
        this.storeCollections.put(eFeature, storeCollection);
    }

    public Object getStoreCollection(EStructuralFeature eFeature) {
        return this.storeCollections.get(eFeature);
    }

    public Notifier getTarget() {
        return this.target;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification notification) {
        EStructuralFeature eFeature = (EStructuralFeature)notification.getFeature();
        Object collectionObject = this.storeCollections.get(eFeature);
        if (collectionObject == null) {
            return;
        }
        List list = collectionObject instanceof List ? (List)collectionObject : null;
        Map map = collectionObject instanceof Map ? (Map)collectionObject : null;
        boolean isEReference = eFeature instanceof EReference;
        int changedPosition = -1;
        switch (notification.getEventType()) {
            case 3: {
                if (list != null) {
                    if (notification.getPosition() != -1) {
                        changedPosition = notification.getPosition();
                        list.add(notification.getPosition(), this.replaceValue(notification.getNewValue(), eFeature));
                    } else {
                        changedPosition = list.size();
                        list.add(this.replaceValue(notification.getNewValue(), eFeature));
                    }
                }
                if (map == null) break;
                Map.Entry entry = (Map.Entry)notification.getNewValue();
                map.put(entry.getKey(), entry.getValue());
                break;
            }
            case 5: {
                Object entry;
                if (list != null) {
                    if (notification.getPosition() != -1) {
                        changedPosition = notification.getPosition();
                        list.addAll(notification.getPosition(), this.replaceValues((List)notification.getNewValue(), eFeature));
                    } else {
                        changedPosition = list.size();
                        list.addAll(this.replaceValues((List)notification.getNewValue(), eFeature));
                    }
                }
                if (map == null) break;
                for (Object o : (List)notification.getNewValue()) {
                    entry = (Map.Entry)o;
                    map.put(entry.getKey(), entry.getValue());
                }
                break;
            }
            case 4: {
                if (list != null) {
                    Object removed;
                    if (notification.getPosition() != -1) {
                        removed = list.remove(notification.getPosition());
                    } else {
                        removed = this.replaceValue(notification.getOldValue(), eFeature);
                        list.remove(removed);
                    }
                    changedPosition = 0;
                    if (isEReference) {
                        StoreUtil.resetSyntheticListInfo(eFeature, removed);
                    }
                }
                if (map == null) break;
                Map.Entry entry = (Map.Entry)notification.getOldValue();
                map.remove(entry.getKey());
                break;
            }
            case 6: {
                Object entry;
                if (list != null) {
                    List<Object> removed = this.replaceValues((List)notification.getOldValue(), eFeature);
                    list.removeAll(removed);
                    if (isEReference) {
                        for (Object e : removed) {
                            StoreUtil.resetSyntheticListInfo(eFeature, e);
                        }
                    }
                    changedPosition = 0;
                }
                if (map == null) break;
                for (Object o : (List)notification.getOldValue()) {
                    entry = (Map.Entry)o;
                    map.remove(entry.getKey());
                }
                break;
            }
            case 7: {
                if (list == null) break;
                int oldPosition = (Integer)notification.getOldValue();
                int n = notification.getPosition();
                Object o = list.remove(oldPosition);
                if (o != notification.getNewValue()) {
                    throw new IllegalStateException("Persistent list and EList are out of sync");
                }
                list.add(n, o);
                if (n < oldPosition) {
                    changedPosition = n;
                    break;
                }
                changedPosition = oldPosition;
                break;
            }
            case 1: {
                if (list == null) break;
                int position = notification.getPosition();
                Object object = list.set(position, this.replaceValue(notification.getNewValue(), eFeature));
                changedPosition = position;
                if (!isEReference) break;
                StoreUtil.resetSyntheticListInfo(eFeature, object);
            }
        }
        if (changedPosition > -1 && isEReference) {
            int newIndex = changedPosition;
            for (Object e : list.subList(changedPosition, list.size())) {
                StoreUtil.setSyntheticListOwner(eFeature, e, notification.getNotifier());
                StoreUtil.setSyntheticListIndex(eFeature, e, newIndex++);
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        this.target = newTarget;
    }

    public boolean isTargetCreatedByORM() {
        return this.targetCreatedByORM;
    }

    public void setTargetCreatedByORM(boolean targetCreatedByORM) {
        this.targetCreatedByORM = targetCreatedByORM;
    }

    public Map<EStructuralFeature, Object> getStoreCollections() {
        return this.storeCollections;
    }

    protected Object replaceValue(Object value, EStructuralFeature eFeature) {
        return value;
    }

    protected List<Object> replaceValues(List<Object> values, EStructuralFeature eFeature) {
        return values;
    }

    public Object getSyntheticProperty(String property) {
        return this.syntheticProperties.get(property);
    }

    public void setSyntheticProperty(String property, Object value) {
        this.syntheticProperties.put(property, value);
    }
}

