/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.teneo.annotations.mapper.BaseEFeatureAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.StoreMappingException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.FetchType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.ManyToOne;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;
import org.eclipse.emf.teneo.extension.ExtensionPoint;

public class ManyToOneReferenceAnnotator
extends BaseEFeatureAnnotator
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(ManyToOneReferenceAnnotator.class);

    public void annotate(PAnnotatedEReference aReference) {
        block13: {
            ManyToOne mto;
            block12: {
                String logStr = String.valueOf(aReference.getModelEReference().getName()) + "/" + aReference.getModelEReference().getEContainingClass().getName();
                if (aReference.getOneToMany() != null || aReference.getManyToMany() != null || aReference.getOneToOne() != null) {
                    throw new StoreMappingException("The feature/eclass " + logStr + " should be a ManyToOne but " + "it already has a OneToMany, ManyToMany or OneToOne annotation");
                }
                EReference eReference = (EReference)aReference.getModelElement();
                mto = aReference.getManyToOne();
                if (mto == null) {
                    log.debug((Object)("EReference + " + logStr + " does not have a manytoone annotation, adding one"));
                    mto = this.getFactory().createManyToOne();
                    aReference.setManyToOne(mto);
                    mto.setOptional(!eReference.isRequired() || eReference.getEOpposite() != null || eReference.isUnsettable());
                    mto.setEModelElement((EModelElement)eReference);
                } else {
                    log.debug((Object)("EReference + " + logStr + " does have a manytoone annotation, using it"));
                }
                if (!mto.isSetFetch()) {
                    mto.setFetch(this.getFetch(aReference.getAReferenceType()));
                }
                if (eReference.isContainment() || this.getPersistenceOptions().isSetDefaultCascadeOnNonContainment()) {
                    this.setCascade((List<CascadeType>)mto.getCascade(), eReference.isContainment());
                }
                if (mto.getTargetEntity() == null) {
                    mto.setTargetEntity(this.getEntityName(eReference.getEReferenceType()));
                }
                if (this.getPersistenceOptions().isSetForeignKeyNames() && aReference.getForeignKey() == null) {
                    aReference.setForeignKey(this.createFK((PAnnotatedEStructuralFeature)aReference));
                }
                if (this.getPersistenceOptions().isMapEmbeddableAsEmbedded() && aReference.getAReferenceType().getEmbeddable() != null) {
                    aReference.setEmbedded(this.getFactory().createEmbedded());
                }
                if (aReference.getJoinColumns() != null && !aReference.getJoinColumns().isEmpty()) break block12;
                if (aReference.getAReferenceType() == null) break block13;
                boolean hasJoinTable = false;
                boolean isInsertableUpdatable = true;
                if (eReference.getEOpposite() != null && !eReference.getEOpposite().isTransient()) {
                    PAnnotatedEReference aOpposite = this.getAnnotatedModel().getPAnnotated(eReference.getEOpposite());
                    boolean bl = hasJoinTable = !aOpposite.getModelEReference().isContainment() && this.getPersistenceOptions().isJoinTableForNonContainedAssociations() || aOpposite.getJoinTable() != null;
                    if (!hasJoinTable && aOpposite.getOneToMany() != null && aOpposite.getOneToMany().isList() && !aOpposite.getOneToMany().getFetch().equals((Object)FetchType.EXTRA)) {
                        isInsertableUpdatable = false;
                    }
                    if (aReference.getAReferenceType().getEavMapping() != null) {
                        isInsertableUpdatable = true;
                    }
                }
                if (hasJoinTable) break block13;
                List<String> names = this.getSqlNameStrategy().getManyToOneJoinColumnNames(aReference);
                aReference.getJoinColumns().addAll(this.getJoinColumns(names, mto.isOptional(), isInsertableUpdatable, (PAnnotation)mto));
                break block13;
            }
            for (JoinColumn jc : aReference.getJoinColumns()) {
                if (jc.isSetNullable()) continue;
                jc.setNullable(mto.isOptional());
            }
        }
    }
}

