/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.syncing;

import java.util.List;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.server.TransactionCommitContext;
import org.eclipse.emf.cdo.internal.server.syncing.SynchronizableRepository;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeKindCache;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.net4j.util.collection.IndexedList;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class OfflineClone
extends SynchronizableRepository {
    public OfflineClone() {
        this.setState(OFFLINE);
    }

    public final CDOCommonRepository.Type getType() {
        return CLONE;
    }

    public final void setType(CDOCommonRepository.Type type) {
        throw new UnsupportedOperationException();
    }

    public InternalCommitContext createCommitContext(InternalTransaction transaction) {
        CDOBranch branch = transaction.getBranch();
        if (branch.isLocal()) {
            return this.createNormalCommitContext(transaction);
        }
        if (this.getState() != ONLINE) {
            return this.createBranchingCommitContext(transaction, branch);
        }
        return this.createWriteThroughCommitContext(transaction);
    }

    protected InternalCommitContext createBranchingCommitContext(InternalTransaction transaction, CDOBranch branch) {
        long[] times = this.createCommitTimeStamp((OMMonitor)new Monitor());
        CDOBranch offlineBranch = this.createOfflineBranch(branch, times[0] - 1L);
        transaction.setBranchPoint(offlineBranch.getHead());
        return new BranchingCommitContext(transaction, times);
    }

    protected CDOBranch createOfflineBranch(CDOBranch baseBranch, long baseTimeStamp) {
        try {
            StoreThreadLocal.setSession(this.getReplicatorSession());
            InternalCDOBranchManager branchManager = this.getBranchManager();
            InternalCDOBranch internalCDOBranch = branchManager.createBranch(Integer.MIN_VALUE, "Offline-" + baseTimeStamp, (InternalCDOBranch)baseBranch, baseTimeStamp);
            return internalCDOBranch;
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected final class BranchingCommitContext
    extends TransactionCommitContext {
        private long[] times;

        public BranchingCommitContext(InternalTransaction transaction, long[] times) {
            super(transaction);
            this.times = times;
        }

        protected void lockObjects() throws InterruptedException {
        }

        protected long[] createTimeStamp(OMMonitor monitor) {
            return this.times;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class CommitContextData
    implements CDOCommitData {
        private InternalCommitContext commitContext;
        private CDOChangeKindCache changeKindCache;

        public CommitContextData(InternalCommitContext commitContext) {
            this.commitContext = commitContext;
        }

        public boolean isEmpty() {
            return false;
        }

        public CDOChangeSetData copy() {
            throw new UnsupportedOperationException();
        }

        public void merge(CDOChangeSetData changeSetData) {
            throw new UnsupportedOperationException();
        }

        public List<CDOPackageUnit> getNewPackageUnits() {
            final InternalCDOPackageUnit[] newPackageUnits = this.commitContext.getNewPackageUnits();
            return new IndexedList<CDOPackageUnit>(){

                public CDOPackageUnit get(int index) {
                    return newPackageUnits[index];
                }

                public int size() {
                    return newPackageUnits.length;
                }
            };
        }

        public List<CDOIDAndVersion> getNewObjects() {
            final InternalCDORevision[] newObjects = this.commitContext.getNewObjects();
            return new IndexedList<CDOIDAndVersion>(){

                public CDOIDAndVersion get(int index) {
                    return newObjects[index];
                }

                public int size() {
                    return newObjects.length;
                }
            };
        }

        public List<CDORevisionKey> getChangedObjects() {
            final InternalCDORevisionDelta[] changedObjects = this.commitContext.getDirtyObjectDeltas();
            return new IndexedList<CDORevisionKey>(){

                public CDORevisionKey get(int index) {
                    return changedObjects[index];
                }

                public int size() {
                    return changedObjects.length;
                }
            };
        }

        public List<CDOIDAndVersion> getDetachedObjects() {
            final CDOID[] detachedObjects = this.commitContext.getDetachedObjects();
            return new IndexedList<CDOIDAndVersion>(){

                public CDOIDAndVersion get(int index) {
                    return CDOIDUtil.createIDAndVersion((CDOID)detachedObjects[index], (int)0);
                }

                public int size() {
                    return detachedObjects.length;
                }
            };
        }

        public synchronized CDOChangeKind getChangeKind(CDOID id) {
            if (this.changeKindCache == null) {
                this.changeKindCache = new CDOChangeKindCache((CDOChangeSetData)this);
            }
            return this.changeKindCache.getChangeKind(id);
        }
    }
}

