/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.mem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.internal.server.mem.MEMStore;
import org.eclipse.emf.cdo.internal.server.mem.MEMStoreChunkReader;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.LongIDStoreAccessor;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEMStoreAccessor
extends LongIDStoreAccessor
implements IStoreAccessor.Raw,
IStoreAccessor.DurableLocking {
    private final IQueryHandler testQueryHandler = new IQueryHandler(){

        public void executeQuery(CDOQueryInfo info, IQueryContext queryContext) {
            ArrayList<1> filters = new ArrayList<1>();
            Object context = info.getParameters().get("context");
            Long sleep = (Long)info.getParameters().get("sleep");
            if (context != null && context instanceof EClass) {
                final EClass eClass = (EClass)context;
                filters.add(new Object(){

                    public int hashCode() {
                        return eClass.hashCode();
                    }

                    public boolean equals(Object obj) {
                        InternalCDORevision revision = (InternalCDORevision)obj;
                        return revision.getEClass().equals(eClass);
                    }
                });
            }
            for (InternalCDORevision revision : MEMStoreAccessor.this.getStore().getCurrentRevisions()) {
                if (sleep != null) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                }
                boolean valid = true;
                for (Object e : filters) {
                    if (e.equals(revision)) continue;
                    valid = false;
                    break;
                }
                if (valid && !queryContext.addResult(revision)) break;
            }
        }
    };
    private List<InternalCDORevision> newRevisions = new ArrayList<InternalCDORevision>();

    public MEMStoreAccessor(MEMStore store, ISession session) {
        super((Store)store, session);
    }

    public MEMStoreAccessor(MEMStore store, ITransaction transaction) {
        super((Store)store, transaction);
    }

    @Override
    public MEMStore getStore() {
        return (MEMStore)super.getStore();
    }

    @Override
    public MEMStoreChunkReader createChunkReader(InternalCDORevision revision, EStructuralFeature feature) {
        return new MEMStoreChunkReader(this, (CDORevision)revision, feature);
    }

    @Override
    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        return Collections.emptySet();
    }

    @Override
    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        throw new UnsupportedOperationException();
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        return this.getStore().createBranch(branchID, branchInfo);
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        return this.getStore().loadBranch(branchID);
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        return this.getStore().loadSubBranches(branchID);
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        return this.getStore().loadBranches(startID, endID, branchHandler);
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        this.getStore().loadCommitInfos(branch, startTime, endTime, handler);
    }

    @Override
    public Set<CDOID> readChangeSet(OMMonitor monitor, CDOChangeSetSegment ... segments) {
        return this.getStore().readChangeSet(segments);
    }

    @Override
    public InternalCDORevision readRevision(CDOID id, CDOBranchPoint branchPoint, int listChunk, CDORevisionCacheAdder cache) {
        return this.getStore().getRevision(id, branchPoint);
    }

    @Override
    public InternalCDORevision readRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int listChunk, CDORevisionCacheAdder cache) {
        return this.getStore().getRevisionByVersion(id, branchVersion);
    }

    @Override
    public void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        this.getStore().handleRevisions(eClass, branch, timeStamp, exactTime, handler);
    }

    @Override
    protected void doCommit(OMMonitor monitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWrite(InternalCommitContext context, OMMonitor monitor) {
        MEMStore store;
        MEMStore mEMStore = store = this.getStore();
        synchronized (mEMStore) {
            super.doWrite(context, monitor);
        }
    }

    @Override
    protected void writeCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, OMMonitor monitor) {
        this.getStore().addCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRollback(IStoreAccessor.CommitContext context) {
        MEMStore store;
        MEMStore mEMStore = store = this.getStore();
        synchronized (mEMStore) {
            for (InternalCDORevision revision : this.newRevisions) {
                store.rollbackRevision(revision);
            }
        }
    }

    @Override
    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
    }

    @Override
    protected void writeRevisions(InternalCDORevision[] revisions, CDOBranch branch, OMMonitor monitor) {
        InternalCDORevision[] internalCDORevisionArray = revisions;
        int n = revisions.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision revision = internalCDORevisionArray[n2];
            this.writeRevision(revision);
            ++n2;
        }
    }

    protected void writeRevision(InternalCDORevision revision) {
        this.newRevisions.add(revision);
        this.getStore().addRevision(revision, false);
    }

    @Override
    protected void writeRevisionDeltas(InternalCDORevisionDelta[] revisionDeltas, CDOBranch branch, long created, OMMonitor monitor) {
        InternalCDORevisionDelta[] internalCDORevisionDeltaArray = revisionDeltas;
        int n = revisionDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevisionDelta revisionDelta = internalCDORevisionDeltaArray[n2];
            this.writeRevisionDelta(revisionDelta, branch, created);
            ++n2;
        }
    }

    protected void writeRevisionDelta(InternalCDORevisionDelta revisionDelta, CDOBranch branch, long created) {
        CDOID id = revisionDelta.getID();
        CDOBranchVersion version = revisionDelta.getBranch().getVersion(revisionDelta.getVersion());
        InternalCDORevision revision = this.getStore().getRevisionByVersion(id, version);
        if (revision.getVersion() != revisionDelta.getVersion()) {
            throw new ConcurrentModificationException("Trying to update object " + id + " that was already modified");
        }
        InternalCDORevision newRevision = revision.copy();
        newRevision.adjustForCommit(branch, created);
        revisionDelta.apply((CDORevision)newRevision);
        this.writeRevision(newRevision);
    }

    @Override
    protected void detachObjects(CDOID[] detachedObjects, CDOBranch branch, long timeStamp, OMMonitor monitor) {
        CDOID[] cDOIDArray = detachedObjects;
        int n = detachedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID id = cDOIDArray[n2];
            this.detachObject(id, branch, timeStamp);
            ++n2;
        }
    }

    protected void detachObject(CDOID id, CDOBranch branch, long timeStamp) {
        this.getStore().detachObject(id, branch, timeStamp);
    }

    @Override
    public void queryResources(IStoreAccessor.QueryResourcesContext context) {
        this.getStore().queryResources(context);
    }

    @Override
    public void queryXRefs(IStoreAccessor.QueryXRefsContext context) {
        this.getStore().queryXRefs(context);
    }

    @Override
    public IQueryHandler getQueryHandler(CDOQueryInfo info) {
        if ("TEST".equals(info.getQueryLanguage())) {
            return this.testQueryHandler;
        }
        return null;
    }

    @Override
    public void rawExport(CDODataOutput out, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        this.getStore().rawExport(out, fromBranchID, toBranchID, fromCommitTime, toCommitTime);
    }

    @Override
    public void rawImport(CDODataInput in, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        this.getStore().rawImport(in, fromBranchID, toBranchID, fromCommitTime, toCommitTime, monitor);
    }

    @Override
    public void rawStore(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        this.writePackageUnits(packageUnits, monitor);
    }

    @Override
    public void rawStore(InternalCDORevision revision, OMMonitor monitor) {
        this.getStore().addRevision(revision, true);
    }

    @Override
    public void rawStore(byte[] id, long size, InputStream inputStream) throws IOException {
        this.writeBlob(id, size, inputStream);
    }

    @Override
    public void rawStore(byte[] id, long size, Reader reader) throws IOException {
        this.writeClob(id, size, reader);
    }

    @Override
    public void rawStore(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, OMMonitor monitor) {
        this.writeCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, monitor);
    }

    @Override
    public void rawDelete(CDOID id, int version, CDOBranch branch, EClass eClass, OMMonitor monitor) {
        this.getStore().rawDelete(id, version, branch);
    }

    @Override
    public void rawCommit(double commitWork, OMMonitor monitor) {
    }

    public IDurableLockingManager.LockArea createLockArea(String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        return this.getStore().createLockArea(userID, branchPoint, readOnly, locks);
    }

    public IDurableLockingManager.LockArea getLockArea(String durableLockingID) throws IDurableLockingManager.LockAreaNotFoundException {
        return this.getStore().getLockArea(durableLockingID);
    }

    public void getLockAreas(String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
        this.getStore().getLockAreas(userIDPrefix, handler);
    }

    public void deleteLockArea(String durableLockingID) {
        this.getStore().deleteLockArea(durableLockingID);
    }

    @Override
    public void lock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToLock) {
        this.getStore().lock(durableLockingID, type, objectsToLock);
    }

    @Override
    public void unlock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToUnlock) {
        this.getStore().unlock(durableLockingID, type, objectsToUnlock);
    }

    @Override
    public void unlock(String durableLockingID) {
        this.getStore().unlock(durableLockingID);
    }

    @Override
    public void queryLobs(List<byte[]> ids) {
        this.getStore().queryLobs(ids);
    }

    @Override
    public void handleLobs(long fromTime, long toTime, CDOLobHandler handler) throws IOException {
        this.getStore().handleLobs(fromTime, toTime, handler);
    }

    @Override
    public void loadLob(byte[] id, OutputStream out) throws IOException {
        this.getStore().loadLob(id, out);
    }

    @Override
    protected void writeBlob(byte[] id, long size, InputStream inputStream) throws IOException {
        this.getStore().writeBlob(id, size, inputStream);
    }

    @Override
    protected void writeClob(byte[] id, long size, Reader reader) throws IOException {
        this.getStore().writeClob(id, size, reader);
    }

    protected void doActivate() throws Exception {
    }

    protected void doDeactivate() throws Exception {
        this.newRevisions.clear();
    }

    @Override
    protected void doPassivate() throws Exception {
    }

    @Override
    protected void doUnpassivate() throws Exception {
    }
}

